﻿var __area = null;
var __callingNew = null;
var __jobsort = null;
var zindex = 100;
var getZIndex = function() { return zindex++; };

var areaArrayToObject=function($array){
	var areaObject=[];
	for(var code in $array){
		var name= $array[code];
		var index=Math.floor(code / 1000000);
		var sub_index=Math.floor(code / 10000);
		var child_index=Math.floor(code / 100);
		var son_index=Math.floor(code % 100);
		
		
		
		
		if(code % 1000000 == 0){
			areaObject[index]={id:code,name:name,parentID:"",subAreas:[]};
		}else if (code % 1000000 != 0) {
			if (code % 10000 == 0) {
				var parentPlace=areaObject[index];
				parentPlace.subAreas[sub_index]={id:code,name:name,parentID:parentPlace.id,subAreas:[]};
			} else if (code % 100 == 0) {
				var parentPlace=areaObject[index].subAreas[sub_index];
				parentPlace.subAreas[child_index]={id:code,name:name,parentID:parentPlace.id,subAreas:[]};
			} else if (code % 100 != 0) {
				var parentPlace=areaObject[index].subAreas[sub_index].subAreas[child_index];
				parentPlace.subAreas[son_index]={id:code,name:name,parentID:parentPlace.id,subAreas:[]}; 
			}
		}    
	}
	
	/**
	var newArray=[];
	var index=0;
	for(var i in areaObject){
	    newArray[index]=areaObject[i];
		newArray[index].subAreas=buildIndex(newArray[index].subAreas);
		index++;
	}
	
	return newArray;
	*/
	
	return areaObject;
}

var jobArrayToObject=function($array){
	var jobObject=[];
	for(var i in $array){
	   var index=Math.floor(i/10000);
	   var subIndex=Math.floor(i/100);
	   var childIndex=Math.floor(i%100);
	   var name=$array[i];
	   if(i%10000==0){
	      jobObject[index]={name:name,subSorts:[],id:i};
	   }else{
	      if(i%100==0){
		    jobObject[index].subSorts[subIndex]={id:i,name:name,parentID:jobObject[index].id,subSorts:[]};
		  }else{
		     var parent=jobObject[index].subSorts[subIndex];
		     parent.subSorts[childIndex]={id:i,name:name,parentID:parent.id};
		  }
	   }
	}
	return jobObject;
}

var tradeArrayToObject=function($array){
	var tradeObject=[];
	for(var i in $array){
	   var index=Math.floor(i/100);
	   var subIndex=Math.floor(i%100);
	   var name=$array[i];
	   if(i%100==0){
	      tradeObject[index]={name: name, callings: []};
	   }else{
	      tradeObject[index].callings[subIndex]={name: name, id:i};
	   }
	}
	return tradeObject;
}

__area=areaArrayToObject(areaData);
__jobsort=jobArrayToObject(postData);
__callingNew=tradeArrayToObject(tradeData);
function getArea(id)
{
	
	var index=Math.floor(id / 1000000);
	var sub_index=Math.floor(id / 10000);
	var child_index=Math.floor(id / 100);
	var son_index=Math.floor(id % 100);
    if(id % 1000000==0){   
	   return __area[index];
	}else{
	    if (id % 10000 == 0) {
			var parentPlace=__area[index];
			return parentPlace.subAreas[sub_index];
		} else if (id % 100 == 0) {
			var parentPlace=__area[index].subAreas[sub_index];
			return parentPlace.subAreas[child_index];
		} else if (id % 100 != 0) {
			var parentPlace=__area[index].subAreas[sub_index].subAreas[child_index];
			return parentPlace.subAreas[son_index];
		}			
	}
}

function getAreaName(id)
{
    var area = getArea(id);
    if (area)
    {
        return area.name;
    } else
    {
        return '';
    }
}
function getSubAreas(id)
{
    id = id || '';
    if (id == '') return __area;
    var area = getArea(id);
    if (area && area.subAreas)
    {
        return area.subAreas;
    } else
    {
        return [];
    }
}

function getCalling(id)
{
    for (var i in __callingNew)
    {
        var c = __callingNew[i];
        for (var j in c.callings)
        {
            if (c.callings[j].id == id)
            {
                return c.callings[j]
            }
        }
    }
    return null;
}
function getCallingName(id)
{
    var c = getCalling(id);
    if (c) return c.name;
    return '';
}

function getJobsortLevel(id)
{
    if (id == '' || typeof id == 'undefined') return [];
    if (/\d{2}00/.test(id)) return [id];
    var arr = new Array();
    arr.push(id.substr(0, 2)+'00');
    arr.push(id);
    return arr;
}

function getJobsort(id)
{
    var l = __jobsort;
    for(var i in l)
    {
        var js = l[i].subSorts;
        for(var j in js)
        {
            if(js[j].id == id)
            {
                return js[j];
            }
            if(js[j].subSorts)
            {
                var subjs = js[j].subSorts;
                for(var k in subjs)
                {
                    if(subjs[k].id==id)
                    {
                        return subjs[k];
                    }
                }
            }
        }
    }
    return null;
}

function getJobsortName(id)
{
    var sort = getJobsort(id);
    if (sort)
    {
        return sort.name;
    } else
    {
        return '';
    }
}

function getSubSorts(id)
{
    id = id || '';
    if (id == '') return __jobsort;
    var sort = getJobsort(id);
    if (sort && sort.subSorts)
    {
        return sort.subSorts;
    } else
    {
        return [];
    }
}








//下拉列表展开事件
function toggleItemLi(obj) {
    if ($(obj).closest('span.verSelect').find('span.verSelectCon').is(":hidden")) {
        $('html').find('span.verSelect').removeClass('verSelectCu');
        $(obj).closest('span.verSelect').addClass('verSelectCu');
    }
    else {
        $(obj).closest('span.verSelect').removeClass('verSelectCu');
    }
}


//下拉列表选择项事件
function chooseItem(obj, isValidate,onchange) {
    $(obj).closest('ul').find('li').removeClass('cu');
    $(obj).addClass('cu');
    $(obj).closest('span.verSelect').find(':input').val($(obj).find('a').attr("thevalue"));
    $(obj).closest('span.verSelect').find('span.verSelectBg span.verSelectTxt').html($(obj).find('a').html());
    if (typeof onchange != 'undefined' && onchange instanceof Function) {
        onchange($(obj).closest('span.verSelect').find(':input').val(),obj);
    }
    if (isValidate) {
        $(obj).closest('form').validate().element($(obj).closest('span.verSelect').find(':input'));
    }
   
    $(obj).closest('span.verSelect').removeClass('verSelectCu');
}

(function dropdown($){

    function getSelectName(opt){
	   for(var i in opt.options){
	     var option=opt.options[i];
		 if(opt.selected==option.value){
		     return option.name;
		 }
	   }
	   return opt.teamL;
	}
    	

    $.fn.select = function(opt){
	    var _default={
		  inputName:'dropdown',
		  selected:1,
		  width:200
		};
	   opt = $.extend({}, _default, opt);
	
	   var str='<div class="teamL">'+opt.teamL+'</div>'+
                '<div class="teamR">'+
                '<span class="verSelect">'+
				'<input type="hidden" id="'+opt.inputName+'" name="'+opt.inputName+'" value="'+opt.selected+'" />'+
				'<span class="verSelectBg" onclick="toggleItemLi(this)">'+
				'<span style="width:'+opt.width+'px;" class="verSelectTxt">'+getSelectName(opt)+'</span>'+
				'</span><span  style="height:150px;overflow:auto;width:'+(opt.width+36)+'px;overflow-y:scroll;height:120px" class="verSelectCon">'+
				'<ul>';
	   var options=this.find('options');
	   options.children().each(function(){
	       var option={};
		   option.value=$(this).val();
		   option.name=$(this).text();
	       str+='<li onclick="chooseItem(this,false,\'\');return false;"><a href="javascript:void(0);" title="'+option.name+'" theValue="'+option.value+'">'+option.name+'</a></li>';
	       $(this).remove();
	   });
	   options.remove();
	   //for(var i in opt.options){
	     // var option=opt.options[i];
          //str+='<li onclick="chooseItem(this,false,\'\');return false;"><a href="javascript:void(0);" title="'+option.name+'" theValue="'+option.value+'">'+option.name+'</a></li>';		   
	   //}
	   str+='</ul></span></span></div>';
	   $html=$(str);
	   this.append($html);
	}

})(jQuery);



//地区选择框
(function AreaSelect($) {
    var id = 0;
    var getTempID = function() {
        id++;
        return '_areaOptions' + id;
    }
    var _default = {
        multi: true, //多选模式
        selectTo: null,
        getValues: null, //获取值的回调
        max: null, //最大选中个数
        inputName: 'area', //单选或复选表单的name属性
        values: null,
		formInputName:'placeid',
		defaultSelect:'32000000'
    };

    var containerHtml = '<div class="choice choiceRegion">' +
					    '	<div class="choiceCon">' +
					    '		<div class="choiceContent">' +
                        '			<div class="choiceTit"><a href="javascript:void(0)" title="关闭" class="choiceClose" id="_btnClose"></a><h3>地区选择</h3></div>' +
	                   ' <div class="choiceTxt">' +
    	               '     <p id="title">请选择地区：</p><p id="_limit"></p>' +
                       '     <div class="choiceTopBtn">' +
                       '         <a href="javascript:void(0)" class="btn2 _btnAreaOk" id="_btnAreaOk"><b class="L"></b><b class="R"></b>确定</a>' +
        	           '         <a href="javascript:void(0)" class="btn1 _btnAreaClear" id="_btnAreaClear"><b class="L"></b><b class="R"></b>清空</a>' +
                       '     </div>' +
                       '     <div class="clear"></div>' +
                       ' </div>' +
                       ' <div class="choiceAll" id="_topArea">' +
                       ' </div>' +
	                   ' <div class="choiceLst">' +
    	               '     <ul id="_list">' +
                       '     </ul>' +
                       '     <div class="clear"></div>' +
                       ' </div>' +
    	               '     <p class="tit">您已选择了以下区域：</p>' +
                       '     <div class="choiceSelected">' +
                       '         <ul id="_selected">' +
                       '         </ul>' +
                       '         <div class="clear"></div>' +
                       '     </div>' +
                       '	 <div id="_tempHidden"></div>' +
					   '     <div class="choiceBotBtn">' +
                       '         <a href="javascript:void(0)" class="btn2 _btnAreaOk" id="_btnAreaOk"><b class="L"></b><b class="R"></b>确定</a>' +
        	           '         <a href="javascript:void(0)" class="btn1 _btnAreaClear" id="_btnAreaClear"><b class="L"></b><b class="R"></b>清空</a>' +
                       '     </div>'
                       '</div>' ;

    var subListHtml = '<div class="choiceLstLower" style="display:none;">' +
        	        '    <ul id="_sublist">' +
                    '    </ul>' +
                    '    <div class="clear"></div>' +
					   '	</div>'
					'	</div>'
                    '</div>';
    var AreaClass = function(opt, el) {
        this.options = $.extend({}, _default, opt);
		this.options.multi=this.options.max>1;
        this.container = null;
        this.selected = null;
        this.mask = null; //遮罩层
        this.selectTo = this.options.selectTo;
        this.hidden = $('<em>');
        this.tempHidden = null;
		this.showTag=el;
		
	    var newHidden='<input type="hidden" name="'+this.options.formInputName+'" id="'+this.options.formInputName+'" value="">';
        if($('#'+this.options.formInputName).length==0){
			el.after($(newHidden));
		}		
		el.after(this.hidden);
        this.list = null;
        this.topArea = null;
        var self = this;
        this.createWindow = function(areas) {
            this.container = $(containerHtml);
            if (typeof this.selectTo == 'string') {
                this.selectTo = $(this.selectTo);
            }
            //取消自动添加到选中功能
            this.selectTo = null;

            this.tempHidden = this.container.find('#_tempHidden');
            this.selected = this.container.find('#_selected')
            this.list = this.container.find('#_list');
            this.topArea = this.container.find('#_topArea');
            if (this.options.max > 0 && this.options.multi) {
                this.container.find('#_limit').html('您最多可以选择<span class="orange">' + self.options.max + '</span>个区域');
            }
            var select = $('<select>');
            for (var i in areas) {
                var a = areas[i];
                select.append($('<option value="' + a.id + '">' + a.name + '</option>'));
            }
            select.change(function() { self.changeArea(); });
            select.val(this.options.defaultSelect); //默认选中重庆
            this.container.find('#title').append(select);
            //关闭
            this.container.find('#_btnClose').click(function() {
                self.container.find('.choiceLstLower').remove();
				self.container.find('.lstShow').removeClass('lstShow');
                self.hide();
                return false;
            });
            //确定
            this.container.find('._btnAreaOk').click(function() {
         
                self.hidden.html(self.tempHidden.html());
                self.onChanged();
                self.container.find('.choiceLstLower').remove();
				self.container.find('.lstShow').removeClass('lstShow');
                self.hide();
                return false;
            });
            this.container.find('._btnAreaClear').click(function() {
                self.tempHidden.empty();
                self.selected.empty();
                self.selected.empty();
                self.topArea.find(':input').attr({ checked: false });
                self.list.find(':input').attr({ checked: false, disabled: false }).closest('li').removeClass('cu');
                //self.syncToList();
                return false;
            });
            this.container.click(this.hideSubArea);
        };

        this.bodyKeydown = function(event) {
            var e = $.event.fix(event);
            if (e.keyCode == 27) {
                self.close();
            } else if (e.keyCode == 13) {
                self.container.find('._btnAreaOk').click();
            }
        }

        this.hideSubArea = function(event) {
            var e = $.event.fix(event);
            if ($(e.target).closest('.choiceLstLower').length == 0) {
                self.container.find('.choiceLstLower').remove();
				self.container.find('li.lstShow').removeClass('lstShow');
            }

            //显示子级选择
            if ((e.target.nodeName.toLowerCase() == 'li' || $(e.target).parent()[0].nodeName.toLowerCase() == 'li') && $.contains(self.list[0], e.target)) {
                var li = $(e.target).closest('li');
                var chkInput = li.find(':input');
                var areaID = chkInput.val();
                var a = getArea(areaID);
                if (a.subAreas&&a.subAreas.length>0) {
					li.addClass("lstShow");
                    var anchor = li.find('a');
                    var pos = li.position();
                    var div = self.createSubArea(a, chkInput);
                    var zindex = getZIndex();
                    div.css('z-index', zindex);
                    var left = pos.left + li.outerWidth() + 2 ;
                    //通过A的位置修正现在的位置
                    //left = left - (li.outerWidth() - (anchor.position().left + anchor.width())) + 15;
					left = left - (li.outerWidth());
					//var top = pos.top;
                    var top = pos.top + 26;
                    var posOffset = self.list.closest('.choice').offset();
                    var wnd = $(window);
                    if (posOffset.left + left + div.outerWidth() > wnd.scrollLeft() + wnd.width()) left -= posOffset.left + left + div.outerWidth() - wnd.scrollLeft() - wnd.width() + 1;
                    if (posOffset.top + top + div.outerHeight() > wnd.scrollTop() + wnd.height()) top -= posOffset.top + top + div.outerHeight() - wnd.scrollTop() - wnd.height() + 1;
                    div.css({ left: left, top: top });
                    div.show();
                }
            }
        }

        this.fillArea = function(a) {
            var areas = a.subAreas;
            for (var i in areas) {
                var id = getTempID();
                var a = areas[i];
                var v = createListItem(a);
                if (a.subAreas) {
                    var icon = $('<a href="javascript:void(0)" class="lower" onclick="return false;"></a><div class="clear"></div>');
                    v.append(icon);
                }
                self.list.append(v);
            }
        };

        //检查当前编号是否已选中
        this.checkSelected = function(id) {
            return self.tempHidden.find(':input[value=' + id + ']').length > 0;
        }

        this.createSubArea = function(a, el) {
            var areas = a.subAreas;
            var div = $(subListHtml);
            div.attr('id', '_subareas' + a.id);
            var list = div.find('#_sublist');
            var parentChecked = el.attr('checked');
            for (var i in areas) {
                var a = areas[i];
                var v = createListItem(a);
                list.append(v);
            }
            self.list.after(div);
            //如果父结点选中了，自动选中子节点并禁用
            div.hover(null, function() {
				div.parents('.choiceLst').find('ul li.lstShow').removeClass('lstShow');
            	div.remove();
            });
            if (self.options.multi && parentChecked) {
                div.find(':input').attr({ 'checked': true, disabled: true });
            }
            return div;
        };

        this.changeArea = function() {
            self.topArea.empty();
            self.list.empty();
            var sel = this.container.find('select');
            var id = sel.val();
            var a = getArea(id);
            if (a) {
                var v = createListItem(a, true);
                self.topArea.append(v);
                if (a.subAreas) {
                    self.topArea.append('<font color="red">（选择此大类，将包含以下所有小类）</font>');
                    self.fillArea(a);
                    self.list.closest('div').show();
                } else {
                    self.list.closest('div').hide();
                }
            }
            self.syncToList();
        }

        var createListItem = function(a, isTop) {
            var id = getTempID();
            var v = null;
            if (isTop) {
                v = $('<label for="_area' + id + '"><input type="' + getInpuType() + '" id="_area' + id + '" isTop="true" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label>');
            } else {
                v = $('<li><label for="_area' + id + '"><input type="' + getInpuType() + '" id="_area' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>');
            }
            if (self.checkSelected(a.id)) {
                v.find(':input').attr({ checked: true }).closest('li').addClass('cu');
            }
            v.find(':input').click(function() {
                var values = new Array();
                self.tempHidden.find(':input[name=' + self.options.inputName + ']').each(function() {
                    values.push($(this).val());
                });
                if (self.options.multi && $(this).attr('checked') && values && self.options.max && self.options.max > 0) {
                    //去掉当前选择的所有已选中的下级项后再计算已选择的个数，因为先中上级后会取消掉下级项目
                    /**for (var i = 0; i < values.length; i++) {
                        var level = getAreaLevel(values[i]);
                        if ($.inArray($(this).val(), level) >= 0) {
                            values.pop(values[i--]);
                        }
                    }*/
                    if (values.length >= self.options.max) {
                        $.anchorMsg('您最多可以选择<span class="orange">' + self.options.max + '</span>个区域', { icon: 'warning', timeout: 1 });
                        return false;
                    }
                }
                var input = $(this);
				var input_value_id=input.val();
                var a = getArea(input_value_id);
                if (input.attr('checked')) {
                    self.removeSubSelected(a, isTop);
                    self.addToSelected(a, isTop);
                } else {
                    self.removeFromSelected(a);
                }
            });
            return v;
        }
        this.removeSubSelected = function(a, isTop) {
            if (!self.options.multi) return;
            if (isTop) {
                self.list.find(':input[checked]').each(function() {
                    var el = $(this);
                    el.attr({ checked: false, disabled: true });
                    el.closest('li').removeClass('cu');
                    self.selected.find(':input[value=' + el.val() + ']').closest('li').remove();
                    self.tempHidden.find(':input[value=' + a.id + ']').remove();
                });
                if (a.subAreas) {
                    for (var i in a.subAreas) {
                        self.removeSubSelected(a.subAreas[i]);
                    }
                }
            } else {
                if (a.subAreas) {
                    for (var i in a.subAreas) {
                        var area = a.subAreas[i];
                        self.selected.find(':input[value=' + area.id + ']').closest('li').remove()
                        self.tempHidden.find(':input[value=' + area.id + ']').remove();
                    }
                }
            }
        }
        var createSelectItem = function(a, isTop) {
            var id = getTempID();
            var v = $('<li><label for="_areaS' + id + '"><input type="' + getInpuType() + '" id="_areaS' + id + '" value="' + a.id + '" isTop="' + (isTop || false) + '" checked="checked" />' + a.name + '</label></li>');
            v.click(function() {
                self.container.find('.choiceLstLower').remove();
                var a = getArea($(this).find(':input').val());
                self.removeFromSelected(a);
                //$(this).remove();
                //self.syncToList();
            });
            return v;
        }

        var getInpuType = function() {
            return self.options.multi ? 'checkbox' : 'radio';
        }

        //将选中的区域内容同步到列表中
        this.syncToList = function() {
            self.selected.empty();
            self.topArea.find('[checked]').attr({ checked: false });
            self.list.find('[checked]').attr({ checked: false, disabled: false }).closest('li').removeClass('cu');
            self.tempHidden.find(':input[name=' + self.options.inputName + ']').each(function() {
                var el = $(this);
                var val = el.val();
                var a = getArea(val);
                if (a) {
                    var v = createSelectItem(a);
                    self.selected.append(v);
                }
                var topInput = self.topArea.find(':input[value=' + val + ']');
                if (topInput[0]) {
                    topInput.attr({ checked: true });
                    if (self.options.multi) {
                        self.list.find(':input').attr({ checked: true, disabled: true });
                    }
                } else {
                    self.list.find(':input[value=' + val + ']').attr({ checked: true }).closest('li').addClass('cu');
                }
            });
        }

        this.addToSelected = function(a, isTop) {
            if (!self.options.multi) {
                self.tempHidden.empty();
                self.selected.empty();
                self.list.parent().find(':input').attr({ disabled: false }).closest('li').removeClass('cu');
            }
            var v = createSelectItem(a);
            self.selected.append(v);
            self.tempHidden.append($('<input type="hidden" isTop="' + (isTop || false) + '" name="' + self.options.inputName + '" value="' + a.id + '">'));
            if (isTop) {
                if (self.options.multi) {
                    self.list.find(':input').attr({ checked: true, disabled: true });
                }
            } else {
                self.list.parent().find(':input[value=' + a.id + ']').closest('li').addClass('cu');
            }
        }

        this.removeFromSelected = function(a) {
            var input = self.tempHidden.find(':input[value=' + a.id + ']');
            if (input.attr('isTop') == 'true') {
                self.list.find(':input').attr({ checked: false, disabled: false });
                self.topArea.find('[value=' + a.id + ']').attr({ checked: false }).removeClass('cu');
            } else {
                self.list.find(':input[value=' + a.id + ']').attr({ checked: false }).closest('li').removeClass('cu');
            }
            input.remove();
            var chk = self.selected.find(':input[value=' + a.id + ']');
            if (chk.length > 0) chk.closest('li').remove();
        }

        this.onChanged = function() {
            var data=self.values();
			var html = '', i = 0, len = data.length;
            var selectIds='';
			for (i; i < len; i++) {
                var d = data[i];
                html += getAreaName(d) + '+';
				selectIds+=d+",";
            }
            if (html.length > 1) {
                html = html.substring(0, html.length - 1);
				selectIds = selectIds.substring(0, selectIds.length - 1);
                this.showTag.attr('title', html);
            }
            else {
                this.showTag.attr('title', '');
            }
            if (html.length > 10) {
                html = html.substring(0, 10) + '...';
            }
            if (html.length > 0) {
			//alert(this.showTag.get(0).tagName);
				if(this.showTag.get(0).tagName=='INPUT'){
				   this.showTag.val(html);
				}else{
					html = '<b>' + html + '</b>';
					this.showTag.html(html);
				}
            }
            else {
               if(this.showTag.get(0).tagName=='INPUT'){
				   this.showTag.val('请选择工作地点');
				}else{
				 this.showTag.html('<b>请选择工作地点</b>');
				}
            }
            $('#'+this.options.formInputName).val(selectIds);
          
        }

        //返回区域编号的数组
        this.values = function(vals) {
            if (typeof vals == 'undefined') {
                var vals = new Array();
                this.hidden.find(':input[name=' + this.options.inputName + ']').each(function() {
                    vals.push($(this).val());
                });
                return vals;
            } else {
                if (typeof vals == 'string') {
                    var v = vals;
                    vals = new Array();
                    vals.push(v);
                }
                this.hidden.empty();
                if (this.selectTo) this.selectTo.empty();
                for (var i in vals) {
                    var a = getArea(vals[i]);
                    if (a) {
                        //this.addToSelected(a);
                        self.hidden.append($('<input type="hidden" name="' + self.options.inputName + '" value="' + a.id + '">'));
                    }
                }
                if (self.container.is(':visible')) self.syncToList();
                this.onChanged();
            }
        }
        //添加选中的值
        this.addValue = function(val) {
            var values = this.values();
            var exists = false;
            for (var i in values) {
                if (val == values[i]) {
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                values.push(val);
                this.values(values);
            }
            return this.values();
        }
        //移除已选中的值
        this.removeValue = function(val) {
            var values = this.values();
            var newValues = new Array();

            var isInSub = function(val, v) {
                if (v == val) return true;
                var subAreas = getSubAreas(val);
                var inSub = false;
                for (var i in subAreas) {
                    inSub = isInSub(subAreas[i].id, v);
                    if (inSub) break;
                }
                return inSub;
            }
            for (var i in values) {
                var v = values[i];
                if (v != val) {
                    var inSub = false;
                    inSub = isInSub(val, v);
                    if (!inSub) newValues.push(v);
                }
            }
            this.values(newValues);
            return this.values();
        }

        this.show = function() {
            self.mask.css({ 'z-index': getZIndex() });
            self.container.css({ 'z-index': getZIndex() });
            self.anchoToCenter();
            self.mask.animate({ opacity: 0.5 }, 500).show();
            self.container.show();
            self.container.find('._btnAreaOk').focus();
            self.tempHidden.html(self.hidden.html());
            self.syncToList();
            $('body').keydown(self.bodyKeydown);
        };

        this.close = this.hide = function() {
            var self = this.mask;
            this.mask.animate({ opacity: 0 }, { complete: function() {self.hide();} });
            this.container.hide();
            $('body').unbind('keydown', self.bodyKeydown);
        };

        this.toggle = function() {
            if (this.container.is(':visible')) {
                self.hide();
            } else {
                self.show();
            }
        };

        this.anchoToCenter = function() {
            var doc = $(document);
            var wnd = $(window);
            var left = (wnd.width() - self.container.width()) / 2 + wnd.scrollLeft();
            var top = (wnd.height() - self.container.height()) / 2 + wnd.scrollTop();
            self.container.css({ left: left, top: top });
//            self.mask.css({ width: wnd.width(), height: doc.height() });
        };

        this.createWindow(__area);
        var isIE6 = $.browser.msie && ($.browser.version == "6.0");
        if (isIE6) {
            this.mask = $('<div class="dialogMask"></div>')
				.appendTo('body').hide().css(
				{
				    width: $(document).width(),
				    height: $(document).height(),
				    position: 'absolute'
				}).bgiframe();
            $(window).resize(function() {
                var docHeight = $(document).height() - 4;
                var docWidth = $(document).width() - 4;
                self.mask.css('height', docHeight);
                self.mask.css('width', docWidth);
                //self.anchoToCenter();
            });
        }
        else {
            this.mask = $('<div class="dialogMask"></div>')
				.appendTo('body').hide().bgiframe();
        }
        this.container.css({ position: 'absolute', left: -1000, top: -1000 }).appendTo('body').hide();
        this.changeArea();
        
        /*
        $('body').mousedown(function(event)
        {
        var e = $.event.fix(event);
        var src = e.target;
        //如果是在模式窗口内也不关闭
        if ($(src).closest('._dialog').length > 0) return;
        if (self.container[0] == src || $.contains(self.container[0], src)) return;
        if (el[0] == src || $.contains(el[0], src)) return;
        self.hide();
        });*/
    }

    $.fn.bindArea = function(opt) {
		this.click(function(event) {
           var area=$(this).data('area');
           area.toggle();
		});
        var area = new AreaClass(opt, this);
        this.data('area', area);
        return this;
    };

    $.fn.areaValues = function(val) {
        var area = this.data('area');
        return area.values(val);
    }

    $.fn.addAreaValue = function(val) {
        var area = this.data('area');
        return area.addValue(val);
    }

    $.fn.removeAreaValue = function(val) {
        var area = this.data('area');
        return area.removeValue(val);
    }
})(jQuery);


//职位类别选择框
(function JobSelect($)
{
    var id = 0;
    var getTempID = function()
    {
        id++;
        return '_jobSortTemp' + id;
    }
    var _default = {
        multi: true, //多选模式
        selectTo: '',
        getValues: null, //获取值的回调
        max: null, //最大选中个数
        inputName: 'jobsort', //单选或复选表单的name属性
        values: null,
		formInputName:'positionid'
    };
								
   	var containerHtml = '<div class="choice choiceJobs">' +
					   '	<div class="choiceCon">' +
					   '		<div class="choiceContent">' +
                       '<div class="choiceTit"><h3>职位类别选择</h3><a href="javascript:void(0)" id="_btnClose" class="choiceClose"></a></div>' +
	                   '			<div class="choiceTxt">' +
	                   '				<p id="_limit"></p>' +
                       '				<div class="choiceTopBtn">' +
                       '					<a href="javascript:void(0)" class="btn2 _btnAreaOk" id="_btnAreaOk"><b class="L"></b><b class="R"></b>确定</a>' +
        	           '					<a href="javascript:void(0)" class="btn1 _btnAreaClear" id="_btnAreaClear"><b class="L"></b><b class="R"></b>清空</a>' +
                       '				</div>' +
                       '				<div class="clear"></div>' +
                       '			</div>' +
	                   '			<div class="choiceLst">' +
    	               '				<table id="_list" width="100%"></table>' +
                       '			</div>' +
    	               '     <p class="tit">您选择的职位类别是：</p>' +
    	               '     <div class="choiceSelected">' +
                       '         <ul id="_selected">' +
                       '         </ul>' +
                       '         <div class="clear"></div>' +
                       '     </div>' +
                       '		<div id="_tempHidden" style="display:none;"></div>' +
					   '     <div class="choiceBotBtn">' +
                       '         <a href="javascript:void(0)" class="btn2 _btnAreaOk" id="_btnAreaOk"><b class="L"></b><b class="R"></b>确定</a>' +
        	           '         <a href="javascript:void(0)" class="btn1 _btnAreaClear" id="_btnAreaClear"><b class="L"></b><b class="R"></b>清空</a>' +
                       '     </div>'
                       '</div>';
    var subListHtml = '<div class="choiceLstLower" style="display:none;">' +
        	        '    <ul id="_sublist">' +
                    '    </ul>' +
                    '    <div class="clear"></div>' +
                    '</div>';
    var JobClass = function(opt, el)
    {
        this.options = $.extend({}, _default, opt);
		this.options.multi=this.options.max>1;
        this.container = null;
        this.selected = null;
        this.mask = null; //遮罩层
        this.selectTo = this.options.selectTo;
        this.hidden = $('<em>');
        this.tempHidden = null;
        el.after(this.hidden);
		var newHidden='<input type="hidden" name="'+this.options.formInputName+'" id="'+this.options.formInputName+'" value="">';
        if($('#'+this.options.formInputName).length==0){
			el.after($(newHidden));
		}	
		this.formEL=el;
        this.list = null;
        this.topJob = null;
        var self = this;
        this.createWindow = function(sorts)
        {
            this.container = $(containerHtml);
            if (typeof this.selectTo == 'string')
            {
                this.selectTo = $(this.selectTo);
            }
            //取消自动添加到选中功能
            this.selectTo = null;

            this.tempHidden = this.container.find('#_tempHidden');
            this.selected = this.container.find('#_selected')
            this.list = this.container.find('#_list');

            if (this.options.max > 0 && this.options.multi)
            {
                this.container.find('#_limit').html('您最多可以选择<span class="orange">' + self.options.max + '</span>个职位类别');
            }
            //关闭
            this.container.find('#_btnClose').click(function()
            {
                self.container.find('.choiceLstLower').remove();
                self.hide();
                return false;
            });
            //确定
            this.container.find('._btnAreaOk').click(function()
            {
                self.hidden.html(self.tempHidden.html());
                self.onChanged();
                self.container.find('.choiceLstLower').remove();
                self.hide();
                return false;
            });
            this.container.find('._btnAreaClear').click(function()
            {
                self.tempHidden.empty();
                self.selected.empty();
                self.list.find(':input').attr({ checked: false, disabled: false }).removeClass('cu');
                return false;
            });

            for (var i in sorts)
            {
                var id = getTempID();
                var c = sorts[i];
                var row = $('<tr ' + (i % 2 == 0 ? 'class="another"' : '') + '></tr>');
                row.append($('<th width="196" align="center" valign="middle">' + c.name + '</th>'));
                var td = $('<td><ul></ul></td>').appendTo(row);
                var ul = td.find('ul');
                for (var j in c.subSorts)
                {
                     var a = c.subSorts[j];
                    // var v = $('<li style="visibility:visible;width:133px;height:22px;" onmouseover="this.className=\'hov\'" onmouseout="this.className=\' \'"/>').attr('id',a.id).css({'cursor': 'pointer','padding-right': '15px'}).html(a.name);//.prepend('<label for="_sort' + id + '">' + a.name + '</label>')
                    
                    var v = $('<li />').attr('id',a.id).css({'cursor': 'pointer'}).prepend('<label for="_sort' + id + '">' + a.name + '</label>').mouseover(function(e)
                    {
                        $(this).addClass('hov');
                        return false;
                    }).mouseout(function(e)
                    {
                        $(this).removeClass('hov');
                        return false;
                    });
                    /*if(a.subSorts)
                    //{
                        var icon = $('<a href="javascript:void(0)" class="lower" onclick="return false;"></a><div class="clear"></div>');
                        v.append(icon);
                    }*/
                    ul.append(v);
                }
                this.list.append(row);
            }
            this.syncToList();
            this.container.click(this.hideSubJobsort);
        };
        this.bodyKeydown = function(event)
        {
            var e = $.event.fix(event);
            if (e.keyCode == 27)
            {
                self.close();
            } else if (e.keyCode == 13)
            {
                self.container.find('._btnAreaOk').click();
            }
        }
        this.hideSubJobsort = function(event)
        {
            var e = $.event.fix(event);
            if ($(e.target).closest('.choiceLstLower').length == 0)
            {
                self.container.find('.choiceLstLower').remove();
            }
            //显示子级
            if ((e.target.nodeName.toLowerCase() == 'li' || $(e.target).parent()[0].nodeName.toLowerCase() == 'li') && $.contains(self.list[0], e.target))
            {
                var li = $(e.target).closest('li');
                var chkInput = li.find(':input');
                var sortID = 0;
                if (chkInput.length > 0)
                {
                    sortID = chkInput.val();
                } else
                {
                    sortID = li.attr('id');
                }            
                var a = getJobsort(sortID);
                if (a.subSorts)
                {
                    //var anchor = li.find('a');
                    var pos = li.position();
                    var div = self.createSubJobsort(a);
                    var zindex = getZIndex();
                    div.css('z-index', zindex);
                    var left = pos.left + li.outerWidth();
                    //通过A的位置修正现在的位置
                    left = left - li.outerWidth() + 15;
                    var top = pos.top;
                    var posOffset = self.list.closest('.choice').offset();
                    var wnd = $(window);
                    if (posOffset.left + left + div.outerWidth() > wnd.scrollLeft() + wnd.width()) left -= posOffset.left + left + div.outerWidth() - wnd.scrollLeft() - wnd.width() + 1;
                    if (posOffset.top + top + div.outerHeight() > wnd.scrollTop() + wnd.height()) top -= posOffset.top + top + div.outerHeight() - wnd.scrollTop() - wnd.height() + 1;
                    div.css({ left: left, top: top });
                    div.show();
                }
            }
        }

        this.fillJobsort = function(a)
        {
            var sorts = a.subSorts;
            for (var i in sorts)
            {
                var id = getTempID();
                var a = sorts[i];
                var v = createListItem(a);
                /*if (a.subSorts)
                {
                    var icon = $('<a href="javascript:void(0)" class="lower" onclick="return false;"></a><div class="clear"></div>');
                    v.append(icon);
                }*/
                self.list.append(v);
            }
        };
        //检查当前编号是否已选中
        this.checkSelected = function(id)
        {
            return self.tempHidden.find(':input[value=' + id + ']').length > 0;
        }
        this.createSubJobsort = function(a)
        {
            var sorts = a.subSorts;
            var div = $(subListHtml);
            div.attr('id', '_subSorts' + a.id);
            var list = div.find('#_sublist');
            var header = createListItem(a);
            if(a.subSorts.length > 16)
            {

            }else
            {

            }
            
            list.append(header.addClass('choiceLstLowerTit'));
            var parentChecked = self.checkSelected(a.id);
            for (var i in sorts)
            {
                var sub = sorts[i];
                var v = createListItem(sub);
                list.append(v);
            }
            self.list.after(div);
            //如果父结点选中了，自动选中子节点并禁用
            if (self.options.multi && parentChecked)
            {
                list.find(':input').attr({ checked: true, disabled: true });
            }
            list.find(':input[value=' + a.id + ']').attr({ disabled: false });
            div.mouseleave(function()
            {
                if (div.data('clicked'))
                {
                    div.remove();
                }
            });
            return div;
        };

        var createListItem = function(a)
        {
            var id = getTempID();
            //var v = $('<li style="visibility: visible;" onmouseover="this.className=\'hov\'" onmouseout="this.className=\' \'"><label for="_sort' + id + '"><input type="' + getInpuType() + '" id="_sort' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>');
            
            var v = $('<li><label for="_sort' + id + '"><input type="' + getInpuType() + '" id="_sort' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>').mouseenter(function(e)
            {
                $(this).addClass('hov');
                //e.stopPropagation();
                return false;
            }).mouseleave(function(e)
            {
                $(this).removeClass('hov');
                //e.stopPropagation();
                return false;  
            });
            if (self.checkSelected(a.id))
            {
                v.find(':input').attr({ checked: true }).closest('li').addClass('cu');
            }
            v.find(':input').click(function()
            {
                var el = $(this);
                var values = new Array();
                self.tempHidden.find(':input[name=' + self.options.inputName + ']').each(function()
                {
                    values.push($(this).val());
                });
                if (self.options.multi && el.attr('checked') && values && self.options.max && self.options.max > 0)
                {
                    //去掉当前选择的所有已选中的下级项止后再计算已选择的个数，因为先中上级后会取消掉下级项目
                    for (var i = 0; i < values.length; i++)
                    {
                        var level = getJobsortLevel(values[i]);
                        if ($.inArray(el.val(), level) >= 0)
                        {
                            values.pop(values[i--]);
                        }
                    }
                    if (values.length >= self.options.max)
                    {
                        $.anchorMsg('您最多可以选择<span class="orange">' + self.options.max + '</span>个职位类别', { icon: 'warning', timeout: 1 });
                        return false;
                    }
                }
                var a = getJobsort(el.val());
                if (el.attr('checked'))
                {
                    self.removeSubSelected(a);
                    self.addToSelected(a);
                } else
                {
                    self.removeFromSelected(a);
                }
                //设置已点击过的属性
                el.closest('div').data('clicked', true);
            });
            return v;
        }
        this.removeSubSelected = function(a)
        {
            if (a.subSorts)
            {
                for (var i in a.subSorts)
                {
                    var area = a.subSorts[i];
                    if (self.options.multi)
                    {
                        self.list.parent().find(':input[value=' + area.id + ']').attr({ checked: true, disabled: true }).closest('li').removeClass('cu');
                    } else
                    {
                        self.list.parent().find(':input[value=' + area.id + ']').closest('li').removeClass('cu');
                    }
                    var area = a.subSorts[i];
                    self.selected.find(':input[value=' + area.id + ']').closest('li').remove()
                    self.tempHidden.find(':input[value=' + area.id + ']').remove();
                }
            }
        }
        var createSelectItem = function(a)
        {
            var id = getTempID();
            var v = $('<li><label for="_sortS' + id + '"><input type="' + getInpuType() + '" id="_sortS' + id + '" value="' + a.id + '" checked="checked" />' + a.name + '</label></li>');
            v.click(function()
            {
                self.container.find('.choiceLstLower').remove();
                var a = getJobsort($(this).find(':input').val());
                self.removeFromSelected(a);
                self.container.find('._btnAreaOk').focus();
            });
            return v;
        }

        var getInpuType = function()
        {
            return self.options.multi ? 'checkbox' : 'radio';
        }

        //将选中的区域内容同步到列表中
        this.syncToList = function()
        {
            self.selected.empty();
            self.list.find('[checked]').attr({ checked: false, disabled: false }).closest('li').removeClass('cu');
            self.tempHidden.find(':input[name=' + self.options.inputName + ']').each(function()
            {
                var el = $(this);
                var val = el.val();
                var a = getJobsort(val);
                if (a)
                {
                    var v = createSelectItem(a);
                    self.selected.append(v);
                }
                self.list.find(':input[value=' + val + ']').attr({ checked: true }).closest('li').addClass('cu');
            });
        }

        this.addToSelected = function(a)
        {
            if (!self.options.multi)
            {
                self.tempHidden.empty();
                self.selected.empty();
                self.list.parent().find(':input').attr({ disabled: false }).closest('li').removeClass('cu');
            }
            var v = createSelectItem(a);
            self.selected.append(v);
            self.tempHidden.append($('<input type="hidden" name="' + self.options.inputName + '" value="' + a.id + '">'));
            self.list.parent().find(':input[value=' + a.id + ']').closest('li').addClass('cu');
        }

        this.removeFromSelected = function(a)
        {
            var input = self.tempHidden.find(':input[value=' + a.id + ']');
            self.list.parent().find(':input[value=' + a.id + ']').attr({ checked: false }).closest('li').removeClass('cu');
            if (a.subSorts)
            {
                for (var i in a.subSorts)
                {
                    self.list.parent().find(':input[value=' + a.subSorts[i].id + ']').attr({ checked: false, disabled: false });
                }
            }
            input.remove();
            var chk = self.selected.find(':input[value=' + a.id + ']');
            if (chk.length > 0) chk.closest('li').remove();

        }
        this.onChanged = function()
        {
            var data=self.values();
			var html = '',
		    selectValue='',
			i = 0,
			len = data.length;
			for (i; i < len; i++) {
				var d = data[i];
				html += getJobsortName(d) + '+';
				selectValue += d + ',';
			}
			if (html.length > 1) {
				html = html.substring(0, html.length - 1);
				selectValue = selectValue.substring(0, selectValue.length - 1);
				self.formEL.attr('title', html);
			} else {
				self.formEL.attr('title', '');
			}
			if (html.length > 10) {
				html = html.substring(0, 10) + '...';
			}
			
			if (html.length > 0) {
                   if(this.formEL.get(0).tagName=='INPUT'){
						this.formEL.val(html);
					}else{
						html = '<b>' + html + '</b>';
						this.formEL.html(html);
					}
                } else {
                   if(this.formEL.get(0).tagName=='INPUT'){
						this.formEL.val('请选择职位类别');
					}else{
						
						this.formEL.html('<b>请选择职位类别</b>');
					}
                }

			$('#'+self.options.formInputName).val(selectValue);
        
        }

        //返回区域编号的数组
        this.values = function(vals)
        {
            if (typeof vals == 'undefined')
            {
                var vals = new Array();
                this.hidden.find(':input[name=' + this.options.inputName + ']').each(function()
                {
                    vals.push($(this).val());
                });
                return vals;
            } else
            {
                if (typeof vals == 'string')
                {
                    //this.container.find(':input[name=' + self.options.inputName + ']').removeAttr('checked');
                    var v = vals;
                    vals = new Array();
                    vals.push(v);
                }
                this.hidden.empty();
                if (this.selectTo) this.selectTo.empty();
                for (var i in vals)
                {
                    var a = getJobsort(vals[i]);
                    if (a)
                    {
                        //this.addToSelected(a);
                        self.hidden.append($('<input type="hidden" name="' + self.options.inputName + '" value="' + a.id + '">'));
                    }
                }
                if (self.container.is(':visible')) self.syncToList();
                this.onChanged();
            }
        }
        //添加选中的值
        this.addValue = function(val)
        {
            var values = this.values();
            var exists = false;
            for (var i in values)
            {
                if (val == values[i])
                {
                    exists = true;
                    break;
                }
            }
            if (!exists)
            {
                values.push(val);
                this.values(values);
            }
            return this.values();
        }
        //移除已选中的值
        this.removeValue = function(val)
        {
            var values = this.values();
            var newValues = new Array();

            var isInSub = function(val, v)
            {
                if (v == val) return true;
                var subSorts = getSubSorts(val);
                var inSub = false;
                for (var i in subSorts)
                {
                    inSub = isInSub(subSorts[i].id, v);
                    if (inSub) break;
                }
                return inSub;
            }
            for (var i in values)
            {
                var v = values[i];
                if (v != val)
                {
                    var inSub = false;
                    inSub = isInSub(val, v);
                    if (!inSub) newValues.push(v);
                }
            }
            this.values(newValues);
            return this.values();
        }
        this.show = function()
        {
            self.mask.css({ 'z-index': getZIndex() });
            self.container.css({ 'z-index': getZIndex() });
            self.anchoToCenter();
            self.mask.animate({ opacity: 0.5 }, 500).show();
            self.container.show();
            self.container.find('._btnAreaOk').focus();
            self.tempHidden.html(self.hidden.html());
            self.syncToList();
            $('body').keydown(self.bodyKeydown);
        };

        this.close = this.hide = function()
        {
            var self = this.mask;
            this.mask.animate({ opacity: 0 }, { complete: function() {self.hide();} });
            this.container.hide();
            $('body').unbind('keydown', self.bodyKeydown);
        };

        this.toggle = function()
        {
            if (this.container.is(':visible'))
            {
                self.hide();
            } else
            {
                self.show();
            }
        };

        this.anchoToCenter = function()
        {
            var doc = $(document);
            var wnd = $(window);
            var left = (wnd.width() - self.container.width()) / 2 + wnd.scrollLeft();
            var top = (wnd.height() - self.container.height()) / 2 + wnd.scrollTop();
            self.container.css({ left: left, top: top });
//            self.mask.css({ width: wnd.width(), height: doc.height() });
        };

        this.createWindow(__jobsort);
        var isIE6 = $.browser.msie && ($.browser.version == "6.0");
        if (isIE6) {
            this.mask = $('<div class="dialogMask"></div>')
				.appendTo('body').hide().css(
				{
				    width: $(document).width(),
				    height: $(document).height(),
				    position: 'absolute'
				}).bgiframe();
            $(window).resize(function() {
                var docHeight = $(document).height() - 4;
                var docWidth = $(document).width() - 4;
                self.mask.css('height', docHeight);
                self.mask.css('width', docWidth);
                //self.anchoToCenter();
            });
        }
        else {
            this.mask = $('<div class="dialogMask"></div>')
				.appendTo('body').hide().bgiframe();
        }
        this.container.css({ position: 'absolute', left: -1000, top: -1000 }).appendTo('body').hide();
        el.click(function()
        {
            self.toggle();
        });
        /*
        $('body').mousedown(function(event)
        {
        var e = $.event.fix(event);
        var src = e.target;
        //如果是在模式窗口内也不关闭
        if ($(src).closest('._dialog').length > 0) return;
        if (self.container[0] == src || $.contains(self.container[0], src)) return;
        if (el[0] == src || $.contains(el[0], src)) return;
        self.hide()
        });*/
    }

    $.fn.bindJobsort = function(opt)
    {   
		this.click(function(event) {
            event.preventDefault();
        });
        var sort = new JobClass(opt, this);
        this.data('sort', sort);
        return this;
    };
    
    $.fn.showJobsort = function()
    {
        var jobsort = this.data('sort'); 
        jobsort.show();
        return this;
    };

    $.fn.jobsortValues = function(val)
    {
        var sort = this.data('sort');
        return sort.values(val);
    }
    $.fn.addJobsortValue = function(val)
    {
        var sort = this.data('sort');
        return sort.addValue(val);
    }
    $.fn.removeJobsortValue = function(val)
    {
        var sort = this.data('sort');
        return sort.removeValue(val);
    }
})(jQuery);

//行业选择框
(function CallingSelect($) {
    var id = 0;
    var getTempID = function() {
        id++;
        return '_callingTemp' + id;
    }
    var _default = {
        multi: true, //多选模式
        selectTo: '',
        getValues: null, //获取值的回调
        max: 5, //最大选中个数
        inputName: 'calling', //单选或复选表单的name属性
        values: null,
		formInputName:'tradeid'
    };
	

    var containerHtml = '<div class="choice choiceIndustry">' +
					   '	<div class="choiceCon">' +
					   '		<div class="choiceContent">' +
                       '			<div class="choiceTit"><h3>行业选择</h3><a href="javascript:void(0)" id="_btnClose" class="choiceClose"></a></div>' +
	                   '			<div class="choiceTxt">' +
	                   '				<p id="_limit"></p>' +
                       '				<div class="choiceTopBtn">' +
                       '					<a href="javascript:void(0)" class="btn2 _btnAreaOk" id="_btnAreaOk"><b class="L"></b><b class="R"></b>确定</a>' +
        	           '					<a href="javascript:void(0)" class="btn1 _btnAreaClear" id="_btnAreaClear"><b class="L"></b><b class="R"></b>清空</a>' +
                       '				</div>' +
                       '				<div class="clear"></div>' +
                       '			</div>' +
					   
	                   '			<div class="choiceLst">' +
                       '				<table id="_list" width="100%"></table>' +
					   '				<div class="clear"></div>' +
                       '			</div>' +
    	               '			<p class="tit">您选择的行业是：</p>' +
                       '			<div class="choiceSelected">' +
                       '				<ul id="_selected">' +
                       '				</ul>' +
                       '				<div class="clear"></div>' +
                       '			</div>' +
                       '			<div id="_tempHidden" style="display:none;"></div>' +
					   '     <div class="choiceBotBtn">' +
                       '         <a href="javascript:void(0)" class="btn2 _btnAreaOk" id="_btnAreaOk"><b class="L"></b><b class="R"></b>确定</a>' +
        	           '         <a href="javascript:void(0)" class="btn1 _btnAreaClear" id="_btnAreaClear"><b class="L"></b><b class="R"></b>清空</a>' +
                       '     </div>'
					   '		</div>' +
					   '	</div>' +
                       '</div>';
    var CallingClass = function(opt, el) {
        this.options = $.extend({}, _default, opt);
		this.options.multi=this.options.max>1;
        this.container = null;
        this.selected = null;
        this.mask = null; //遮罩层
        this.hidden = $('<em>');
        this.tempHidden = null;
        el.after(this.hidden);
		var newHidden='<input type="hidden" name="'+this.options.formInputName+'" id="'+this.options.formInputName+'" value="">';
        if($('#'+this.options.formInputName).length==0){
			el.after($(newHidden));
		}	
		this.formEL=el;
        this.list = null;
        this.topJob = null;
        var self = this;
        this.createWindow = function(callings) {
            this.container = $(containerHtml);

            this.tempHidden = this.container.find('#_tempHidden');
            this.selected = this.container.find('#_selected')
            this.list = this.container.find('#_list');

            if (this.options.max > 0 && this.options.multi) {
                this.container.find('#_limit').html('您最多可以选择<span class="orange">' + self.options.max + '</span>个行业');
            }
            //关闭
            this.container.find('#_btnClose').click(function() {
                self.hide();
                return false;
            });
            //确定
            this.container.find('._btnAreaOk').click(function() {
                self.hidden.html(self.tempHidden.html());
                self.onChanged();
                self.hide();
                return false;
            });
            this.container.find('._btnAreaClear').click(function() {
                self.tempHidden.empty();
                self.selected.empty();
                self.list.find(':input').attr({ checked: false, disabled: false }).closest('li').removeClass('cu');
                return false;
            });
            for (var i in __callingNew) {
                var c = __callingNew[i];
                var row = $('<tr ' + (i % 2 == 0 ? 'class="another"' : '') + '></tr>');
                row.append($('<th width="100" align="center" valign="middle" >' + c.name + '</th>'));
                var td = $('<td><ul></ul></td>').appendTo(row);
                var ul = td.find('ul');
                for (var j in c.callings) {
                    var a = c.callings[j];
                    var v = createListItem(a, j);
                    ul.append(v);
                }
                this.list.append(row);
            }
            this.syncToList();
        };
        this.bodyKeydown = function(event) {
            var e = $.event.fix(event);
            if (e.keyCode == 27) {
                self.close();
            } else if (e.keyCode == 13) {
                self.container.find('._btnAreaOk').click();
            }
        }
        var createListItem = function(a, j) {
        var index = parseInt(j) + 1;
            var id = getTempID();
            if (index % 4 == 0) {
                var v = $('<li class="choice_lst_li4"><label for="_calling' + id + '"><input type="' + getInpuType() + '" id="_calling' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>');
            }else if (index % 2 == 0) {
                var v = $('<li class="choice_lst_li2"><label for="_calling' + id + '"><input type="' + getInpuType() + '" id="_calling' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>');
            }else if ((index+1) % 4 == 0) {
                var v = $('<li class="choice_lst_li3"><label for="_calling' + id + '"><input type="' + getInpuType() + '" id="_calling' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>');
            }else{
                var v = $('<li class="choice_lst_li1"><label for="_calling' + id + '"><input type="' + getInpuType() + '" id="_calling' + id + '" name="_list' + self.options.inputName + '" value="' + a.id + '" />' + a.name + '</label></li>');
            }
            v.find(':input').click(function() {
                var values = new Array();
                self.tempHidden.find(':input[name=' + self.options.inputName + ']').each(function() {
                    values.push($(this).val());
                });
                if (self.options.multi && $(this).attr('checked') && values && self.options.max && self.options.max > 0 && values.length >= self.options.max) {
                    $.anchorMsg('您最多可以选择<span class="orange">' + self.options.max + '</span>个行业', { icon: 'warning', timeout: 1 });
                    return false;
                }
                var input = $(this);
                var a = getCalling(input.val());
                if (input.attr('checked')) {
                    self.addToSelected(a);
                } else {
                    self.removeFromSelected(a);
                }
            });
            return v;
        }
        var createSelectItem = function(a) {
            var id = getTempID();
            var v = $('<li><label for="_callingS' + id + '"><input type="' + getInpuType() + '" id="_callingS' + id + '" value="' + a.id + '" checked="checked" />' + a.name + '</label></li>');
            v.click(function() {
                self.removeFromSelected(a);
                self.container.find('._btnAreaOk').focus();
            });
            return v;
        }

        var getInpuType = function() {
            return self.options.multi ? 'checkbox' : 'radio';
        }

        //将选中的区域内容同步到列表中
        this.syncToList = function() {
            self.list.find('[checked]').attr({ checked: false, disabled: false }).closest('li').removeClass('cu');
            self.selected.empty();
            self.tempHidden.find(':input[name=' + self.options.inputName + ']').each(function() {
                var el = $(this);
                var val = el.val();
                var a = getCalling(val);
                if (a) {
                    var v = createSelectItem(a);
                    self.selected.append(v);
                }
                self.list.find(':input[value=' + val + ']').attr({ checked: true }).closest('li').addClass('cu');
            });
        }
        this.addToSelected = function(a) {
            if (!self.options.multi) {
                self.tempHidden.empty();
                self.selected.empty();
                self.list.find(':input').attr({ disabled: false }).closest('li').removeClass('cu');
            }
            var v = createSelectItem(a);
            self.selected.append(v);
            self.tempHidden.append($('<input type="hidden" name="' + self.options.inputName + '" value="' + a.id + '">'));
            self.list.find(':input[value=' + a.id + ']').attr({ checked: true }).closest('li').addClass('cu');
        }

        this.removeFromSelected = function(a) {
            self.tempHidden.find(':input[value=' + a.id + ']').remove();
            var chk = self.selected.find(':input[value=' + a.id + ']');
            if (chk.length > 0) chk.closest('li').remove();
            self.list.find(':input[value=' + a.id + ']').attr({ checked: false }).closest('li').removeClass('cu');
        }

        this.onChanged = function() {
			    var data=this.values();
				var selectValue='';
                var html = '',
                i = 0,
                len = data.length;
                for (i; i < len; i++) {
                    var d = data[i];
                    html += getCallingName(d) + '+';
					selectValue+=d+',';
                }
                if (html.length > 1) {
                    html = html.substring(0, html.length - 1);
					selectValue = selectValue.substring(0, selectValue.length - 1);
                    this.formEL.attr('title', html);
                } else {
                    this.formEL.attr('title', '');
                }
                if (html.length > 10) {
                    html = html.substring(0, 10) + '...';
                }
                if (html.length > 0) {
                   if(this.formEL.get(0).tagName=='INPUT'){
						this.formEL.val(html);
					}else{
						html = '<b>' + html + '</b>';
						this.formEL.html(html);
					}
                } else {
                   if(this.formEL.get(0).tagName=='INPUT'){
						this.formEL.val('请选择行业类别');
					}else{
						
						this.formEL.html('<b>请选择行业类别</b>');
					}
                }
               $('#'+this.options.formInputName).val(selectValue);				
        }
        //返回区域编号的数组
        this.values = function(vals) {
            if (typeof vals == 'undefined') {
                var vals = new Array();
                this.hidden.find(':input[name=' + this.options.inputName + ']').each(function() {
                    vals.push($(this).val());
                });
                return vals;
            } else {
                if (typeof vals == 'string') {
                    //this.container.find(':input[name=' + self.options.inputName + ']').removeAttr('checked');
                    var v = vals;
                    vals = new Array();
                    vals.push(v);
                }
                this.hidden.empty();
                if (this.selectTo) this.selectTo.empty();
                for (var i in vals) {
                    var a = getCalling(vals[i]);
                    if (a) {
                        //this.addToSelected(a);
                        self.hidden.append($('<input type="hidden" name="' + self.options.inputName + '" value="' + a.id + '">'));
                    }
                }
                if (self.container.is(':visible')) self.syncToList();
                this.onChanged();
                return this.values();
            }
        }

        //添加选中的值
        this.addValue = function(val) {
            var values = this.values();
            var exists = false;
            for (var i in values) {
                if (val == values[i]) {
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                values.push(val);
                this.values(values);
            }
            return this.values();
        }
        //移除已选中的值
        this.removeValue = function(val) {
            var values = this.values();
            var newValues = new Array();

            for (var i in values) {
                var v = values[i];
                if (v != val) {
                    newValues.push(v);
                }
            }
            this.values(newValues);
            return this.values();
        }

        this.show = function() {
            this.mask.css({ 'z-index': getZIndex() });
            this.container.css({ 'z-index': getZIndex() });
            self.anchoToCenter();
            this.mask.animate({ opacity: 0.5 }, 500).show();
            this.container.show();
            self.container.find('._btnAreaOk').focus();
            self.tempHidden.html(self.hidden.html());
            self.syncToList();
            $('body').keydown(self.bodyKeydown);
        };

        this.close = this.hide = function() {
            var self = this.mask;
            this.mask.animate({ opacity: 0 }, { complete: function() {self.hide();} });
            this.container.hide();
            $('body').unbind('keydown', self.bodyKeydown);
        };

        this.toggle = function() {
            if (this.container.is(':visible')) {
                self.hide();
            } else {
                self.show();
            }
        };

        this.anchoToCenter = function() {
            var doc = $(document);
            var wnd = $(window);
            var left = (wnd.width() - self.container.width()) / 2 + wnd.scrollLeft();
            var top = (wnd.height() - self.container.height()) / 2 + wnd.scrollTop();
            self.container.css({ left: left, top: top });
//            self.mask.css({ width: wnd.width(), height: doc.height() });
        };

        this.createWindow(__callingNew);
        var isIE6 = $.browser.msie && ($.browser.version == "6.0");
        if (isIE6) {
            this.mask = $('<div class="dialogMask"></div>')
				.appendTo('body').hide().css(
				{
				    width: $(document).width(),
				    height: $(document).height(),
				    position: 'absolute'
				}).bgiframe();
            $(window).resize(function() {
                var docHeight = $(document).height() - 4;
                var docWidth = $(document).width() - 4;
                self.mask.css('height', docHeight);
                self.mask.css('width', docWidth);
                //self.anchoToCenter();
            });
        }
        else {
            this.mask = $('<div class="dialogMask"></div>')
				.appendTo('body').hide().bgiframe();
        }
        this.container.css({ position: 'absolute', left: -1000, top: -1000 }).appendTo('body').hide();
        el.click(function() {
            self.toggle();
        });
        /*
        $('body').mousedown(function(event)
        {
        var e = $.event.fix(event);
        var src = e.target;
        //如果是在模式窗口内也不关闭
        if ($(src).closest('._dialog').length > 0) return;
        if (self.container[0] == src || $.contains(self.container[0], src)) return;
        if (el[0] == src || $.contains(el[0], src)) return;
        self.hide()
        });*/
    }

    $.fn.bindCalling = function(opt) {
		this.click(function(event) {
			event.preventDefault();
		});
        var calling = new CallingClass(opt, this);
        this.data('calling', calling);
        return this;
    };

    $.fn.showCalling = function() {
        var calling = this.data('calling');
        calling.show();
        return this;
    };

    $.fn.callingValues = function(val) {
        var calling = this.data('calling');
        return calling.values(val);
    }
    $.fn.addCallingValue = function(val) {
        var calling = this.data('calling');
        return calling.addValue(val);
    };

    $.fn.removeCallingValue = function(val) {
        var calling = this.data('calling');
        return calling.removeValue(val);
    }
})(jQuery);
(function($){


$.fn.bgIframe = $.fn.bgiframe = function(s)
{
    //因发现ie7也出现这个问题，所以不管什么浏览器都加上
    //if ($.browser.msie && /6.0/.test(navigator.userAgent))
    try
    {
        s = $.extend({ top: 'auto', left: 'auto', width: 'auto', height: 'auto', opacity: true, src: 'javascript:void(0);'
        }, s || {});

        var prop = function(n)
        {
            return n && n.constructor == Number ? n + 'px' : n;
        };
        var width = this.outerWidth(true);
        var height = this.outerHeight(true);
        //var html = '<iframe class="bgiframe" frameborder="0"tabindex="-1"src="' + s.src + '"' + 'style="display:block;position:absolute;z-index:-1;' + (s.opacity !== false ? 'filter:Alpha(Opacity=\'0\');' : '') + 'top:' + (s.top == 'auto' ? 'expression(((parseInt(this.parentNode.currentStyle.borderTopWidth)||0)*-1)+\'px\')' : prop(s.top)) + ';' + 'left:' + (s.left == 'auto' ? 'expression(((parseInt(this.parentNode.currentStyle.borderLeftWidth)||0)*-1)+\'px\')' : prop(s.left)) + ';' + 'width:' + (s.width == 'auto' ? 'expression(this.parentNode.offsetWidth+\'px\')' : prop(s.width)) + ';' + 'height:' + (s.height == 'auto' ? 'expression(this.parentNode.offsetHeight+\'px\')' : prop(s.height)) + ';' + '"/>';
        var html = this.find('.bgiframe');
        if (html.length > 0)
        {
            html.remove();
        }
        html = '<iframe class="bgiframe" frameborder="0" tabindex="-1"src="javascript:void(0)"' + 'style="display:block;position:absolute;z-index:-1;' + (s.opacity !== false ? 'filter:Alpha(Opacity=\'0\');' : '') + 'top:' + (s.top == 'auto' ? '0px' : prop(s.top)) + ';' + 'left:' + (s.left == 'auto' ? '0px' : prop(s.left)) + ';' + 'width:' + prop(width) + ';' + 'height:' + prop(height) + ';' + '"/>';
        this.prepend(html);
       
    } catch (e) { }
    return this;
};

})(jQuery);



/**
* dialog.js
* @category   javascript
* @package    jquery
* @author     dongzh
* @version    
*/
(function($)
{
    var contextData = '_dialog';
    var cachedata = {};
    var arrweebox = new Array();
    var dialogID = 0;
    var getID = function() { return dialogID++; }
    var getElement = function(obj)
    {
        if ($.isPlainObject(obj)) return obj;
        if (typeof (obj) == 'string') return $(obj);
        return obj;
    }
    var errorHtml =
    '            	<div class="dialogError">' +
    '            		非常抱歉，数据加载失败' +
    '                </div>' +
    '               <div class="dialogPopBtn"><a class="btn2" onclick="$(this).closeDialog();" href="javascript:void(0)"><b class="L"></b><b class="R"></b>关&nbsp;闭</a></div>';

    var tooltipError = '<div class="dialogError">非常抱歉，数据加载失败</div>';

    var weebox = function(opt)
    {
        //var self = this;
        this.id = '';
        this.dh = null;
        this.mh = null;
        this.dc = null;
        this.dt = null;
        this.header = null; //窗口头部，包括关闭按钮
        this.dw = null; //窗口内部装内容的部分，设置宽度时就设置这个
        this.db = null;
        this._dragging = false;
        this.cachedContent = null;
        this.options = null;
        this.contentInited = false;
        this._defaults = {
            src: null, //当弹出confirm对话框时引用的原Jquery对象，在事件函数的时候会以参数传回去
            cache: false,
            type: 'dialog', //类型 message confirm dialog model hover anchor menu等
            title: '',
            width: 0,
            height: 0,
            maskClass: 'dialogMask', //遮罩层的class名称
            timeout: 0,
            draggable: true,
            modal: true,    //是否模态
            focus: null,
            blur: null,
            left: 0,
            top: 0,
            position: 'center',
            anchorPosition: true, //是否始终定位在某一位置，只在某些状态下有效
            dependElement: null,
            keepHover: null, //要保持浮动窗口的节点，当点击在这些节点内时不会关闭浮动窗口
            overlay: 30,
            icon: '',
            showBackground: true,
            showBorder: true,
            showHeader: true,
            showButton: true,
            showCancel: true,
            showClose: true,
            showOk: true,
            showMask: true, //是否显示遮罩
            okBtnName: '确定',
            cancelBtnName: '取消',
            content: '',
            contentType: 'text',
            contentChange: false,
            clickClose: false,
            animate: '',
            showAnimate: '',
            hideAnimate: '',
            onclose: null, //事件
            onopen: null,
            oncancel: null,
            onok: null,
            
            select: { url: '', type: 'radio', tele: '', vele: '', width: 120, search: false, fn: null }
        };

        var self = this;

        //初始化选项
        this.initOptions = function()
        {
            var tempOpt = opt || {};
            tempOpt.animate = tempOpt.animate || '';
            tempOpt.showAnimate = tempOpt.showAnimate || tempOpt.animate;
            tempOpt.hideAnimate = tempOpt.hideAnimate || tempOpt.animate;
            self.options = $.extend({}, this._defaults, tempOpt);
        };

        //初始化弹窗Box
        this.initBox = function()
        {
            if (self.options.id)
            {
                self.id = self.options.id;
            } else
            {
                self.id = getID();
            }
            var html = '';
            switch (self.options.type)
            {
                case 'anchor': //定位于屏幕某一位置的窗口
                    var iconClass = '';
                    switch (self.options.icon)
                    {
                        case 'success':
                            iconClass = 'success';
                            break;
                        case 'fail':
                            iconClass = 'fail';
                            break;
                        case 'warning':
                            iconClass = 'warning';
                            break;
                        case 'question':
                            iconClass = 'question';
                            break;
                        case 'info':
                            iconClass = 'info';
                            break;
                    }
                    if (self.options.position == 'anchorRight')
                    {
                        html = '<div class="_dialog dialog" id="_dialog' + self.id + '" style="padding:0;">' +
						'	<table border="0" cellspacing="0" cellpadding="0">' +
						'		<tr>' +
						'			<td class="dialog-cl"></td>' +
						'			<td>' +
						'				<div class="_container _dialogContent dialogContent" style="padding:0;overflow:inherit"></div>' +
						'			</td>' +
						'			<td class="dialog-cr"></td>' +
						'		</tr>' +
						'	</table>' +
						'</div>';
                    } else
                    {
                        html = '<div class="_dialog" id="_dialog' + self.id + '">' +
							   '	<div class="prompt"><b class="L"></b><b class="R"></b>' +
                               '    	<div class="promptTxt ' + (!(self.options.icon == 'warning' || self.options.icon == 'fail') ? 'promptS' : 'promptF') + '">' +
                               '    		<div class="_dialogContent"></div>' +
                               '    	</div>' +
							   '    </div>'
        					   '</div>';
                    }
                    break;
                case 'message': //提示窗口
                case 'confirm': //确认窗口
                    var iconClass = '';
                    switch (self.options.icon)
                    {
                        case 'success':
                            iconClass = 'popS';
                            break;
                        case 'fail':
                            iconClass = 'popF';
                            break;
                        case 'warning':
                            iconClass = 'popW';
                            break;
                        case 'question':
                            iconClass = 'popQ';
                            break;
                        case 'info':
                            iconClass = 'popI';
                            break;
                    }
                    html = '<div class="_dialog dialog" id="_dialog' + self.id + '">' +
					'	<div class="dialogCon">' +
                    '    <div class="dialogHead _dialogHeader"><span class="_title">系统消息</span><a href="javascript:void(0)" class="dialogClose _dialogClose" title="关闭"></a></div> ' +
						'	<table border="0" cellspacing="0" cellpadding="0">' +
						'		<tr>' +
						'			<td class="dialog-cl"></td>' +
						'			<td>' +
						'				<div class="_container dialogContent ' + iconClass + '"><div class="_dialogContent popTxt"></div>' +
						'				<div class="_dialog-button dialogPopBtn">' +
						'					<a href="javascript:void(0)" class="btn2 dialog-ok _dialogOk"><b class="L"></b><b class="R"></b>确&nbsp;定</a>' +
						'					<a href="javascript:void(0)" class="btn1 dialog-cancel _dialogCancel"><b class="L"></b><b class="R"></b>取&nbsp;消</a>' +
						'				</div>' +
						'</div>' +
						'			</td>' +
						'			<td class="dialog-cr"></td>' +
						'		</tr>' +
						'	</table>' +
						'	</div>' +
						'</div>';
                    break;
                case 'modal': //模式窗口
                    //self.options.maskClass='resumemask';
                case 'dialog': //非模式窗口
                    html = '<div class="_dialog dialog" id="_dialog' + self.id + '">' +
						'<div class="dialogCon">' +
                        '	<div class="dialogHead _dialogHeader"><span class="_title">系统消息</span><a href="javascript:void(0)" class="dialogClose _dialogClose" title="关闭"></a></div> ' +
						'	<table border="0" cellspacing="0" cellpadding="0">' +
						'		<tr>' +
						'			<td class="dialog-cl"></td>' +
						'			<td>' +
						'				<div class="_container _dialogContent dialogContent"></div>' +
						'			</td>' +
						'			<td class="dialog-cr"></td>' +
						'		</tr>' +
						'	</table>' +
						'</div>' +
						'</div>';
                    break;
					
				case 'running':
                    html = '<div class="_dialog dialog" id="_dialog' + self.id + '" style="padding:0;">' +
						'<div class="dialogCon"  style="background:none;_overflow:hidden;border:0;">' +
                        '	<div class="dialogHead _dialogHeader"><span class="_title">系统消息</span><a href="javascript:void(0)" class="dialogClose _dialogClose" title="关闭"></a></div> ' +
						'	<table border="0" cellspacing="0" cellpadding="0">' +
						'		<tr>' +
						'			<td class="dialog-cl"></td>' +
						'			<td>' +
						'				<div class="_container _dialogContent dialogContent" style="padding:0;overflow:inherit"></div>' +
						'			</td>' +
						'			<td class="dialog-cr"></td>' +
						'		</tr>' +
						'	</table>' +
						'</div>' +
						'</div>';
			         break;
                case 'menu': //菜单
                    html = '<div class="_dialog dialog dialogosilde" id="_dialog' + self.id + '">' +
						'				<div class="_container _dialogContent dialogContent"></div>' +
						'</div>';
                    break;
                case 'hover': //浮动窗口
                    html = '<div class="_dialog dialog" id="_dialog' + self.id + '">' +
						'				<div class="_container _dialogContent dialogContent"></div>' +
						'</div>';
                    break;
                case 'tooltip': //气泡
                    html = '<div class="_dialog floatlayer_con _tooltip" style="" id="_dialog' + self.id + '">' +
                           '    <div id="_arrow" class="floatlayer_arrow_left"></div>' +
                           '    <table cellpadding="0" cellspacing="0" >' +
        	               '         <tbody>' +
            	           '             <tr class="floatlayer_con_top">' +
                           '                 <td class="floatlayer_con_top_l" width="5">&nbsp;</td>' +
                           '                 <td class="floatlayer_con_top_c">&nbsp;</td>' +
                           '                 <td class="floatlayer_con_top_r" width="5">&nbsp;</td>' +
                           '             </tr>' +
                           '             <tr class="floatlayer_con_con">' +
                	       '                 <td class="floatlayer_con_con_l">&nbsp;</td>' +
                           '                 <td class="floatlayer_con_con_c _container _dialogContent">' +
                           '                 </td>' +
                           '                 <td class="floatlayer_con_con_r">&nbsp;</td>' +
                           '             </tr>' +
                           '             <tr class="floatlayer_con_bot">' +
                	       '                 <td class="floatlayer_con_bot_l">&nbsp;</td>' +
                           '                 <td class="floatlayer_con_bot_c">&nbsp;</td>' +
                           '                 <td class="floatlayer_con_bot_r">&nbsp;</td>' +
                           '             </tr>' +
                           '         </tbody>' +
                           '    </table>' +
                           '</div>';
                    html = '<div class="_dialog _tooltip floatlayer" id="_dialog' + self.id + '">' +
                            '        <div id="_arrow" class="floatlayer_arrow_left"></div>' +
                            '    <div class=" _container _dialogContent floatlayer_con">' +
                    //'        <div class=" test" style="_white-space:nowrap;"></div>' +
                            '    </div>' +
                            '</div>';
                    break;
                case 'img': //图片
                    html = '<div class="_dialog" id="_dialog' + self.id + '"></div>';
                    break;
            }
            //如果是菜单，加到指定的位置里
            if (self.options.type == 'menu')
            {
                self.dh = $(html).appendTo(self.options.container || 'body').css({
                    position: 'absolute',
                    //    overflow: 'hidden',
                    zIndex: getZIndex(),
                    left: -1000,
                    top: -1000
                });
            } else
            {
                self.dh = $(html).appendTo('body').css({
                    position: 'absolute',
                    //    overflow: 'hidden',
                    zIndex: getZIndex(),
                    left: -1000,
                    top: -1000
                });
            }
            if (self.options.type == 'message' || self.options.type == 'confirm')
            {
                self.dh.addClass('confirmWidth');
            }
            self.dc = self.find('._dialogContent');
            self.dt = self.find('._title');
            self.dw = self.find('._container');
            self.header = self.find('._dialogHeader');
            self.db = self.find('._dialogButton');

            if (self.options.boxclass)
            {
                self.dh.addClass(self.options.boxclass);
            }
            if (self.options.height > 0)
            {
                self.dc.css('height', self.options.height);
            }
            if (self.options.width > 0)
            {
                self.dw.css('width', self.options.width);
            }
            if (self.options.position == 'anchorRight')
            {
                self.dh.addClass('anchorRight');
            }

            self.setTitle(self.options.title);
           if(self.options.showMask) self.dh.bgiframe();
            self.dh.data(contextData, self);
        }

        //初始化遮照
        this.initMask = function()
        {
            if (self.options.showMask && (self.options.type == 'modal' || self.options.type == 'message' || self.options.type == 'confirm'))
            {
                /*if ($.browser.msie) 
                {
                h = document.compatMode == "CSS1Compat" ? document.documentElement.clientHeight : document.body.clientHeight;
                w = document.compatMode == "CSS1Compat" ? document.documentElement.clientWidth : document.body.clientWidth;
                } else */
                var h, w;
                var wnd = $(window);
                var doc = $(document);
                if (doc.height() > wnd.height())
                {
                    h = doc.height() - 5; //self.bheight();
                    w = doc.width() - 21;
                } else
                {
                    h = doc.height() - 5; //self.bheight();
                    w = doc.width() - 5;
                }
                //临时用于type=modeal的遮罩层样式
                if(self.options.type == 'modal')self.options.maskClass='dialogMask';

			    var isIE6=$.browser.msie&&($.browser.version=="6.0");
			    if(isIE6)
			    {
                    self.mh = $('<div id="_mask' + self.id + '" class="' + self.options.maskClass + '"></div>')
				    .appendTo('body').hide().css(
				    {
				        width: w,
				        height: h,
				        position:'absolute',
				        zIndex: getZIndex()
				    }).animate({opacity: 0.3},200).bgiframe();
			        $(window).resize(function()
                    {
                        var h, w;
                        var wnd = $(window);
                        var doc = $(document);
                        if (doc.height() > wnd.height())
                        {
                            h = doc.height() - 5; //self.bheight();
                            w = doc.width() - 21;
                        } else
                        {
                            h = doc.height() - 5; //self.bheight();
                            w = doc.width() - 5;
                        }
                        self.mh.css({ height: h, width: w });
                    });
			    }
			    else
			    {
                    self.mh = $('<div id="_mask' + self.id + '" class="' + self.options.maskClass + '"></div>')
				    .appendTo('body').hide().css(
				    {
				        //width: w,
				        //height: h,
				        zIndex: getZIndex()
				    }).animate({opacity: 0.3},200).bgiframe();			    
			    }
			    
            }
        }

        this.setTitle = function(title)
        {
            if (title == '')
            {
                self.dt.html('&nbsp;');
            } else
            {
                self.dt.html(title);
            }
        }

        //初始化弹窗内容
        this.initContent = function(content)
        {
            self.dh.find("._dialogOk").val(self.options.okBtnName);
            self.dh.find("._dialogCancel").val(self.options.cancelBtnName);
            if (self.options.title == '')
            {
                self.dt.html('&nbsp;');
            } else
            {
                self.dt.html(self.options.title);
            }
            if (!self.options.showHeader)
            {
                self.header.hide();
            }
            if (!self.options.showBorder)
            {
                self.dh.css({ border: 'none' });
                self.dc.css({ border: 'none' });
            }
            if (!self.options.showBackground)
            {
                self.dh.css({ background: 'none' });
                self.dc.css({ background: 'none' });
            }
            if (!self.options.showButton)
            {
                self.dh.find('._dialogButton').hide();
            }
            if (!self.options.showCancel)
            {
                self.dh.find('._dialogCancel').hide();
            }
            if (!self.options.showClose)
            {
                self.dh.find('._dialogClose').hide();
            }
            if (!self.options.showOk)
            {
                self.dh.find("._dialogOk").hide();
            }

            //如果没有图标内容不偏移
            if (!self.options.icon)
            {
                //self.dc.css({padding:0});
            }

            if (self.options.contentType == "selector")
            {
                var content = getElement(self.options.content).clone(true);
                content.show();
                content.css('display', 'block');
                self.setContent(content);
                self.contentInited = true;
                //if have checkbox do
                //选中里面的多选框，暂时没得用
                /*
                var cs = $(self.selector).find(':checkbox');
                self.dc.find(':checkbox').each(function(i) 
                {
                self.checked = cs[i].checked;
                });*/
                //$(self.selector).empty(); //清空原来的div
                //self.show();
                //self.focus();
                self.onopen();
            } else if (self.options.contentType == "ajax")
            {
                self.setLoading();
                var stop = self.stopLoading;
                setTimeout(stop, 8000);
                //this.show();
                //this.dh.find(".dialog-button").hide();
                var url = self.options.content;
                if (self.options.type == 'tooltip')
                {
                    if (url.indexOf('?') == -1)
                    {
                        url += "?_tooltip=true";
                    } else
                    {
                        url += "&_tooltip=true";
                    }
                }
                $.ajax(
                {
                    url: url,
                    dataType: 'html',
                    success: function(data)
                    {
                        self.stopLoading();
                        if (self.options.type == 'tooltip')
                        {
                            if (data == 'needPersonLogin')
                            {
                                try
                                {
                                    self.hide();
                                } catch (e) { }
                                checkPersonLogin();
                                return;
                            } else if (data == 'needCompanyLogin')
                            {
                                try
                                {
                                    self.hide();
                                } catch (e) { }
                                checkCompanyLogin();
                                return;
                            }
                        }
                        self.setContent(data);
                        self.innerShow(true);
                        if (self.options.cache)
                        {
                            self.cachedContent = data;
                        }
                        self.contentInited = true;
                        //self.show();
                        //self.focus();
                        self.onopen();
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown)
                    {
                        self.stopLoading();
                        if (self.options.type == 'tooltip')
                        {
                            self.setContent(tooltipError);
                        } else
                        {
                            self.setContent(errorHtml);
                        }
                        self.innerShow(true);
                        if (self.options.cache)
                        {
                            self.cachedContent = data;
                        }
                        self.contentInited = true;
                        //self.show();
                        //self.focus();
                        self.onopen();
                    }
                });
            } else if (self.options.contentType == "iframe")
            { /*加入iframe使程序可以直接引用其它页面 by ePim*/
                var html = '<style type="text/css">';
                html += ('\n.dialog-box .dialogContent{padding:0px;}');
                html += ('\n</style>');
                html += ('<iframe class="dialogIframe" src="' + self.options.content + '" width="100%" height="100%" frameborder="0"></iframe>');
                self.setContent(html);
                self.contentInited = true;
                self.onopen();
                //self.show();
            } else if (self.options.contentType == 'img')
            {
                var html = '<div class="floatlayer_pic"><img src="' + self.options.content + '" /></div>';
                self.setContent(html);
                self.contentInited = true;
                self.onopen();
            } else
            {
                self.setContent(self.options.content);
                self.contentInited = true;
                //self.show();
                //self.focus();
                self.onopen();
            }
        }

        //初始化弹窗事件
        this.initEvent = function()
        {
            self.dh.find("._dialogClose, ._dialogCancel, ._dialogOk").unbind('click').click(function() { $(this).closeDialog(); return false; });
            //当用户按下键盘按钮时触取消按钮
            self.dh.keydown(function(event)
            {
                var e = $.event.fix(event);
                //esc键， 等效于退出按钮
                if (e.keyCode == 27)
                {
                    var cancell = self.dh.find('._dialogCancel');
                    if (cancell.is(':visible'))
                    {
                        cancell.click();
                    } else if (self.dh.find('._dialogClose').is(':visible'))
                    {
                        self.dh.find('._dialogClose').click();
                    }
                }
            });
            self.dh.mousedown(function() { self.dh.css('z-index', getZIndex()) });
            if (self.options.onok)
            {
                self.setOnok(self.options.onok);
            }

            if (self.options.oncancel)
            {
                self.setOncancel(self.options.oncancel);
            }

            if (self.options.timeout > 0)
            {
                window.setTimeout(self.close, (self.options.timeout * 1000));
            }
            if (self.options.type == 'hover' || self.options.type == 'menu')
            {
                $('body').mousedown(function(event)
                {
                    var e = $.event.fix(event);
                    var src = e.target;
                    var keep = false;
                    if (self.dh[0] == src || $.contains(self.dh[0], src))
                    {
                        keep = true;
                    }
                    //如果是在模式窗口内也不关闭
                    $('._dialog').each(function()
                    {
                        if ($.contains(this, src)) keep = true;
                    });
                    if (!keep && self.options.keepHover)
                    {
                        if ($.isArray(self.options.keepHover))
                        {
                            try
                            {
                                for (var i in self.options.keepHover)
                                {
                                    if (typeof self.options.keepHover[i] == 'string')
                                    {
                                        $(self.options.keepHover[i]).each(function()
                                        {
                                            if (this == src || $.contains(this, src))
                                            {
                                                keep = true;
                                            }
                                        });
                                    } else
                                    {
                                        var el = self.options.keepHover[i][0];
                                        if (el == src || $.contains(el, src))
                                        {
                                            keep = true;
                                        }
                                    }

                                }
                            } catch (e) { }
                        } else
                        {
                            try
                            {
                                if (typeof self.options.keepHover == 'string')
                                {
                                    $(self.options.keepHover).each(function()
                                    {
                                        if (this == src || $.contains(this, src))
                                        {
                                            keep = true;
                                        }
                                    });
                                } else
                                {
                                    var el = self.options.keepHover[0];
                                    if (el == src || $.contains(el, src))
                                    {
                                        keep = true;
                                    }
                                }
                            } catch (e) { }
                        }
                    }
                    if (!keep) self.close();
                });

                self.dh.find('tr').each(function()
                {
                    $(this).mouseover(function() { $(this).addClass('cu'); }).mouseout(function() { $(this).removeClass('cu'); });
                });
            }
            self.drag();
        }

        //设置onok事件
        this.setOnok = function(fn)
        {
            //self.dh.find(".dialog-ok").unbind('click');
            if (typeof (fn) == "function")
            {
                var src = self.options.src;
                self.dh.find("._dialogOk").click(function() { fn(src); });
            } else if (typeof fn == 'number')
            {
                self.dh.find("._dialogOk").click(function()
                {
                    window.history.go(fn);
                });
            } else if (typeof fn == 'string')
            {
                self.dh.find("._dialogOk").click(function()
                {
                    window.location = fn;
                });
            }
        }
        //设置onOncancel事件
        this.setOncancel = function(fn)
        {
            //self.dh.find(".dialog-cancel").unbind('click');
            if (typeof (fn) == "function")
            {
                var src = self.options.src;
                self.dh.find("._dialogClose,._dialogCancel").click(function() { fn(src) });
            } else if (typeof (fn) == "number")
            {
                self.dh.find("._dialogClose,._dialogCancel").click(function() { window.history.go(fn); });
            } else if (typeof (fn) == "function")
            {
                self.dh.find("._dialogClose,._dialogCancel").click(function() { window.location = fn; });
            }
        }

        //打开前的回弹函数
        this.onopen = function()
        {
            if (typeof (self.options.onopen) == "function")
            {
                self.options.onopen(self);
            }
        }

        //关闭事件
        this.onclose = function()
        {
            //如果是加载的页面，清空高亮显示的行
            if (self.options.contentType == 'ajax' && (self.options.type == 'modal' || self.options.type == 'dialog'))
            {
                clearHighLight();
            }
            if (typeof self.options.onclose == 'number')
            {
                window.history.go(self.options.onclose);
            } else if (typeof self.options.onclose == 'string')
            {
                setTimeout('window.location = "' + self.options.onclose + '";', 100);

            } else if (typeof (self.options.onclose) == "function")
            {
                var src = self.options.src;
                self.options.onclose(src);
            }
        }

        //弹窗拖拽
        this.drag = function()
        {
            //取消拖动效果，因为加上了iframe后拖动不了
            return;
            if (self.options.draggable && self.options.showHeader)
            {
                var header = self.dh.find('._dialogHeader');
                header.css('cursor', 'move');
                var mouseMove = function(event)
                {
                    var h = self;
                    //var o = document;
                    var width = h.dh.width();
                    var height = h.dh.height();
                    if (window.getSelection)
                    {
                        window.getSelection().removeAllRanges();
                    } else
                    {
                        document.selection.empty();
                    }

                    var left = event.clientX - h.mx; // Math.max(event.clientX - h.mx, 0);
                    var top = event.clientY - h.my; //Math.max(event.clientY - h.my, 0);
                    h.dh.css({ left: left, top: top });
                };
                var mouseUp = function()
                {
                    var h = self;
                    if (h.releaseCapture)
                    {
                        h.releaseCapture();
                    }
                    $(document).unbind('mousemove');
                    $(document).unbind('mouseup');
                };
                var mouseDown = function(event)
                {
                    var dhleft = parseInt(self.dh.css('left').replace('px'));
                    var dhtop = parseInt(self.dh.css('top').replace('px'));
                    self.mx = event.clientX - dhleft; // event.clientX;
                    self.my = event.clientY - dhtop; //event.clientY;
                    if (self.setCapture)
                    {
                        self.setCapture();
                    }

                    $(document).mousemove(mouseMove).mouseup(mouseUp);
                };

                header.mousedown(mouseDown);
            }
        }

        //增加一个按钮
        this.addButton = function(opt)
        {
            opt = opt || {};
            opt.title = opt.title || 'OK';
            opt.bclass = opt.bclass || 'dialog-btn1';
            opt.fn = opt.fn || null;
            opt.index = opt.index || 0;
            var btn = $('<input type="button" class="' + opt.bclass + '" value="' + opt.title + '">').click(function()
            {
                if (typeof opt.fn == "function") opt.fn(self);
            });
            if (opt.index < self.db.find('input').length)
            {
                self.db.find('input:eq(' + opt.index + ')').before(btn);
            } else
            {
                self.db.append(opt);
            }
        }
        this.hide = function(fn)
        {
            if (typeof self.options.hideAnimate == "string")
            {
                self.dh.hide(self.options.animate, fn);
            } else
            {
                self.dh.animate(self.options.hideAnimate.animate, self.options.hideAnimate.speed, "", fn);
            }
        }
        //设置弹窗焦点
        this.focus = function()
        {/*
            if (self.options.focus)
            {
                self.dh.find(self.options.focus).focus(); //TODO IE中要两次
                self.dh.find(self.options.focus).focus();
            } else
            {
                self.dh.find('._dialogCancel').focus();
            }*/
        }
        //在弹窗内查找元素
        this.find = function(selector)
        {
            return self.dh.find(selector);
        }
        //设置加载加状态
        this.setLoading = function()
        {
            //var loading = $('<div >正在加载中</div>');
            //$('body').append(loading);
            //loading.css({ 'z-index': self.dh.css('z-index') + 1 });
            //var width = Math.max(self.dh.outerWidth(), 40);
            //var height = Math.max(self.dh.outerHeight(), 70);
            //loading.css({ width: width, height: height });
            //self.initPosition(loading);
            //self.loading = loading;
            self.setContent('<div class="dialogLoading">加载中，请稍后</div>');
        }
        //停止加载状态
        this.stopLoading = function()
        {
            try
            {
                if(self.loading&&typeof self.loading != "undefined")
                {
                  self.loading.remove();
                }
            } catch (e) { } finally
            {
                self.loading = null;
                return;
            }
        }

        this.setWidth = function(width)
        {
            self.dw.width(width);
        }
        //取得标题
        this.getTitle = function()
        {
            return self.dt.html();
        }

        //设置内容
        this.setContent = function(content)
        {
            if (typeof content == 'string')
            {
                self.dc.html(content);
            } else
            {
                self.dc.append(content);
            }
            if (self.options.height > 0)
            {
                self.dc.css('height', self.options.height);
            } else
            {
                self.dc.css('height', '');
            }
            if (self.options.width > 0)
            {
                //self.dh.css('width', self.options.width);
            } else
            {
                self.dh.css('width', '');
            }
            if (self.options.showButton)
            {
                self.dh.find("._dialog-button").show();
            }
        }

        //取得内容
        this.getContent = function()
        {
            return self.dc.html();
        }

        //使能按钮
        this.disabledButton = function(btname, state)
        {
            self.dh.find('._dialog' + btname).attr("disabled", state);
        }
        //隐藏按钮
        this.hideButton = function(btname)
        {
            self.dh.find('._dialog' + btname).hide();
        }
        //显示按钮
        this.showButton = function(btname)
        {
            self.dh.find('._dialog' + btname).show();
        }
        //设置按钮标题
        this.setButtonTitle = function(btname, title)
        {
            self.dh.find('._dialog' + btname).val(title);
        }
        //操作完成
        this.next = function(opt)
        {
            opt = opt || {};
            opt.title = opt.title || self.getTitle();
            opt.content = opt.content || "";
            opt.okname = opt.okname || "确定";
            opt.width = opt.width || 260;
            opt.onok = opt.onok || self.close;
            opt.onclose = opt.onclose || null;
            opt.oncancel = opt.oncancel || null;
            opt.hideCancel = opt.hideCancel || true;
            self.setTitle(opt.title);
            self.setButtonTitle("ok", okname);
            self.setWidth(width);
            self.setOnok(opt.onok);
            if (opt.content != "") self.setContent(opt.content);
            if (opt.hideCancel) self.hideButton("cancel");
            if (typeof (opt.onclose) == "function") self.setOnclose(opt.onclose);
            if (typeof (opt.oncancel) == "function") self.setOncancel(opt.oncancel);
            self.show();
        }

        this.toggle = function()
        {
            if (self.options.id && self.dh && self.dh.length > 0)
            {
                try
                {
                    var d = self; //$('#_dialog' + self.options.id).data(contextData);
                    if (d.dh.is(':visible'))
                    {
                        d.close();
                    } else
                    {
                        d.show();
                    }
                } catch (e) { alert('toggle:' + e.message); }
            } else
            {
                if (self.dh && self.dh.length && self.dh.is(':visible'))
                {
                    self.close();
                } else
                {
                    self.show();
                }
            }
        }

        //显示弹窗
        this.show = function()
        {
            //关闭现有的层
            if (self.options.id)
            {
                try
                {
                    //有错
                    var d = $('#_dialog' + self.options.id); //.data(contextData);
                    //d.close();
                    if (d.size() > 0) return;
                } catch (e) { }
            }

            var dialog = self.options.id ? self : $.extend({}, self);
            dialog.initMask();
            dialog.initBox();
            dialog.initContent();
            // if (dialog.options.contentType != 'ajax')
            {
                dialog.innerShow();
            }

            return false;
        }

        this.innerShow = function(isComplete)
        {

            var dialog = self;
            dialog.initEvent();
            dialog.initPosition();
            if (dialog.mh)
            {
                dialog.mh.show();
            }

            if (dialog.options.type == 'menu')//菜单采用滑出的动画效果
            {
                //var height = dialog.dh.height();
                //dialog.dh.height(0);
                dialog.dh.show();
                if (dialog.options.position == 'under')
                {
                    //dialog.dh.animate({ height: height }, 200);
                } else if (dialog.options.position == 'top')
                {
                    var top = dialog.dh.offset().top;
                    //dialog.dh.css({ top: top + height });
                    //dialog.dh.animate({ height: height, top: top }, 200);
                }

            } else if (dialog.options.showAnimate == "toggle" || dialog.options.showAnimate == "slide" || dialog.options.showAnimate == "fade")
            {
                switch (dialog.options.animate)
                {
                    case 'toggle':
                        dialog.dh.hide().show(400);
                        break;
                    case 'slide':
                        dialog.dh.hide().slideDown(400);
                        break;
                    case 'fade':
                        dialog.dh.hide().fadeIn(400, function()
                        {
                            //聚集到确定或关闭按钮
                            var ok = self.dh.find('._dialogOk');
                            if (ok.is(':visible'))
                            {
                                ok.focus();
                            } else
                            {
                                self.dh.find('._dialogClose').focus();
                            }
                        });
                        break;
                }
            } else if (dialog.options.showAnimate)
            {
                dialog.dh.animate(dialog.options.showAnimate.animate, dialog.options.showAnimate.speed, function()
                {
                    //聚集到确定或关闭按钮
                    var ok = self.dh.find('._dialogOk');
                    if (ok.is(':visible'))
                    {
                        ok.focus();
                    } else
                    {
                        self.dh.find('._dialogClose').focus();
                    }
                });
            } else
            {
                dialog.dh.show();
                //聚集到确定或关闭按钮
                var ok = self.dh.find('._dialogOk');
                if (ok.is(':visible'))
                {
                    ok.focus();
                } else
                {
                    self.dh.find('._dialogClose').focus();
                }
            }

            if (self.options.type == 'tooltip' && self.options.keepHover && isComplete)
            {
                var depend = getElement(self.options.dependElement);
                var left = Math.min(depend.offset().left, self.dh.offset().left);
                var right = Math.max(depend.offset().left + depend.width(), self.dh.offset().left + self.dh.width());
                var top = Math.min(depend.offset().top, self.dh.offset().top);
                var bottom = Math.max(depend.offset().top + depend.height(), self.dh.offset().top + self.dh.height());
                var closeFn = self.close;
                // alert(left + ':' + right + '   :   ' + top + ':' + bottom);
                var move = function(event)
                {
                    var wnd = $(window);
                    var e = $.event.fix(event);
                    var x = e.clientX + wnd.scrollLeft();
                    var y = e.clientY + wnd.scrollTop();

                    if (x >= left && x <= right && y <= bottom && y >= top) return;
                    closeFn();
                    $('body').unbind('mousemove', move);
                };
                $('body').mousemove(move);
            }
            if(self.options.showMask)self.dh.bgiframe();
        }

        //关闭弹窗
        this.close = function(n)
        {
            self.onclose();
            //查看自动完成的提示窗口将其关闭,Email提示层
//            try
//            {
//                $('.em_divtip').remove();
//            } catch (e) { }

            //设置关闭后的焦点
            if (self.options.blur)
            {
                $(self.options.blur).focus();
            }
            //从数组中删除
            for (i = 0; i < arrweebox.length; i++)
            {
                if (arrweebox[i].dh.get(0) == self.dh.get(0))
                {
                    arrweebox.splice(i, 1);
                    break;
                }
            }
            //关闭回调，用于移除对象
            var closeCallback = function()
            {
                self.dh.remove();
                if (self.mh)
                {
                    self.mh.animate({opacity:0},{complete:function()
																   {
																   self.mh.remove();
																  }});
                }
            };
            if (self.options.type == 'menu')//菜单采用滑出的动画效果
            {
                var height = self.dh.height();
                if (self.options.position == 'under')
                {
                    //self.dh.animate({ height: 0 }, 200, closeCallback);
                } else if (self.options.position == 'top')
                {
                    var top = self.dh.offset().top + height;
                    //self.dh.css({top:top-height});
                    //self.dh.animate({ height: 0, top: top }, 200, closeCallback);
                }
                self.dh.hide();
                closeCallback();
            } else if (self.options.showAnimate == "toggle" || self.options.showAnimate == "slide" || self.options.showAnimate == "fade")
            {
                switch (self.options.animate)
                {
                    case 'toggle':
                        self.dh.hide(400, closeCallback);
                        break;
                    case 'slide':
                        self.dh.slideUp(400, closeCallback);
                        break;
                    case 'fade':
                        self.dh.fadeOut(400, closeCallback);
                        break;
                }
            } else if (self.options.showAnimate)
            {
                self.dh.animate(self.options.showAnimate.animate, self.options.showAnimate.speed, closeCallback);
            } else
            {
                self.dh.hide();
                closeCallback();
            }
            // self.hide();
        }
        //取得遮照高度
        this.bheight = function()
        {
            if ($.browser.msie && $.browser.version < 7)
            {
                var scrollHeight = Math.max(document.documentElement.scrollHeight, document.body.scrollHeight);
                var offsetHeight = Math.max(document.documentElement.offsetHeight, document.body.offsetHeight);

                if (scrollHeight < offsetHeight)
                {
                    return $(window).height();
                } else
                {
                    return scrollHeight;
                }
            } else
            {
                return $(document).height();
            }
        }
        //取得遮照宽度
        this.bwidth = function()
        {
            if ($.browser.msie && $.browser.version < 7)
            {
                var scrollWidth = Math.max(document.documentElement.scrollWidth, document.body.scrollWidth);
                var offsetWidth = Math.max(document.documentElement.offsetWidth, document.body.offsetWidth);

                if (scrollWidth < offsetWidth)
                {
                    return $(window).width();
                } else
                {
                    return scrollWidth;
                }
            } else
            {
                return $(document).width();
            }
        }
        //初始化窗口位置
        this.initPosition = function(obj)
        {
            var src = obj || self.dh;
            var left = 0, top = 0;
            if (self.options.type == 'tooltip')
            {
                var arrowSize = 7;
                var arrowClass = 'floatlayer_arrow_left';
                var depend = getElement(self.options.dependElement);
                var offset = depend.offset();
                left = offset.left;
                top = offset.top + depend.outerHeight();
                var arrowLeft = 0;
                var arrowTop = 0;
                var doc = $(document);
                var wnd = $(window);
                var toTop = function()
                {
                    top = offset.top - src.outerHeight() - arrowSize;
                    left = offset.left - ((src.outerWidth() - depend.outerWidth()) / 2);
                    var of = 0;
                    if (left < 0)
                    {
                        of = left * -1;
                    } else if (left + src.outerWidth() > wnd.scrollLeft() + wnd.width())
                    {
                        // of = doc.width() - (left + src.outerWidth());
                        of = left + src.outerWidth() - wnd.scrollLeft() - wnd.width();
                    }
                    left += of;
                    arrowTop = src.innerHeight() - 1;
                    arrowLeft = src.outerWidth() / 2 + of - arrowSize / 2;
                    arrowClass = 'floatlayer_arrow_bottom';
                    return top >= 0;
                };
                var toBottom = function()
                {
                    top = offset.top + depend.outerHeight() + arrowSize;
                    left = offset.left - ((src.outerWidth() - depend.outerWidth()) / 2);
                    var of = 0;
                    if (left < 0)
                    {
                        of = left * -1;
                    } else if (left + src.outerWidth() > wnd.scrollLeft() + wnd.width())
                    {
                        //of = doc.width() - (left + src.outerWidth());
                        of = left + src.outerWidth() - wnd.scrollLeft() - wnd.width();
                    }
                    left += of;
                    arrowTop = -1 * arrowSize;
                    arrowLeft = src.outerWidth() / 2 + of - arrowSize / 2;
                    arrowClass = 'floatlayer_arrow_top';
                    return top + src.outerHeight() < doc.height();
                };
                var toLeft = function()
                {
                    top = offset.top - (src.outerHeight() - depend.outerHeight()) / 2;
                    left = offset.left - src.outerWidth() - arrowSize;
                    var of = 0;
                    if (top + src.outerHeight() > wnd.scrollTop() + wnd.height())
                    {
                        //of = (top + src.outerHeight()) - doc.height();
                        of = top + src.outerHeight() - wnd.scrollTop() - wnd.height();
                    } else if (top < 0)
                    {
                        of = top * -1;
                    }
                    top -= of;
                    arrowTop = src.outerHeight() / 2 + of - arrowSize / 2;
                    arrowLeft = src.width() - 1;
                    arrowClass = 'floatlayer_arrow_right';
                    return left >= 0;
                };
                var toRight = function()
                {
                    top = offset.top - (src.outerHeight() - depend.outerHeight()) / 2;
                    left = offset.left + depend.outerWidth() + arrowSize;
                    var of = 0;
                    if (top + src.outerHeight() > wnd.scrollTop() + wnd.height())
                    {
                        //of = (top + src.outerHeight()) - doc.height();
                        of = top + src.outerHeight() - wnd.scrollTop() - wnd.height();
                    } else if (top < 0)
                    {
                        of = top * -1;
                    }
                    top -= of;
                    arrowTop = src.outerHeight() / 2 + of - arrowSize / 2;
                    arrowLeft = -1 * arrowSize;
                    arrowClass = 'floatlayer_arrow_left';

                    return left + src.outerWidth() <= doc.width();
                };

                if (self.options.position == 'top')
                {
                    if (!toTop()) toBottom();
                } else if (self.options.position == 'bottom')
                {
                    if (!toBottom()) toTop();
                } else if (self.options.position == 'left')
                {
                    if (!toLeft()) toRight();
                } else
                {
                    if (!toRight()) toLeft();
                }
                src.css({ left: left, top: top });
                //self.dw.width(src.width() - 10);
                //self.dw.height(src.height() - 20);
                src.find('#_arrow').addClass(arrowClass);
                src.find('#_arrow').css({ left: arrowLeft, top: arrowTop });
                return;
            } else if (self.options.position == 'center' || self.options.type == 'modal' || self.options.position == 'anchor' || self.options.position == 'anchorRight')//绝对定位于某个位置
            {
                self.anchorToPos(src);
                if (self.options.anchorPosition)
                {
                    var anchor = function(s)
                    {
                        return function() { self.anchorToPos(s); };
                    } (src);

                    anchor = $.proxy(anchor, self);

                    //  2011-05-20 zhangyu  update
                    //  取消弹出窗口根据浏览的改变和重新设置位置事件
                    //  只有当不支持fixed属性的时候才需要不断修正位置
                    
                    /*
                    if ($.support.fixed)
                    {
                        $(window).resize(anchor);
                        $(document).resize(anchor);
                    } else
                    {
                        //$(window).scroll(anchor).resize(anchor);
                        $(document).resize(anchor);
                    }
                    */
                }
                return;
            } else
            {
                var depend = getElement(self.options.dependElement);
                var offset = depend.offset();
                var wnd = $(window);
                var doc = $(document);

                var toDepend = function()
                {
                    left = depend.offset().left;
                    if (offset.left + self.dh.outerWidth() > doc.width())
                    {
                        left = doc.width() - src.outerWidth() - 10;
                    }
                    top = offset.top - src.outerHeight();
                    if (offset.top + self.dh.outerHeight() > doc.height())
                    {
                        top = doc.height() - src.outerHeight() - 10;
                    }
                }

                var toTop = function()
                {
                    var dependTop = 0;
                    if (self.options.type == 'menu' && self.options.container)
                    {
                        offset = depend.position();
                        dependTop = depend.offset().top;
                    }

                    left = offset.left;
                    top = offset.top - src.outerHeight();
                    if (left + self.dh.outerWidth() > wnd.scrollLeft() + wnd.width()) left -= left + self.dh.outerWidth() - wnd.scrollLeft() - wnd.width()
                    //不能超过屏幕边框
                    //if (left + self.dh.outerWidth() > wnd.scrollLeft() + wnd.width()) left -= left + src.outerWidth() - wnd.scrollLeft() - wnd.width();
                    //if (top + src.outerHeight() > wnd.height() + wnd.scrollTop()) top -= top + src.outerHeight() - wnd.height() - wnd.scrollTop();
                    if (self.options.type == 'menu') top++;
                    return top + dependTop >= wnd.scrollTop();
                }

                var toUnder = function()
                {
                    var dependTop = 0;
                    if (self.options.type == 'menu' && self.options.container)
                    {
                        offset = depend.position();
                        //下面的修正是针对简历助手进行的调整，只有简历助手才需要相对于父容器进行定位，其它的是相对于document
                        offset.top += 3;
                        offset.left += 10;
                        dependTop = depend.offset().top;
                    }
                    left = offset.left;
                    top = offset.top + depend.outerHeight();
                    //不能超过屏幕边框
                    //if (left + self.dh.outerWidth() > wnd.scrollLeft() + wnd.width()) left -= left + src.outerWidth() - wnd.scrollLeft() - wnd.width();
                    //if (top + src.outerHeight() > wnd.height() + wnd.scrollTop()) top -= top + src.outerHeight() - wnd.height() - wnd.scrollTop();
                    if (self.options.type == 'menu') top--;
                    return top + dependTop + self.dh.outerHeight() <= wnd.scrollTop() + wnd.height();
                }
                var toAuto = function()
                {
                    try
                    {
                        var offset = depend.offset();
                        left = offset.left + depend.outerWidth();
                        top = offset.top - src.outerHeight();
                    } catch (e) { }
                }

                if (self.options.position == 'depend')
                {
                    toDepend();
                } else if (self.options.position == 'top')//定位于某元素上面
                {
                    if (!toTop()) toUnder();
                }
                else if (self.options.position == 'under')//定位于某元素下面
                {
                    if (!toUnder()) toTop();
                } else if (self.options.position == 'auto')
                {
                    toAuto();
                }
            }
            src.css({ left: Math.max(left, 0), top: Math.max(top, 0) });
        }

        // toUpdate 2011-05-07 zhangyu
        // 移除窗口在浏览器中随浏览器滚动条 滚动而滚动
        self.anchorToPos = function(obj)
        {
            var src = obj || self.dh;
            var wnd = $(window);
            var doc = $(document);
            var top = 0;
            var left = 0;
            /*
            if (!$.support.fixed)
            {
                top = doc.scrollTop();
                left = doc.scrollLeft();
            }
            */
             top = doc.scrollTop();
             left = doc.scrollLeft();
            //2011-1-11 原来anchorRight只用于分页果的提示，后来要求将位置定位到中间
            if (self.options.position == 'center' || self.options.type == 'modal')
            {
                if ($.support.fixed && self.options.anchorPosition)
                {
                    top += (wnd.height() - src.outerHeight()) / 2;
                    left += (wnd.width() - src.outerWidth()) / 2;
                    src.css({left: left, top: top });
                   // src.css({ position: 'fixed', left: left, top: top });
                } else
                {
                    top += (wnd.height() - src.outerHeight()) / 2;
                    left += (wnd.width() - src.outerWidth()) / 2;
                    src.css({ left: left, top: top });
                }
            } else if (self.options.position == 'anchorRight')
            {
                //分页的提示放到页面中间
                
                if ($.support.fixed)
                {
                    top += (wnd.height() - src.outerHeight()) / 2;
                    left += (wnd.width() - src.outerWidth()) / 2;
                    src.css({left: left, top: top })
                    //src.css({ position: 'fixed', left: left, top: top });
                } else
                {
                    top += (wnd.height() - src.outerHeight()) / 2;
                    left += (wnd.width() - src.outerWidth()) / 2;
                    src.css({ left: left, top: top });
                }
                /*
                if (self.options.top == 'center')
                {
                top += (wnd.height() - src.outerHeight()) / 2;
                } else
                {
                top += self.options.top;
                }
                src.css('left', '');
                if ($.support.fixed)
                {
                left = self.options.left - doc.scrollLeft();
                src.css({ position: 'fixed', right: left, top: top });
                } else
                {
                left = self.options.left - doc.scrollLeft();
                src.css({ right: left, top: top });
                }*/
            } else
            {
                if (self.options.top == 'center')
                {
                    top += (wnd.height() - src.outerHeight()) / 2;
                } else
                {
                    top += self.options.top;
                }
                if (self.options.left == 'center')
                {
                    left += (wnd.width() - src.outerWidth()) / 2;
                } else
                {
                    left += self.options.left;
                }
                
                src.css({ left: left, top: top });
                /*
                if ($.support.fixed)
                {
                    src.css({ position: 'fixed', left: left, top: top });
                } else
                {
                    src.css({ left: left, top: top });
                }
                */
            }
        }

        self.initOptions();
    }

    this.singleID = '';
    this._onbox = false;
    this._opening = false;
    this.zIndex = 999;
    var length = function()
    {
        return arrweebox.length;
    }

    //关闭唯一对话框
    $.fn.closeSingleDialog = function()
    {
        try
        {
            var container = $('#_dialog' + this.singleID);
            var context = container.data(contextData);
            context.close();
        } catch (e) { }
    }

    //关闭当前对话框
    $.fn.closeDialog = function()
    {
        try
        {
            var container = this.getDialog();

            var context = container.data(contextData);
            context.close();
        } catch (e) { alert(e.message); }
    }

    //获取当前对话框
    $.fn.getDialog = function()
    {
        return this.closest('._dialog');
    }

    //获取当前对话框的实例对象
    $.fn.getDialogItem = function()
    {
        var container = this.getDialog();
        return container.data(contextData);
    }

    //获取内容属性以构造dialog对象
    var getContentOption = function(content)
    {
        var contentType = 'html';
        if (/^#/.test(content))
        {
            contentType = 'selector';
        } else if (/\.(png|aspx|ashx|html|htm|asp)/i.test(content))
        {
            contentType = 'ajax';
        } else if (/\.(jpg|png|gif)$/i.test(content))
        {
            contentType = 'img';
        }
        else// if(/^(http:)|(https:)/.test(href))
        {
            contentType = 'html';
        }
        return { content: content, contentType: contentType };
    }

    //手动绑定
    $.fn.bindWindow = function(options)
    {
        var opt = options || {};
        var box = new weebox(opt);
        this.unbind('click').click($.proxy(box.show, box));
        return box;
    }

    //模式窗口
    $.fn.bindModal = function(options)
    {
        var opt = options || {};
        var content = getContentOption(opt.content || this.attr('href'));
        opt.title = opt.title || this.attr('title');
        opt.content = opt.content || content.content;
        //opt.animate = 'fade';
        opt.contentType = content.contentType;
        opt.type = opt.type || 'modal';
        opt.position = 'center';
        opt.showButton = opt.showButton || false;
        opt.draggable = false;
        opt.id = '_hover' + getID();
        this.singleID = opt.id;

        var options = options || {};
        if (options.boxid)
        {
            for (var i = 0; i < arrweebox.length; i++)
            {
                if (arrweebox[i].dh.attr('id') == options.boxid)
                {
                    arrweebox[i].close();
                    break;
                }
            }
        }
        var box = new weebox(opt);
        this.unbind('click').click(box.show);
        return box;
    }

    //非模式窗口
    $.fn.bindDialog = function(options)
    {
        var opt = options || {};
        var content = getContentOption(opt.content || this.attr('href'));
        opt.title = opt.title || this.attr('title');
        opt.content = opt.content || content.content;
        //opt.animate = 'fade';
        opt.contentType = content.contentType;
        opt.type = opt.type || 'dialog';
        opt.position = opt.depend || 'depend';
        opt.dependElement = this;
        opt.showButton = opt.showButton || false;
        opt.draggable = true;

        var box = new weebox(opt);
        this.unbind('click').click(box.show);
        return box;
    }

    //浮动窗口
    $.fn.bindHover = function(options)
    {
        var opt = options || {};
        var content = getContentOption(opt.content || this.attr('href'));
        opt.title = opt.title || this.attr('title');
        opt.content = opt.content || content.content;
        opt.animate = 'fade';
        opt.contentType = content.contentType;
        opt.type = opt.type || 'hover';
        opt.position = opt.depend || 'left';
        opt.dependElement = this;
        opt.draggable = true;
        opt.id = '_hover' + getID();
        this.singleID = opt.id;

        var box = new weebox(opt);
        this.unbind('click').click(box.show, box);
        return box;
    }

    //提示框
    $.fn.bindTooltip = function(opt)
    {
        opt = opt || {};
        if (opt.contentType)
        {
            opt.content = this.attr('title');
        } else
        {
            opt = $.extend(opt, getContentOption(this.attr('title')));
        }
        this.removeAttr('title');
        opt.dependElement = this;
        /*
        var tagname=this[0].tagName;
        var wrap=this;
        if(tagname=='INPUT' || tagname=='IMG')
        {
        this.wrap('<span style="border:red solid 0px;"></span>');
        wrap=this.closest('span');
        opt.dependElement=wrap;
        }else
        {
        opt.dependElement=this;
        }*/
        opt.type = 'tooltip';
        //opt.animate = 'fade';
        opt.position = opt.position || 'left';
        opt.draggable = false;
        opt.id = '_tooltip' + getID();
        this.singleID = opt.id;

        var box = new weebox(opt);
        var close = this.closeSingleDialog;
        //this.hover(box.show, self.closeSingleDialog);
        if (opt.keepHover)
        {
            this.hover(function()
            {
                //关闭所有其它已经显示的气泡
                $('._tooltip').each(function()
                {
                    var c = $(this).data(contextData);
                    if (c.options.id == box.options.id) return;
                    try
                    {
                        $(this).closeDialog();
                    } catch (e) { }
                });
                box.show();
            }, null);
        } else
        {
            this.hover(function()
            {
                //关闭所有其它已经显示的气泡
                $('._tooltip').each(function()
                {
                    var c = $(this).data(contextData);
                    if (c.options.id == box.options.id) return;
                    try
                    {
                        $(this).closeDialog();
                    } catch (e) { }
                });
                box.show();
            }, box.close);
        }
        return box;
    }

     // ZhangYu 20110-90-9
    //获取焦点事件的 提示框
    $.fn.bindfocusTooltip = function(opt)
    {
        opt = opt || {};
        if (opt.contentType)
        {
            opt.content = this.attr('title');
        } else
        {
            opt = $.extend(opt, getContentOption(this.attr('title')));
        }
        this.removeAttr('title');
        opt.dependElement = this;
        /*
        var tagname=this[0].tagName;
        var wrap=this;
        if(tagname=='INPUT' || tagname=='IMG')
        {
        this.wrap('<span style="border:red solid 0px;"></span>');
        wrap=this.closest('span');
        opt.dependElement=wrap;
        }else
        {
        opt.dependElement=this;
        }*/
        opt.type = 'tooltip';
        //opt.animate = 'fade';
        opt.position = opt.position || 'left';
        opt.draggable = false;
        opt.id = '_tooltip' + getID();
        this.singleID = opt.id;

        var box = new weebox(opt);
        var close = this.closeSingleDialog;
        //this.hover(box.show, self.closeSingleDialog);
        this.focus(function()
        {
            //关闭所有其它已经显示的气泡
            $('._tooltip').each(function()
            {
                var c = $(this).data(contextData);
                if (c.options.id == box.options.id) return;
                try
                {
                    $(this).closeDialog();
                } catch (e) { }
            });
            box.show();
        }).blur(function()
        {
             box.close();
        });
        return box;
    }

    //下拉菜单      2010-10-14  by dongzh
    $.fn.bindMenu = function(menu, options)
    {
        var opt = options || {};
        //opt.container = opt.container || 'body';
        opt.content = menu;
        opt.contentType = 'selector';
        opt.type = 'menu';
        opt.position = opt.position || 'under';
        opt.dependElement = this;
        opt.draggable = false;
        opt.id = '_menu' + getID();
        //opt.width = this.outerWidth();
        this.singleID = opt.id;

        //2011-1-5 取消了点击指定区域不关闭菜单的功能
        opt.keepHover = this;
        /*
        if (opt.keepHover)
        {
        if ($.isArray(opt.keepHover))
        {
        opt.keepHover.push(this);
        } else
        {
        opt.keepHover = [opt.keepHover, this];
        }
        } else
        {
        opt.keepHover = this;
        }*/

        var box = new weebox(opt);
        this.unbind('click').click(box.toggle);
        return box;
    };

    //消息框
    $.message = function(msg, options)
    {
        var opt = {};
        if (typeof options == 'function' || typeof options == 'string' || typeof options == 'number')
        {
            opt.onclose = options;
        } else
        {
            opt = $.extend(opt, options);
        }
        opt.type = 'message';
        opt.position = 'center';
        opt.contentType = 'html';
        opt.icon = opt.icon || 'success';
        opt.content = msg;
        //opt.animate = 'fade';
        opt.title = opt.title || '系统提示';
        opt.draggable = false;
        opt.id = '_tooltip' + getID();
        opt.showCancel = false;
        //opt.animate='slow';
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //消息框
    $.fn.message = function(msg, options)
    {
        var opt = {};
        if (typeof options == 'function' || typeof options == 'string' || typeof options == 'number')
        {
            opt.onclose = options;
        } else
        {
            opt = $.extend(opt, options);
        }
        opt.type = 'message';
        opt.position = 'center';
        opt.contentType = 'html';
        opt.icon = opt.icon || 'success';
        opt.content = msg;
        //opt.animate = 'fade';
        opt.title = opt.title || '系统提示';
        opt.draggable = false;
        opt.id = '_tooltip' + getID();
        opt.showCancel = false;
        //opt.animate='slow';
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //确认框
    $.confirm = function(msg, title, ok, cancell)
    {
        var opt = {};
        opt.src = this;
        opt.type = 'confirm';
        opt.position = 'center';
        opt.contentType = 'html';
        opt.icon = 'question';
        opt.content = msg;
        //opt.animate = 'fade';
        opt.draggable = false;
        opt.id = '_tooltip' + getID();
        //opt.okBtnName='是';
        //opt.cancelBtnName='否';
        if (typeof title == 'function')
        {
            opt.onok = title;
            opt.oncancell = ok;
        } else
        {
            opt.title = title;
            opt.onok = ok;
            opt.oncancel = cancell;
        }
        opt.title = opt.title || '系统提示';
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //确认框
    $.fn.confirm = function(msg, title, ok, cancell)
    {
        var opt = {};
        opt.src = this;
        opt.type = 'confirm';
        opt.position = 'center';
        opt.contentType = 'html';
        opt.icon = 'question';
        opt.content = msg;
        //opt.animate = 'fade';
        opt.draggable = false;
        opt.id = '_tooltip' + getID();
        //opt.okBtnName='是';
        //opt.cancelBtnName='否';
        if (typeof title == 'function')
        {
            opt.onok = title;
            opt.oncancell = ok;
        } else
        {
            opt.title = title;
            opt.onok = ok;
            opt.oncancel = cancell;
        }
        opt.title = opt.title || '系统提示';
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //创建一个对话框不自动显示
    $.dialog = function(options)
    {
        var box = new weebox(options);
        return box;
    }

    //打开指定的url并显示对话框
    $.showDialog = function(url, options)
    {
        var opt = options || {};
        opt.content = url;
        opt.contentType = opt.contentType || 'ajax';
        //if (typeof opt.animate == 'undefined') opt.animate = 'fade';
        opt.type = opt.type || 'dialog';
        opt.position = opt.depend || 'depend';
        opt.dependElement = $($.event.fix(event).target);
        opt.showButton = opt.showButton || false;
        opt.draggable = true;
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //打开指定的url并以模式窗口显示对话框draggable
    $.showModal = function(url, options)
    {
        var opt = options || {};
        opt.content = url;
        opt.contentType = opt.contentType || 'ajax';
        //if (typeof opt.animate == 'undefined') opt.animate = 'fade';
        opt.type = 'modal';
        opt.showButton = opt.showButton || false;
        //opt.draggable = opt.draggable || false;
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //提供定位于屏幕的某个位置的窗口显示
    $.anchor = function(msg, options)
    {
        var opt = options || {};
        opt.type = 'anchor';
        opt.position = opt.position || 'center';
        opt.content = msg;
        //opt.animate = 'fade';
        opt.contentType = 'html';
        opt.timeout = opt.timeout || 0;
        if (opt.icon == 'undefined') opt.icon = 'success';
        opt.draggable = false;
        opt.id = '_anchor' + getID();
        opt.showButton = false;
        var box = new weebox(opt);
        box.show();
        return box;
    }

    //显示一个消息提示，2秒钟消失
    $.anchorMsg = function(msg, opt)
    {
        opt = opt || {};
        if (typeof opt.timeout == 'undefined') opt.timeout = 2000;
        //opt.timeout = 0;
        $.anchor(msg, opt);
    }

    $.showError = function(msg)
    {
        msg = msg || '非常抱歉，数据加载失败';
        var errorHtml =
    '            	<div class="dialogError">' +
    '            		' + msg +
    '                </div>' +
    '               <div class="dialogPopBtn"></div>';
      
	   $.showModal(errorHtml, { conentType: 'html'});
    }

    
    
 $().ready(function()
    {		

		var dialogs=$(".dialog"),dialogLefts=$(".dialogLeft"),dialogRights=$('.dialogRight'),dialogTops=$('.dialogTop'),
		dialogUnders=$('.dialogUnder'),modals=$('.modal');
		for(var i=0;i<dialogs.length;i++){ 
		    $(dialogs[i]).bindDialog();
		}
		for(var i=0;i<dialogLefts.length;i++){
			$(dialogLefts[i]).bindDialog({ depend: 'left' });
		}
		for(var i=0;i<dialogRights.length;i++){
			$(dialogRights[i]).bindDialog({ depend: 'right' });
		}
		for(var i=0;i<dialogTops.length;i++){
			$(dialogTops[i]).bindDialog({ depend: 'top' });
		}
		for(var i=0;i<dialogUnders.length;i++){
			$(dialogUnders[i]).bindDialog({ depend: 'under' });
		}
		for(var i=0;i<modals.length;i++){
			$(modals[i]).bindModal();
		}		
		var menus=$(".menu");
		for(var i=0;i<menus.length;i++){
			$(menus[i]).bindMenu();
		}
    });

})(jQuery);






