﻿(function() {
	/*
	 *Author Liyao
	 *Date 2009-4-8
	 *Function JobareaLayer class extends JobLayer class
	 */
	
	//check the class name , it will be replaced when existed
	if ( window.JobareaLayer ) {
		alert( 'variable JobareaLayer has been used,it will be replaced with _JobareaLayer!' );
		window._JobareaLayer = window.JobareaLayer;
	}

	//constructor
	window.JobareaLayer = function( param ) {
		param = param instanceof Object ? param : {};
		
		param.colNum = param.colNum || 10;
		if ( param.extData ) {//处理居住地的情况		
			param.data = ja.clone();
			for ( var p in param.extData ) {
				if ( /^[\d]{4}$/.test( p ) ) {
					param.data[p] = param.extData[p];
				}
			}
			this.mainCity[4].subIds[0] = '9900';
			param.headTitle = param.cfg.langs.juzd;
		}
		else {
		   this.mainCity[4].subIds[0] = '0302';
			param.data = ja;
			param.headTitle = param.cfg.langs.gzdd;
		}
		
		param.selectedTitle = param.cfg.langs.didian;
		
		param.initTblFunc = this.initJobareaLayer;
		
		param.getSubValues = this.getJobareaIds;
		param.getSubColNum = function( len ) { return Math.ceil( Math.sqrt( len ) ); };		
		var tdWidth = 'e' == param.cfg.lang ? 'auto' : '75px';
		param.tdProps = { style : { width: tdWidth , paddingLeft: '3px'  } };
		if ( param.cityChoose ) {
			param.tdProps.style.width = '84px';
			param.subTdProps = { style : {} };
			param.subTdProps.style.width = '75px';
			
		}

		param.emptyWords = param.cfg.langs.xzdq;

		JobLayer.apply( this , [param] );

	}.$extends( JobLayer );

	//share property & method
	var pt = JobareaLayer.prototype;
    pt.maxCityNumber=7;
	//每行显示类的数目（城市按字母分类）
	pt.column=2;
    {zidian}
	pt.getJobareaIds = function( _value , isClearShenZhen ){//处理广东省深圳市特殊情况	
		var _values = this.constructor.prototype.getSubValues.apply( this , [_value] );		
		if ( '0300' == _value ) {
			// if ( _values[1] != '0400' ) {
				// _values.splice( 1 , 0 , '0400' );
			// }
			if ( isClearShenZhen ) {
				_values.splice( 1 , 1 );
			}
		}
		return _values;
	}

	pt.initJobareaLayer = function() {

		//table
		this.createTbl();
	
		if ( !this.cityChoose ) {
			//title tr
			this.createTitleTr();

			//selected tr
			if ( this.isMulty ) {
				this.createSelectedTr();
			
				//seprator line
				var tr = this.tbl.insertRow( -1  );
				var td = document.createElement( 'td' );
				td.colSpan =  this.colNum;
				td.className = 'jlSeprator';
				tr.appendChild( td );
			}

			//main city title
			var tr = this.tbl.insertRow( -1  );
			var td = document.createElement( 'td' );
			td.colSpan =  this.colNum;
			td.innerHTML = this.cfg.langs.zycs + '：';
			td.className = 'bigOrange gray';
			tr.appendChild( td );
		}
		
		var pareClsAdd = this.cityChoose && 'e' == this.cfg.lang ? ' quName' : '';
		//main city trs		
		var cityTr=this.tbl.insertRow(-1);
		var cityTd=document.createElement("td");	
		cityTd.colSpan=this.colNum;
		cityTr.appendChild(cityTd);	
		// 整个主要城市  都包含在 cityTable中
		var cityTable=document.createElement("table");		
	
		cityTable.style.width=pt.maxCityNumber*pt.column*50+"px";	
		
		cityTd.appendChild(cityTable);
		for(var i=0;i<this.mainCity.length;i++){	
			
			// 一行排this.column列
			if((i % pt.column) ==0){				
			  var tmptr =cityTable.insertRow(-1);								
			}				
			this.mainCity[i]['pareName'] = this.mainCity[i][this.cfg.fullLang];
			this.mainCity[i]['pareClassName'] = 'cityOrange' + pareClsAdd;				
			this.createCitySelectTd(this.mainCity[i],tmptr,pt.maxCityNumber);		
					
		}
		//all province title
		var tr = this.tbl.insertRow( -1  );
		var td = document.createElement( 'td' );
		
		td.colSpan =  this.colNum;
		td.innerHTML = this.cfg.langs.sysf + '：';
		td.className = 'bigOrange gray';
		tr.appendChild( td );		
		//all province trs		
		for ( var i = 0 ; i < this.allProvince.length ; i++ ) {
			this.allProvince[i]['pareName'] = this.allProvince[i][this.cfg.fullLang] + '';
			this.allProvince[i]['pareClassName'] = 'cityOrange' + pareClsAdd;
			this.createSelectAreaTr( this.allProvince[i] );
		}
			
		if ( !this.cityChoose ) {
			//bottom line
			this.createBottomLine();
		}	
	}
	pt.createAreaTd = function( _value , isLast , checked ) {
		{NorH}
		var isNewCity=false;
		var isHotCity=false;
		for(var i=0;i<newCity.length;i++){
			if(_value==newCity[i]){
				isNewCity=true;
				break;
			}
		}
		for(var i=0;i<hotCity.length;i++){
			if(_value==hotCity[i]){
				isHotCity=true;
				break;
			}
		}
		var td = document.createElement( 'td' );
		td.style.cursor = 'pointer';	
		if(isNewCity){
			td.style.color='#0075E8';
		}
		if(isHotCity){
			td.style.fontWeight='bold';
		}
		td.thisObj = this;
		td._value = _value;
		td.isLast = isLast != undefined ? isLast : false;		
        var bAddCheckBox = false;		
		if ( this.isMulty && ( td.isLast || !this.getSubValues( _value ).length ) ) {			
            var bAddCheckBox = true;			         		
			td.innerHTML = '<input style="display:none" type="checkbox" name="' + this.namePrefix + _value + '" onclick="this.checked=!this.checked;" ' + ( checked ? 'checked="checked"' : '' ) + ' />';
		}
		td.onclick = this.tdClk;		
		if ( this.cityChoose ) {
			var a = document.createElement( 'a' );
			a.className = 'blue';
            var sTextValue = this.getTextFunc( _value );
		
			a.innerHTML = sTextValue;

			if ( this.getSubValues( _value ).length && !td.isLast ) {
				a.href = 'javascript: void(0);';
				a.onclick = 'return false;';
			}
			else {
				this.cityChoose.jobarea = _value;
				a.href = this.getSearchResultHref( this.cityChoose );
			}

			td.appendChild( a );
            if (('c' == this.cfg.lang) && ('undefined' != typeof this.tdProps.style.width)) {
                var iTextValueLength = sTextValue.getLen();
                if (iTextValueLength > 8 && iTextValueLength < 12) {
                    if (bAddCheckBox) {
                        if (parseInt(this.subTdProps.style.width) < 85) {
                            this.subTdProps.style.defaultWidth = this.subTdProps.style.width;
                            this.subTdProps.style.width        = '85px';
                        }
                    }
                }
                else if (iTextValueLength > 12) {
                    if (bAddCheckBox) {
                        if (parseInt(this.subTdProps.style.width) < 120) {
                            this.subTdProps.style.defaultWidth = this.subTdProps.style.width;
                            this.subTdProps.style.width        = '120px';
                        }
                    }
                    else {
                        if (parseInt(this.tdProps.style.width) < 105) {
                            this.subTdProps.style.defaultWidth = this.subTdProps.style.width;
                            this.subTdProps.style.width        = '105px';
                        }
                    }
                }
                else {
                    if ('undefined' != typeof this.subTdProps.style.defaultWidth) {
                        this.subTdProps.style.width = this.subTdProps.style.defaultWidth;
                        delete this.subTdProps.style.defaultWidth;
                    }
                }
            }
		}
		else {
            var sTextValue = this.getTextFunc( _value );				
            if (('c' == this.cfg.lang) && ('undefined' != typeof this.tdProps.style.width)) {
                var iTextValueLength = sTextValue.getLen();
                if (iTextValueLength > 8 && iTextValueLength < 12) {
                    if (bAddCheckBox) {
                        if (parseInt(this.tdProps.style.width) < 85) {
                            this.tdProps.style.defaultWidth = this.tdProps.style.width;
                            this.tdProps.style.width        = '85px';
                        }
                    }
                }
                else if (iTextValueLength > 12) {
                    if (bAddCheckBox) {
                        if (parseInt(this.tdProps.style.width) < 120) {
                            this.tdProps.style.defaultWidth = this.tdProps.style.width;
                            this.tdProps.style.width        = '120px';
                        }
                    }
                    else {
                        if (parseInt(this.tdProps.style.width) < 105) {
                            this.tdProps.style.defaultWidth = this.tdProps.style.width;
                            this.tdProps.style.width        = '105px';
                        }
                    }
                }
                else {
                    if ('undefined' != typeof this.tdProps.style.defaultWidth) {
                        this.tdProps.style.width = this.tdProps.style.defaultWidth;
                        delete this.tdProps.style.defaultWidth;
                    }
                }
            }

            td.appendChild(document.createTextNode(sTextValue));
		}
		this.setProps( td , this.tdProps );
		return td;
	}
	pt.createCitySelectTd=function(data,tr,maxCityNumber){
		if(data){
			if ( data['subIds'] != undefined ) {			
			 var td = document.createElement( 'td' );			 
			 td.innerHTML=data['pareName'];
			 if ( data['pareClassName'] ) {
					td.className = data['pareClassName'];
			 }
			 tr.appendChild(td);
			 var _values = data['subIds'];
			}			
		   for ( var k = 0 ; k <maxCityNumber ; k++ ) {	
				if(k<_values.length){
					tr.appendChild( this.createAreaTd( _values[k] ) );
				}else{
					var tmptd=document.createElement("td");									
					tr.appendChild(tmptd);
				}
			}		
						
		}	
	}
	pt.createSelectAreaTr = function( data ) {
		if ( data ) {
			var tr = this.tbl.insertRow( -1  );
			if ( data['trClassName'] ) {
				tr.className = data['trClassName'];
			}
			if ( data['subIds'] != undefined ) {
				var td = document.createElement( 'td' );
				td.rowSpan = Math.ceil( data['subIds'].length / ( this.colNum - 1 ) );
				td.innerHTML = data['pareName'];
				if ( data['pareClassName'] ) {
					td.className = data['pareClassName'];
				}
				tr.appendChild( td );
				var _values = data['subIds'];
				var hasLeftPare = true;
			}
			else {
				var _values = data;
				var hasLeftPare = false;
			} 
			
			for ( var k = 0 ; k < _values.length ; k++ ) {
				if ( ( !hasLeftPare && 0 == k % this.colNum ) || ( hasLeftPare && k != 0 && 0 == k % ( this.colNum - 1 ) ) ) {
					tr = this.tbl.insertRow( -1  );
					if ( data['trClassName'] ) {
						tr.className = data['trClassName'];
					}
				}
				tr.appendChild( this.createAreaTd( _values[k] ) );
			}
			var colNum = hasLeftPare ? this.colNum - 1 : this.colNum;
			var modNum = k % colNum;
			if ( modNum > 0 ) {
				var td = document.createElement( 'td' );
				td.colSpan = colNum - modNum;
				tr.appendChild( td );
			}
		}
	}
	//override the method
	pt.getTextFunc = function( _value ) {
	var _text = '';
	if ( this.data && this.data[_value] ) {
		if(_value=='0300')  {
			if(this.cfg.lang=='c'){
				_text = this.data[_value]+"(除深圳)";
			}else{
				_text = this.data[_value];
			}
		}
		else
			_text = this.data[_value];
	}
	return _text;
	}

})();
