﻿<%@ WebHandler Language="C#" Class="SavePhoto" %>

using System;
using System.Web;
using System.IO;
using System.Data;
using System.Drawing;

public class SavePhoto : IHttpHandler {

    public void ProcessRequest(HttpContext context) {
        context.Response.ContentType = "text/plain";

        if (context.Request.Form["PHeight"] != null && context.Request.Form["PWidth"] != null && context.Request.Form["strBMP"] != null) {
            try {
                int height = int.Parse(context.Request.Form["PHeight"].ToString());
                int width = int.Parse(context.Request.Form["PWidth"].ToString());
                string strBmp = context.Request.Form["strBMP"].ToString();
                SaveBmp(BuildBitmap(width, height, strBmp), context.Server.MapPath("UpImage"));

                context.Response.Write("RetMsg=true");
            } catch (Exception) {
                context.Response.Write("RetMsg=false");
            }
        }

    }

    public bool IsReusable {
        get {
            return false;
        }
    }
    public System.Drawing.Bitmap BuildBitmap(int width, int height, string strBmp) {
        System.Drawing.Bitmap tmpBmp = new Bitmap(width, height, System.Drawing.Imaging.PixelFormat.Format32bppRgb);
        string[] StmpBmp = strBmp.Split(',');
        int pos = 0;
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                tmpBmp.SetPixel(x, y, Color.FromArgb(int.Parse(StmpBmp[pos], System.Globalization.NumberStyles.HexNumber)));
                pos++;
            }
        }
        return tmpBmp;
    }
    public void SaveBmp(System.Drawing.Bitmap bmp, string filePath) {
        string _picName = DateTime.Now.ToFileTime() + ".jpg";
        string FileName = filePath + "\\" + _picName;
        bmp.Save(FileName, System.Drawing.Imaging.ImageFormat.Bmp);
        MyITJob.Class1.ExecuteNonQuery(CommandType.Text, "update Person_Basemeans set [picture]='" + _picName + "' where pname='" + HttpContext.Current.Request.Cookies["User"]["name"] + "'", null);
    }

}