package com.shuangyulin_QQ287307421.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.shuangyulin_QQ287307421.utils.ExportExcelUtil;
import com.shuangyulin_QQ287307421.dao.BookTypeDAO;
import com.shuangyulin_QQ287307421.domain.BookType;
@Controller @Scope("prototype")
public class BookTypeAction extends ActionSupport {

    /*ǰڼҳ*/
    private int currentPage;
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
    public int getCurrentPage() {
        return currentPage;
    }

    /*һҳ*/
    private int totalPage;
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
    public int getTotalPage() {
        return totalPage;
    }

    private int bookTypeId;
    public void setBookTypeId(int bookTypeId) {
        this.bookTypeId = bookTypeId;
    }
    public int getBookTypeId() {
        return bookTypeId;
    }

    /*ǰѯܼ¼Ŀ*/
    private int recordNumber;
    public void setRecordNumber(int recordNumber) {
        this.recordNumber = recordNumber;
    }
    public int getRecordNumber() {
        return recordNumber;
    }

    /*ҵ*/
    @Resource BookTypeDAO bookTypeDAO;

    /*BookType*/
    private BookType bookType;
    public void setBookType(BookType bookType) {
        this.bookType = bookType;
    }
    public BookType getBookType() {
        return this.bookType;
    }

    /*תBookTypeͼ*/
    public String AddView() {
        ActionContext ctx = ActionContext.getContext();
        return "add_view";
    }

    /*BookTypeϢ*/
    @SuppressWarnings("deprecation")
    public String AddBookType() {
        ActionContext ctx = ActionContext.getContext();
        try {
            bookTypeDAO.AddBookType(bookType);
            ctx.put("message",  java.net.URLEncoder.encode("BookTypeӳɹ!"));
            return "add_success";
        } catch (Exception e) {
            e.printStackTrace();
            ctx.put("error",  java.net.URLEncoder.encode("BookTypeʧ!"));
            return "error";
        }
    }

    /*ѯBookTypeϢ*/
    public String QueryBookType() {
        if(currentPage == 0) currentPage = 1;
        List<BookType> bookTypeList = bookTypeDAO.QueryBookTypeInfo(currentPage);
        /*ܵҳܵļ¼*/
        bookTypeDAO.CalculateTotalPageAndRecordNumber();
        /*ȡܵҳĿ*/
        totalPage = bookTypeDAO.getTotalPage();
        /*ǰѯܼ¼*/
        recordNumber = bookTypeDAO.getRecordNumber();
        ActionContext ctx = ActionContext.getContext();
        ctx.put("bookTypeList",  bookTypeList);
        ctx.put("totalPage", totalPage);
        ctx.put("recordNumber", recordNumber);
        ctx.put("currentPage", currentPage);
        return "query_view";
    }

    /*̨excel*/
    public String QueryBookTypeOutputToExcel() { 
        List<BookType> bookTypeList = bookTypeDAO.QueryBookTypeInfo();
        ExportExcelUtil ex = new ExportExcelUtil();
        String title = "BookTypeϢ¼"; 
        String[] headers = { "ͼ","","ɽ"};
        List<String[]> dataset = new ArrayList<String[]>(); 
        for(int i=0;i<bookTypeList.size();i++) {
        	BookType bookType = bookTypeList.get(i); 
        	dataset.add(new String[]{bookType.getBookTypeId() + "",bookType.getBookTypeName(),bookType.getDays() + ""});
        }
        /*
        OutputStream out = null;
		try {
			out = new FileOutputStream("C://output.xls");
			ex.exportExcel(title,headers, dataset, out);
		    out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		*/
		HttpServletResponse response = null;//һHttpServletResponse 
		OutputStream out = null;//һ 
		try { 
			response = ServletActionContext.getResponse();//ʼHttpServletResponse 
			out = response.getOutputStream();//
			response.setHeader("Content-disposition","attachment; filename="+"BookType.xls");//filenameصxlsӢ 
			response.setContentType("application/msexcel;charset=UTF-8");// 
			response.setHeader("Pragma","No-cache");//ͷ 
			response.setHeader("Cache-Control","no-cache");//ͷ 
			response.setDateHeader("Expires", 0);//ͷ  
			String rootPath = ServletActionContext.getServletContext().getRealPath("/");
			ex.exportExcel(rootPath,title,headers, dataset, out);
			out.flush();
		} catch (IOException e) { 
			e.printStackTrace(); 
		}finally{
			try{
				if(out!=null){ 
					out.close(); 
				}
			}catch(IOException e){ 
				e.printStackTrace(); 
			} 
		}
		return null;
    }
    /*ǰ̨ѯBookTypeϢ*/
    public String FrontQueryBookType() {
        if(currentPage == 0) currentPage = 1;
        List<BookType> bookTypeList = bookTypeDAO.QueryBookTypeInfo(currentPage);
        /*ܵҳܵļ¼*/
        bookTypeDAO.CalculateTotalPageAndRecordNumber();
        /*ȡܵҳĿ*/
        totalPage = bookTypeDAO.getTotalPage();
        /*ǰѯܼ¼*/
        recordNumber = bookTypeDAO.getRecordNumber();
        ActionContext ctx = ActionContext.getContext();
        ctx.put("bookTypeList",  bookTypeList);
        ctx.put("totalPage", totalPage);
        ctx.put("recordNumber", recordNumber);
        ctx.put("currentPage", currentPage);
        return "front_query_view";
    }

    /*ѯҪ޸ĵBookTypeϢ*/
    public String ModifyBookTypeQuery() {
        ActionContext ctx = ActionContext.getContext();
        /*bookTypeIdȡBookType*/
        BookType bookType = bookTypeDAO.GetBookTypeByBookTypeId(bookTypeId);

        ctx.put("bookType",  bookType);
        return "modify_view";
    }

    /*ѯҪ޸ĵBookTypeϢ*/
    public String FrontShowBookTypeQuery() {
        ActionContext ctx = ActionContext.getContext();
        /*bookTypeIdȡBookType*/
        BookType bookType = bookTypeDAO.GetBookTypeByBookTypeId(bookTypeId);

        ctx.put("bookType",  bookType);
        return "front_show_view";
    }

    /*޸BookTypeϢ*/
    public String ModifyBookType() {
        ActionContext ctx = ActionContext.getContext();
        try {
            bookTypeDAO.UpdateBookType(bookType);
            ctx.put("message",  java.net.URLEncoder.encode("BookTypeϢ³ɹ!"));
            return "modify_success";
        } catch (Exception e) {
            e.printStackTrace();
            ctx.put("error",  java.net.URLEncoder.encode("BookTypeϢʧ!"));
            return "error";
       }
   }

    /*ɾBookTypeϢ*/
    public String DeleteBookType() {
        ActionContext ctx = ActionContext.getContext();
        try { 
            bookTypeDAO.DeleteBookType(bookTypeId);
            ctx.put("message",  java.net.URLEncoder.encode("BookTypeɾɹ!"));
            return "delete_success";
        } catch (Exception e) { 
            e.printStackTrace();
            ctx.put("error",  java.net.URLEncoder.encode("BookTypeɾʧ!"));
            return "error";
        }
    }

}
