package com.shuangyulin_QQ287307421.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.shuangyulin_QQ287307421.utils.ExportExcelUtil;
import com.shuangyulin_QQ287307421.dao.ReaderTypeDAO;
import com.shuangyulin_QQ287307421.domain.ReaderType;
@Controller @Scope("prototype")
public class ReaderTypeAction extends ActionSupport {

    /*ǰڼҳ*/
    private int currentPage;
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
    public int getCurrentPage() {
        return currentPage;
    }

    /*һҳ*/
    private int totalPage;
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
    public int getTotalPage() {
        return totalPage;
    }

    private int readerTypeId;
    public void setReaderTypeId(int readerTypeId) {
        this.readerTypeId = readerTypeId;
    }
    public int getReaderTypeId() {
        return readerTypeId;
    }

    /*ǰѯܼ¼Ŀ*/
    private int recordNumber;
    public void setRecordNumber(int recordNumber) {
        this.recordNumber = recordNumber;
    }
    public int getRecordNumber() {
        return recordNumber;
    }

    /*ҵ*/
    @Resource ReaderTypeDAO readerTypeDAO;

    /*ReaderType*/
    private ReaderType readerType;
    public void setReaderType(ReaderType readerType) {
        this.readerType = readerType;
    }
    public ReaderType getReaderType() {
        return this.readerType;
    }

    /*תReaderTypeͼ*/
    public String AddView() {
        ActionContext ctx = ActionContext.getContext();
        return "add_view";
    }

    /*ReaderTypeϢ*/
    @SuppressWarnings("deprecation")
    public String AddReaderType() {
        ActionContext ctx = ActionContext.getContext();
        try {
            readerTypeDAO.AddReaderType(readerType);
            ctx.put("message",  java.net.URLEncoder.encode("ReaderTypeӳɹ!"));
            return "add_success";
        } catch (Exception e) {
            e.printStackTrace();
            ctx.put("error",  java.net.URLEncoder.encode("ReaderTypeʧ!"));
            return "error";
        }
    }

    /*ѯReaderTypeϢ*/
    public String QueryReaderType() {
        if(currentPage == 0) currentPage = 1;
        List<ReaderType> readerTypeList = readerTypeDAO.QueryReaderTypeInfo(currentPage);
        /*ܵҳܵļ¼*/
        readerTypeDAO.CalculateTotalPageAndRecordNumber();
        /*ȡܵҳĿ*/
        totalPage = readerTypeDAO.getTotalPage();
        /*ǰѯܼ¼*/
        recordNumber = readerTypeDAO.getRecordNumber();
        ActionContext ctx = ActionContext.getContext();
        ctx.put("readerTypeList",  readerTypeList);
        ctx.put("totalPage", totalPage);
        ctx.put("recordNumber", recordNumber);
        ctx.put("currentPage", currentPage);
        return "query_view";
    }

    /*̨excel*/
    public String QueryReaderTypeOutputToExcel() { 
        List<ReaderType> readerTypeList = readerTypeDAO.QueryReaderTypeInfo();
        ExportExcelUtil ex = new ExportExcelUtil();
        String title = "ReaderTypeϢ¼"; 
        String[] headers = { "ͱ","","ɽĿ"};
        List<String[]> dataset = new ArrayList<String[]>(); 
        for(int i=0;i<readerTypeList.size();i++) {
        	ReaderType readerType = readerTypeList.get(i); 
        	dataset.add(new String[]{readerType.getReaderTypeId() + "",readerType.getReaderTypeName(),readerType.getNumber() + ""});
        }
        /*
        OutputStream out = null;
		try {
			out = new FileOutputStream("C://output.xls");
			ex.exportExcel(title,headers, dataset, out);
		    out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		*/
		HttpServletResponse response = null;//һHttpServletResponse 
		OutputStream out = null;//һ 
		try { 
			response = ServletActionContext.getResponse();//ʼHttpServletResponse 
			out = response.getOutputStream();//
			response.setHeader("Content-disposition","attachment; filename="+"ReaderType.xls");//filenameصxlsӢ 
			response.setContentType("application/msexcel;charset=UTF-8");// 
			response.setHeader("Pragma","No-cache");//ͷ 
			response.setHeader("Cache-Control","no-cache");//ͷ 
			response.setDateHeader("Expires", 0);//ͷ  
			String rootPath = ServletActionContext.getServletContext().getRealPath("/");
			ex.exportExcel(rootPath,title,headers, dataset, out);
			out.flush();
		} catch (IOException e) { 
			e.printStackTrace(); 
		}finally{
			try{
				if(out!=null){ 
					out.close(); 
				}
			}catch(IOException e){ 
				e.printStackTrace(); 
			} 
		}
		return null;
    }
    /*ǰ̨ѯReaderTypeϢ*/
    public String FrontQueryReaderType() {
        if(currentPage == 0) currentPage = 1;
        List<ReaderType> readerTypeList = readerTypeDAO.QueryReaderTypeInfo(currentPage);
        /*ܵҳܵļ¼*/
        readerTypeDAO.CalculateTotalPageAndRecordNumber();
        /*ȡܵҳĿ*/
        totalPage = readerTypeDAO.getTotalPage();
        /*ǰѯܼ¼*/
        recordNumber = readerTypeDAO.getRecordNumber();
        ActionContext ctx = ActionContext.getContext();
        ctx.put("readerTypeList",  readerTypeList);
        ctx.put("totalPage", totalPage);
        ctx.put("recordNumber", recordNumber);
        ctx.put("currentPage", currentPage);
        return "front_query_view";
    }

    /*ѯҪ޸ĵReaderTypeϢ*/
    public String ModifyReaderTypeQuery() {
        ActionContext ctx = ActionContext.getContext();
        /*readerTypeIdȡReaderType*/
        ReaderType readerType = readerTypeDAO.GetReaderTypeByReaderTypeId(readerTypeId);

        ctx.put("readerType",  readerType);
        return "modify_view";
    }

    /*ѯҪ޸ĵReaderTypeϢ*/
    public String FrontShowReaderTypeQuery() {
        ActionContext ctx = ActionContext.getContext();
        /*readerTypeIdȡReaderType*/
        ReaderType readerType = readerTypeDAO.GetReaderTypeByReaderTypeId(readerTypeId);

        ctx.put("readerType",  readerType);
        return "front_show_view";
    }

    /*޸ReaderTypeϢ*/
    public String ModifyReaderType() {
        ActionContext ctx = ActionContext.getContext();
        try {
            readerTypeDAO.UpdateReaderType(readerType);
            ctx.put("message",  java.net.URLEncoder.encode("ReaderTypeϢ³ɹ!"));
            return "modify_success";
        } catch (Exception e) {
            e.printStackTrace();
            ctx.put("error",  java.net.URLEncoder.encode("ReaderTypeϢʧ!"));
            return "error";
       }
   }

    /*ɾReaderTypeϢ*/
    public String DeleteReaderType() {
        ActionContext ctx = ActionContext.getContext();
        try { 
            readerTypeDAO.DeleteReaderType(readerTypeId);
            ctx.put("message",  java.net.URLEncoder.encode("ReaderTypeɾɹ!"));
            return "delete_success";
        } catch (Exception e) { 
            e.printStackTrace();
            ctx.put("error",  java.net.URLEncoder.encode("ReaderTypeɾʧ!"));
            return "error";
        }
    }

}
