package com.shuangyulin_QQ287307421.dao;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import com.shuangyulin_QQ287307421.domain.BookType;
import com.shuangyulin_QQ287307421.domain.Book;

@Service @Transactional
public class BookDAO {

	@Resource SessionFactory factory;
    /*ÿҳʾ¼Ŀ*/
    private final int PAGE_SIZE = 10;

    /*ѯܵҳ*/
    private int totalPage;
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
    public int getTotalPage() {
        return totalPage;
    }

    /*ѯܼ¼*/
    private int recordNumber;
    public void setRecordNumber(int recordNumber) {
        this.recordNumber = recordNumber;
    }
    public int getRecordNumber() {
        return recordNumber;
    }

    /*BookϢ*/
    public void AddBook(Book book) throws Exception {
    	Session s = factory.getCurrentSession();
    	s.save(book);
    }

    /*ѯBookϢ*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<Book> QueryBookInfo(String barcode,String bookName,BookType bookType,String publishDate,int currentPage) { 
    	Session s = factory.getCurrentSession();
    	String hql = "From Book book where 1=1";
    	if(!barcode.equals("")) hql = hql + " and book.barcode like '%" + barcode + "%'";
    	if(!bookName.equals("")) hql = hql + " and book.bookName like '%" + bookName + "%'";
    	if(null != bookType && bookType.getBookTypeId()!=0) hql += " and book.bookType.bookTypeId=" + bookType.getBookTypeId();
    	if(!publishDate.equals("")) hql = hql + " and book.publishDate like '%" + publishDate + "%'";
    	 Query q = s.createQuery(hql);
    	/*㵱ǰʾҳĿʼ¼*/
    	int startIndex = (currentPage-1) * this.PAGE_SIZE;
    	q.setFirstResult(startIndex);
    	q.setMaxResults(this.PAGE_SIZE);
    	List bookList = q.list();
    	return (ArrayList<Book>) bookList;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<Book> QueryBookInfo(String barcode,String bookName,BookType bookType,String publishDate) { 
    	Session s = factory.getCurrentSession();
    	String hql = "From Book book where 1=1";
    	if(!barcode.equals("")) hql = hql + " and book.barcode like '%" + barcode + "%'";
    	if(!bookName.equals("")) hql = hql + " and book.bookName like '%" + bookName + "%'";
    	if(null != bookType && bookType.getBookTypeId()!=0) hql += " and book.bookType.bookTypeId=" + bookType.getBookTypeId();
    	if(!publishDate.equals("")) hql = hql + " and book.publishDate like '%" + publishDate + "%'";
    	Query q = s.createQuery(hql);
    	List bookList = q.list();
    	return (ArrayList<Book>) bookList;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<Book> QueryAllBookInfo() {
        Session s = factory.getCurrentSession();
        String hql = "From Book";
        Query q = s.createQuery(hql);
        List bookList = q.list();
        return (ArrayList<Book>) bookList;
    }

    /*ܵҳͼ¼*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void CalculateTotalPageAndRecordNumber(String barcode,String bookName,BookType bookType,String publishDate) {
        Session s = factory.getCurrentSession();
        String hql = "From Book book where 1=1";
        if(!barcode.equals("")) hql = hql + " and book.barcode like '%" + barcode + "%'";
        if(!bookName.equals("")) hql = hql + " and book.bookName like '%" + bookName + "%'";
        if(null != bookType && bookType.getBookTypeId()!=0) hql += " and book.bookType.bookTypeId=" + bookType.getBookTypeId();
        if(!publishDate.equals("")) hql = hql + " and book.publishDate like '%" + publishDate + "%'";
        Query q = s.createQuery(hql);
        List bookList = q.list();
        recordNumber = bookList.size();
        int mod = recordNumber % this.PAGE_SIZE;
        totalPage = recordNumber / this.PAGE_SIZE;
        if(mod != 0) totalPage++;
    }

    /*ȡ*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Book GetBookByBarcode(String barcode) {
        Session s = factory.getCurrentSession();
        Book book = (Book)s.get(Book.class, barcode);
        return book;
    }

    /*BookϢ*/
    public void UpdateBook(Book book) throws Exception {
        Session s = factory.getCurrentSession();
        s.update(book);
    }

    /*ɾBookϢ*/
    public void DeleteBook (String barcode) throws Exception {
        Session s = factory.getCurrentSession(); 
        Object book = s.load(Book.class, barcode);
        s.delete(book);
    }

}
