package com.shuangyulin_QQ287307421.dao;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import com.shuangyulin_QQ287307421.domain.Book;
import com.shuangyulin_QQ287307421.domain.Reader;
import com.shuangyulin_QQ287307421.domain.LoanInfo;

@Service @Transactional
public class LoanInfoDAO {

	@Resource SessionFactory factory;
    /*ÿҳʾ¼Ŀ*/
    private final int PAGE_SIZE = 10;

    /*ѯܵҳ*/
    private int totalPage;
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
    public int getTotalPage() {
        return totalPage;
    }

    /*ѯܼ¼*/
    private int recordNumber;
    public void setRecordNumber(int recordNumber) {
        this.recordNumber = recordNumber;
    }
    public int getRecordNumber() {
        return recordNumber;
    }

    /*LoanInfoϢ*/
    public void AddLoanInfo(LoanInfo loanInfo) throws Exception {
    	Session s = factory.getCurrentSession();
    	s.save(loanInfo);
    }

    /*ѯLoanInfoϢ*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<LoanInfo> QueryLoanInfoInfo(Book book,Reader reader,int currentPage) { 
    	Session s = factory.getCurrentSession();
    	String hql = "From LoanInfo loanInfo where 1=1";
    	if(null != book && !book.getBarcode().equals("")) hql += " and loanInfo.book.barcode='" + book.getBarcode() + "'";
    	if(null != reader && !reader.getReaderNo().equals("")) hql += " and loanInfo.reader.readerNo='" + reader.getReaderNo() + "'";
    	 Query q = s.createQuery(hql);
    	/*㵱ǰʾҳĿʼ¼*/
    	int startIndex = (currentPage-1) * this.PAGE_SIZE;
    	q.setFirstResult(startIndex);
    	q.setMaxResults(this.PAGE_SIZE);
    	List loanInfoList = q.list();
    	return (ArrayList<LoanInfo>) loanInfoList;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<LoanInfo> QueryLoanInfoInfo(Book book,Reader reader) { 
    	Session s = factory.getCurrentSession();
    	String hql = "From LoanInfo loanInfo where 1=1";
    	if(null != book && !book.getBarcode().equals("")) hql += " and loanInfo.book.barcode='" + book.getBarcode() + "'";
    	if(null != reader && !reader.getReaderNo().equals("")) hql += " and loanInfo.reader.readerNo='" + reader.getReaderNo() + "'";
    	Query q = s.createQuery(hql);
    	List loanInfoList = q.list();
    	return (ArrayList<LoanInfo>) loanInfoList;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<LoanInfo> QueryAllLoanInfoInfo() {
        Session s = factory.getCurrentSession();
        String hql = "From LoanInfo";
        Query q = s.createQuery(hql);
        List loanInfoList = q.list();
        return (ArrayList<LoanInfo>) loanInfoList;
    }

    /*ܵҳͼ¼*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void CalculateTotalPageAndRecordNumber(Book book,Reader reader) {
        Session s = factory.getCurrentSession();
        String hql = "From LoanInfo loanInfo where 1=1";
        if(null != book && !book.getBarcode().equals("")) hql += " and loanInfo.book.barcode='" + book.getBarcode() + "'";
        if(null != reader && !reader.getReaderNo().equals("")) hql += " and loanInfo.reader.readerNo='" + reader.getReaderNo() + "'";
        Query q = s.createQuery(hql);
        List loanInfoList = q.list();
        recordNumber = loanInfoList.size();
        int mod = recordNumber % this.PAGE_SIZE;
        totalPage = recordNumber / this.PAGE_SIZE;
        if(mod != 0) totalPage++;
    }

    /*ȡ*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public LoanInfo GetLoanInfoByLoadId(int loadId) {
        Session s = factory.getCurrentSession();
        LoanInfo loanInfo = (LoanInfo)s.get(LoanInfo.class, loadId);
        return loanInfo;
    }

    /*LoanInfoϢ*/
    public void UpdateLoanInfo(LoanInfo loanInfo) throws Exception {
        Session s = factory.getCurrentSession();
        s.update(loanInfo);
    }

    /*ɾLoanInfoϢ*/
    public void DeleteLoanInfo (int loadId) throws Exception {
        Session s = factory.getCurrentSession(); 
        Object loanInfo = s.load(LoanInfo.class, loadId);
        s.delete(loanInfo);
    }

}
