package com.shuangyulin_QQ287307421.dao;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import com.shuangyulin_QQ287307421.domain.ReaderType;

@Service @Transactional
public class ReaderTypeDAO {

	@Resource SessionFactory factory;
    /*ÿҳʾ¼Ŀ*/
    private final int PAGE_SIZE = 10;

    /*ѯܵҳ*/
    private int totalPage;
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
    public int getTotalPage() {
        return totalPage;
    }

    /*ѯܼ¼*/
    private int recordNumber;
    public void setRecordNumber(int recordNumber) {
        this.recordNumber = recordNumber;
    }
    public int getRecordNumber() {
        return recordNumber;
    }

    /*ReaderTypeϢ*/
    public void AddReaderType(ReaderType readerType) throws Exception {
    	Session s = factory.getCurrentSession();
    	s.save(readerType);
    }

    /*ѯReaderTypeϢ*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<ReaderType> QueryReaderTypeInfo(int currentPage) { 
    	Session s = factory.getCurrentSession();
    	String hql = "From ReaderType readerType where 1=1";
    	 Query q = s.createQuery(hql);
    	/*㵱ǰʾҳĿʼ¼*/
    	int startIndex = (currentPage-1) * this.PAGE_SIZE;
    	q.setFirstResult(startIndex);
    	q.setMaxResults(this.PAGE_SIZE);
    	List readerTypeList = q.list();
    	return (ArrayList<ReaderType>) readerTypeList;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<ReaderType> QueryReaderTypeInfo() { 
    	Session s = factory.getCurrentSession();
    	String hql = "From ReaderType readerType where 1=1";
    	Query q = s.createQuery(hql);
    	List readerTypeList = q.list();
    	return (ArrayList<ReaderType>) readerTypeList;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ArrayList<ReaderType> QueryAllReaderTypeInfo() {
        Session s = factory.getCurrentSession();
        String hql = "From ReaderType";
        Query q = s.createQuery(hql);
        List readerTypeList = q.list();
        return (ArrayList<ReaderType>) readerTypeList;
    }

    /*ܵҳͼ¼*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void CalculateTotalPageAndRecordNumber() {
        Session s = factory.getCurrentSession();
        String hql = "From ReaderType readerType where 1=1";
        Query q = s.createQuery(hql);
        List readerTypeList = q.list();
        recordNumber = readerTypeList.size();
        int mod = recordNumber % this.PAGE_SIZE;
        totalPage = recordNumber / this.PAGE_SIZE;
        if(mod != 0) totalPage++;
    }

    /*ȡ*/
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public ReaderType GetReaderTypeByReaderTypeId(int readerTypeId) {
        Session s = factory.getCurrentSession();
        ReaderType readerType = (ReaderType)s.get(ReaderType.class, readerTypeId);
        return readerType;
    }

    /*ReaderTypeϢ*/
    public void UpdateReaderType(ReaderType readerType) throws Exception {
        Session s = factory.getCurrentSession();
        s.update(readerType);
    }

    /*ɾReaderTypeϢ*/
    public void DeleteReaderType (int readerTypeId) throws Exception {
        Session s = factory.getCurrentSession(); 
        Object readerType = s.load(ReaderType.class, readerTypeId);
        s.delete(readerType);
    }

}
