/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KetamaNodeLocator
extends SpyObject
implements NodeLocator {
    static final int NUM_REPS = 160;
    final SortedMap<Long, MemcachedNode> ketamaNodes;
    final Collection<MemcachedNode> allNodes;
    final HashAlgorithm hashAlg;

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.ketamaNodes = new TreeMap<Long, MemcachedNode>();
        for (MemcachedNode node : nodes) {
            int i;
            String sockStr = String.valueOf(node.getSocketAddress());
            if (alg == HashAlgorithm.KETAMA_HASH) {
                for (i = 0; i < 40; ++i) {
                    byte[] digest = HashAlgorithm.computeMd5(sockStr + "-" + i);
                    for (int h = 0; h < 4; ++h) {
                        Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                        this.ketamaNodes.put(k, node);
                    }
                }
                continue;
            }
            for (i = 0; i < 160; ++i) {
                this.ketamaNodes.put(this.hashAlg.hash(sockStr + "-" + i), node);
            }
        }
        assert (this.ketamaNodes.size() == 160 * nodes.size());
    }

    private KetamaNodeLocator(SortedMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashAlgorithm alg) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashAlg = alg;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        MemcachedNode rv = this.getNodeForKey(this.hashAlg.hash(k));
        assert (rv != null) : "Found no node for key " + k;
        return rv;
    }

    long getMaxKey() {
        return this.ketamaNodes.lastKey();
    }

    MemcachedNode getNodeForKey(long hash) {
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, MemcachedNode> tailMap = this.ketamaNodes.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ketamaNodes.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        MemcachedNode rv = (MemcachedNode)this.ketamaNodes.get(hash);
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new KetamaIterator(k, this.allNodes.size());
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> smn = new TreeMap<Long, MemcachedNode>(this.ketamaNodes);
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        for (Map.Entry entry : smn.entrySet()) {
            entry.setValue(new MemcachedNodeROImpl((MemcachedNode)entry.getValue()));
        }
        for (MemcachedNode memcachedNode : this.allNodes) {
            an.add(new MemcachedNodeROImpl(memcachedNode));
        }
        return new KetamaNodeLocator(smn, an, this.hashAlg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KetamaIterator
    implements Iterator<MemcachedNode> {
        final String key;
        long hashVal;
        int remainingTries;
        int numTries = 0;

        public KetamaIterator(String k, int t) {
            this.hashVal = KetamaNodeLocator.this.hashAlg.hash(k);
            this.remainingTries = t;
            this.key = k;
        }

        private void nextHash() {
            long tmpKey = KetamaNodeLocator.this.hashAlg.hash(this.numTries++ + this.key);
            this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
            this.hashVal &= 0xFFFFFFFFL;
            --this.remainingTries;
        }

        @Override
        public boolean hasNext() {
            return this.remainingTries > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MemcachedNode next() {
            try {
                MemcachedNode memcachedNode = KetamaNodeLocator.this.getNodeForKey(this.hashVal);
                return memcachedNode;
            }
            finally {
                this.nextHash();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

