/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.BaseSerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhalinV1Transcoder
extends BaseSerializingTranscoder
implements Transcoder<Object> {
    public static final int SPECIAL_BYTE = 1;
    public static final int SPECIAL_BOOLEAN = 2;
    public static final int SPECIAL_INTEGER = 3;
    public static final int SPECIAL_LONG = 4;
    public static final int SPECIAL_CHARACTER = 5;
    public static final int SPECIAL_STRING = 6;
    public static final int SPECIAL_STRINGBUFFER = 7;
    public static final int SPECIAL_FLOAT = 8;
    public static final int SPECIAL_SHORT = 9;
    public static final int SPECIAL_DOUBLE = 10;
    public static final int SPECIAL_DATE = 11;
    public static final int SPECIAL_STRINGBUILDER = 12;
    public static final int COMPRESSED = 2;
    public static final int SERIALIZED = 8;

    public WhalinV1Transcoder() {
        super(0x100000);
    }

    @Override
    public CachedData encode(Object o) {
        byte[] b = null;
        int flags = 0;
        if (o instanceof String) {
            b = this.encodeW1String((String)o);
        } else if (o instanceof StringBuffer) {
            b = this.encodeStringBuffer((StringBuffer)o);
        } else if (o instanceof StringBuilder) {
            b = this.encodeStringbuilder((StringBuilder)o);
        } else if (o instanceof Long) {
            b = this.encodeLong((Long)o);
        } else if (o instanceof Integer) {
            b = this.encodeInteger((Integer)o);
        } else if (o instanceof Short) {
            b = this.encodeShort((Short)o);
        } else if (o instanceof Boolean) {
            b = this.encodeBoolean((Boolean)o);
        } else if (o instanceof Date) {
            b = this.encodeLong(((Date)o).getTime(), 11);
        } else if (o instanceof Byte) {
            b = this.encodeByte((Byte)o);
        } else if (o instanceof Float) {
            b = this.encodeFloat((Float)o);
        } else if (o instanceof Double) {
            b = this.encodeDouble((Double)o);
        } else {
            if (o instanceof byte[]) {
                throw new IllegalArgumentException("Cannot handle byte arrays.");
            }
            if (o instanceof Character) {
                b = this.encodeCharacter((Character)o);
            } else {
                b = this.serialize(o);
                flags |= 8;
            }
        }
        assert (b != null);
        if (b.length > this.compressionThreshold) {
            byte[] compressed = this.compress(b);
            if (compressed.length < b.length) {
                this.getLogger().info("Compressed %s from %d to %d", o.getClass().getName(), b.length, compressed.length);
                b = compressed;
                flags |= 2;
            } else {
                this.getLogger().info("Compression increased the size of %s from %d to %d", o.getClass().getName(), b.length, compressed.length);
            }
        }
        return new CachedData(flags, b, this.getMaxSize());
    }

    @Override
    public Object decode(CachedData d) {
        byte[] data = d.getData();
        Object rv = null;
        if ((d.getFlags() & 2) != 0) {
            data = this.decompress(d.getData());
        }
        if ((d.getFlags() & 8) != 0) {
            rv = this.deserialize(data);
        } else {
            byte f = data[0];
            switch (f) {
                case 2: {
                    rv = this.decodeBoolean(data);
                    break;
                }
                case 3: {
                    rv = this.decodeInteger(data);
                    break;
                }
                case 9: {
                    rv = this.decodeShort(data);
                    break;
                }
                case 4: {
                    rv = this.decodeLong(data);
                    break;
                }
                case 11: {
                    rv = new Date(this.decodeLong(data));
                    break;
                }
                case 1: {
                    rv = this.decodeByte(data);
                    break;
                }
                case 8: {
                    rv = this.decodeFloat(data);
                    break;
                }
                case 10: {
                    rv = this.decodeDouble(data);
                    break;
                }
                case 6: {
                    rv = this.decodeW1String(data);
                    break;
                }
                case 7: {
                    rv = new StringBuffer(this.decodeW1String(data));
                    break;
                }
                case 12: {
                    rv = new StringBuilder(this.decodeW1String(data));
                    break;
                }
                case 5: {
                    rv = this.decodeCharacter(data);
                    break;
                }
                default: {
                    this.getLogger().warn("Cannot handle data with flags %x", f);
                }
            }
        }
        return rv;
    }

    private Short decodeShort(byte[] data) {
        return (short)this.decodeInteger(data).intValue();
    }

    private Byte decodeByte(byte[] in) {
        assert (in.length == 2) : "Wrong length for a byte";
        byte value = in[1];
        return value;
    }

    private Integer decodeInteger(byte[] in) {
        assert (in.length == 5) : "Wrong length for an int";
        return (int)this.decodeLong(in).longValue();
    }

    private Float decodeFloat(byte[] in) {
        assert (in.length == 5) : "Wrong length for a float";
        Integer l = this.decodeInteger(in);
        return Float.valueOf(Float.intBitsToFloat(l));
    }

    private Double decodeDouble(byte[] in) {
        assert (in.length == 9) : "Wrong length for a double";
        Long l = this.decodeLong(in);
        return Double.longBitsToDouble(l);
    }

    private Boolean decodeBoolean(byte[] in) {
        assert (in.length == 2) : "Wrong length for a boolean";
        return in[1] == 1;
    }

    private Long decodeLong(byte[] in) {
        long rv = 0L;
        for (int idx = 1; idx < in.length; ++idx) {
            int i = in[idx];
            rv = rv << 8 | (long)(i < 0 ? 256 + i : i);
        }
        return rv;
    }

    private Character decodeCharacter(byte[] b) {
        return Character.valueOf((char)this.decodeInteger(b).intValue());
    }

    private String decodeW1String(byte[] b) {
        try {
            return new String(b, 1, b.length - 1, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] encodeByte(Byte value) {
        byte[] b = new byte[]{1, value};
        return b;
    }

    private byte[] encodeBoolean(Boolean value) {
        byte[] b = new byte[]{2, (byte)(value != false ? 1 : 0)};
        return b;
    }

    private byte[] encodeInteger(Integer value) {
        byte[] b = this.encodeNum(value.intValue(), 4);
        b[0] = 3;
        return b;
    }

    private byte[] encodeLong(Long value, int type) {
        byte[] b = this.encodeNum(value, 8);
        b[0] = (byte)type;
        return b;
    }

    private byte[] encodeLong(Long value) {
        return this.encodeLong(value, 4);
    }

    private byte[] encodeShort(Short value) {
        byte[] b = this.encodeInteger((int)value);
        b[0] = 9;
        return b;
    }

    private byte[] encodeFloat(Float value) {
        byte[] b = this.encodeInteger(Float.floatToIntBits(value.floatValue()));
        b[0] = 8;
        return b;
    }

    private byte[] encodeDouble(Double value) {
        byte[] b = this.encodeLong(Double.doubleToLongBits(value));
        b[0] = 10;
        return b;
    }

    private byte[] encodeCharacter(Character value) {
        byte[] result = this.encodeInteger(Integer.valueOf(value.charValue()));
        result[0] = 5;
        return result;
    }

    private byte[] encodeStringBuffer(StringBuffer value) {
        byte[] b = this.encodeW1String(value.toString());
        b[0] = 7;
        return b;
    }

    private byte[] encodeStringbuilder(StringBuilder value) {
        byte[] b = this.encodeW1String(value.toString());
        b[0] = 12;
        return b;
    }

    private byte[] encodeW1String(String value) {
        byte[] svalue = null;
        try {
            svalue = value.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] result = new byte[svalue.length + 1];
        System.arraycopy(svalue, 0, result, 1, svalue.length);
        result[0] = 6;
        return result;
    }

    private byte[] encodeNum(long l, int maxBytes) {
        byte[] rv = new byte[maxBytes + 1];
        for (int i = 0; i < rv.length - 1; ++i) {
            int pos = rv.length - i - 1;
            rv[pos] = (byte)(l >> 8 * i & 0xFFL);
        }
        return rv;
    }
}

