/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.resizers.Resizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailParameter {
    public static final String ORIGINAL_FORMAT = null;
    public static final String DEFAULT_FORMAT_TYPE = null;
    public static final float DEFAULT_QUALITY = Float.NaN;
    public static final int ORIGINAL_IMAGE_TYPE = -1;
    public static final int DEFAULT_IMAGE_TYPE = 2;
    private final Dimension thumbnailSize;
    private final double widthScalingFactor;
    private final double heightScalingFactor;
    private final boolean keepAspectRatio;
    private final String outputFormat;
    private final String outputFormatType;
    private final float outputQuality;
    private final int imageType;
    private final List<ImageFilter> filters;
    private final Resizer resizer;
    private final Region sourceRegion;

    public ThumbnailParameter(Dimension dimension, Region region, boolean bl, String string, String string2, float f, int n, List<ImageFilter> list, Resizer resizer) {
        if (dimension == null) {
            throw new IllegalArgumentException("Thumbnail size cannot be null.");
        }
        if (dimension.width < 0 || dimension.height < 0) {
            throw new IllegalArgumentException("Thumbnail dimensions must be greater than 0.");
        }
        this.thumbnailSize = dimension;
        this.sourceRegion = region;
        this.widthScalingFactor = Double.NaN;
        this.heightScalingFactor = Double.NaN;
        this.keepAspectRatio = bl;
        this.outputFormat = string;
        this.outputFormatType = string2;
        if ((f < 0.0f || f > 1.0f) && !Float.isNaN(f)) {
            throw new IllegalArgumentException("The output quality must be between 0.0f and 1.0f, or Float.NaN to use the default compression quality of codec being used.");
        }
        this.outputQuality = f;
        this.imageType = n;
        List<Object> list2 = this.filters = list == null ? Collections.emptyList() : list;
        if (resizer == null) {
            throw new IllegalArgumentException("Resizer cannot be null");
        }
        this.resizer = resizer;
    }

    public ThumbnailParameter(double d, double d2, Region region, boolean bl, String string, String string2, float f, int n, List<ImageFilter> list, Resizer resizer) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Scaling factor is less than or equal to 0.");
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
        this.widthScalingFactor = d;
        this.heightScalingFactor = d2;
        this.sourceRegion = region;
        this.thumbnailSize = null;
        this.keepAspectRatio = bl;
        this.outputFormat = string;
        this.outputFormatType = string2;
        if ((f < 0.0f || f > 1.0f) && !Float.isNaN(f)) {
            throw new IllegalArgumentException("The output quality must be between 0.0f and 1.0f, or Float.NaN to use the default compression quality of codec being used.");
        }
        this.outputQuality = f;
        this.imageType = n;
        List<Object> list2 = this.filters = list == null ? Collections.emptyList() : list;
        if (resizer == null) {
            throw new IllegalArgumentException("Resizer cannot be null");
        }
        this.resizer = resizer;
    }

    public Dimension getSize() {
        if (this.thumbnailSize != null) {
            return (Dimension)this.thumbnailSize.clone();
        }
        return null;
    }

    public double getWidthScalingFactor() {
        return this.widthScalingFactor;
    }

    public double getHeightScalingFactor() {
        return this.heightScalingFactor;
    }

    public int getType() {
        return this.imageType;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getOutputFormatType() {
        return this.outputFormatType;
    }

    public float getOutputQuality() {
        return this.outputQuality;
    }

    public List<ImageFilter> getImageFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public Resizer getResizer() {
        return this.resizer;
    }

    public boolean useOriginalImageType() {
        return this.imageType == -1;
    }

    public Region getSourceRegion() {
        return this.sourceRegion;
    }
}

