/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;

public class Canvas
implements ImageFilter {
    private int width;
    private int height;
    private final Position position;
    private Color fillColor;
    private final boolean crop;

    public Canvas(int n, int n2, Position position) {
        this(n, n2, position, true, null);
    }

    public Canvas(int n, int n2, Position position, boolean bl) {
        this(n, n2, position, bl, null);
    }

    public Canvas(int n, int n2, Position position, Color color) {
        this(n, n2, position, true, color);
    }

    public Canvas(int n, int n2, Position position, boolean bl, Color color) {
        this.width = n;
        this.height = n2;
        this.position = position;
        this.crop = bl;
        this.fillColor = color;
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        if (!this.crop && bufferedImage.getWidth() > this.width) {
            this.width = bufferedImage.getWidth();
        }
        if (!this.crop && bufferedImage.getHeight() > this.height) {
            this.height = bufferedImage.getHeight();
        }
        Point point = this.position.calculate(this.width, this.height, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, 0, 0);
        BufferedImage bufferedImage2 = new BufferedImage(this.width, this.height, bufferedImage.getType());
        Graphics graphics = bufferedImage2.getGraphics();
        if (this.fillColor == null && bufferedImage.getColorModel().hasAlpha()) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.width, this.height);
        } else if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        graphics.drawImage(bufferedImage, point.x, point.y, null);
        graphics.dispose();
        return bufferedImage2;
    }
}

