/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.makers;

import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.makers.ThumbnailMaker;

public final class FixedSizeThumbnailMaker
extends ThumbnailMaker {
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_KEEP_RATIO = "keepRatio";
    private int width;
    private int height;
    private boolean keepRatio;

    public FixedSizeThumbnailMaker() {
        this.ready.unset(PARAM_SIZE);
        this.ready.unset(PARAM_KEEP_RATIO);
    }

    public FixedSizeThumbnailMaker(int n, int n2) {
        this();
        this.size(n, n2);
    }

    public FixedSizeThumbnailMaker(int n, int n2, boolean bl) {
        this();
        this.size(n, n2);
        this.keepAspectRatio(bl);
    }

    public FixedSizeThumbnailMaker size(int n, int n2) {
        if (this.ready.isSet(PARAM_SIZE)) {
            throw new IllegalStateException("The size has already been set.");
        }
        this.width = n;
        this.height = n2;
        this.ready.set(PARAM_SIZE);
        return this;
    }

    public FixedSizeThumbnailMaker keepAspectRatio(boolean bl) {
        if (this.ready.isSet(PARAM_KEEP_RATIO)) {
            throw new IllegalStateException("Whether to keep the aspect ratio has already been set.");
        }
        this.keepRatio = bl;
        this.ready.set(PARAM_KEEP_RATIO);
        return this;
    }

    public BufferedImage make(BufferedImage bufferedImage) {
        double d;
        int n;
        int n2;
        double d2;
        int n3 = this.width;
        int n4 = this.height;
        if (this.keepRatio && Double.compare(d2 = (double)(n2 = bufferedImage.getWidth()) / (double)(n = bufferedImage.getHeight()), d = (double)n3 / (double)n4) != 0) {
            if (d2 > d) {
                n3 = this.width;
                n4 = (int)((double)n3 / d2);
            } else {
                n3 = (int)((double)n4 * d2);
                n4 = this.height;
            }
        }
        return super.makeThumbnail(bufferedImage, n3, n4);
    }
}

