/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSink
extends AbstractImageSink<File> {
    private File destinationFile;
    private final boolean allowOverwrite;

    public FileImageSink(File file) {
        this(file, true);
    }

    public FileImageSink(File file, boolean bl) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = file;
        this.outputFormat = FileImageSink.getExtension(file);
        this.allowOverwrite = bl;
    }

    public FileImageSink(String string) {
        this(string, true);
    }

    public FileImageSink(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = new File(string);
        this.outputFormat = FileImageSink.getExtension(this.destinationFile);
        this.allowOverwrite = bl;
    }

    private static boolean isMatchingFormat(String string, String string2) {
        String[] stringArray;
        ImageWriter imageWriter;
        if (string == null || string2 == null) {
            return false;
        }
        try {
            imageWriter = ImageIO.getImageWritersByFormatName(string).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        for (String string3 : stringArray = imageWriter.getOriginatingProvider().getFileSuffixes()) {
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(File file) {
        String string = file.getName();
        if (string.indexOf(46) != -1 && string.lastIndexOf(46) != string.length() - 1) {
            int n = string.lastIndexOf(46);
            return string.substring(n + 1);
        }
        return null;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        FileOutputStream fileOutputStream;
        List<String> list;
        Iterator<Object> iterator;
        super.write(bufferedImage);
        String string = FileImageSink.getExtension(this.destinationFile);
        String string2 = this.outputFormat;
        if (!(string2 == null || string != null && FileImageSink.isMatchingFormat(string2, string))) {
            this.destinationFile = new File(this.destinationFile.getAbsolutePath() + "." + string2);
        }
        if (!this.allowOverwrite && this.destinationFile.exists()) {
            throw new IllegalArgumentException("The destination file exists.");
        }
        if (string2 == null && string != null && (iterator = ImageIO.getImageReadersBySuffix(string)).hasNext()) {
            string2 = ((ImageReader)iterator.next()).getFormatName();
        }
        if (string2 == null) {
            throw new UnsupportedFormatException(string2, "Could not determine output format.");
        }
        iterator = ImageIO.getImageWritersByFormatName(string2);
        if (!iterator.hasNext()) {
            throw new UnsupportedFormatException(string2, "No suitable ImageWriter found for " + string2 + ".");
        }
        ImageWriter imageWriter = (ImageWriter)iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed() && this.param != null) {
            imageWriteParam.setCompressionMode(2);
            if (this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                imageWriteParam.setCompressionType(this.param.getOutputFormatType());
            } else {
                list = ThumbnailatorUtils.getSupportedOutputFormatTypes(string2);
                if (!list.isEmpty()) {
                    imageWriteParam.setCompressionType((String)list.get(0));
                }
            }
            if (!Float.isNaN(this.param.getOutputQuality())) {
                imageWriteParam.setCompressionQuality(this.param.getOutputQuality());
            }
        }
        try {
            fileOutputStream = new FileOutputStream(this.destinationFile);
            list = ImageIO.createImageOutputStream(fileOutputStream);
        }
        catch (IOException iOException) {
            throw new IOException("Could not open output file.");
        }
        if (list == null || fileOutputStream == null) {
            throw new IOException("Could not open output file.");
        }
        if (string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("bmp")) {
            bufferedImage = BufferedImages.copy(bufferedImage, 1);
        }
        imageWriter.setOutput(list);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        list.close();
        fileOutputStream.close();
    }

    @Override
    public File getSink() {
        return this.destinationFile;
    }
}

