/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.wltea.analyzer.IKSegmentation;
import org.wltea.analyzer.Lexeme;

public final class IKTokenizer
extends Tokenizer {
    private IKSegmentation _IKImplement;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int finalOffset;

    public IKTokenizer(Reader in, boolean isMaxWordLength) {
        super(in);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this._IKImplement = new IKSegmentation(in, isMaxWordLength);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        Lexeme nextLexeme = this._IKImplement.next();
        if (nextLexeme != null) {
            this.termAtt.setTermBuffer(nextLexeme.getLexemeText());
            this.termAtt.setTermLength(nextLexeme.getLength());
            this.offsetAtt.setOffset(nextLexeme.getBeginPosition(), nextLexeme.getEndPosition());
            this.finalOffset = nextLexeme.getEndPosition();
            return true;
        }
        return false;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this._IKImplement.reset(input);
    }

    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }
}

