/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.NullViewSelector;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;

public class EndState
extends State {
    private ViewSelector viewSelector = NullViewSelector.INSTANCE;
    private AttributeMapper outputMapper;

    public EndState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public ViewSelector getViewSelector() {
        return this.viewSelector;
    }

    public void setViewSelector(ViewSelector viewSelector) {
        Assert.notNull((Object)viewSelector, (String)"The view selector is required");
        this.viewSelector = viewSelector;
    }

    public AttributeMapper getOutputMapper() {
        return this.outputMapper;
    }

    public void setOutputMapper(AttributeMapper outputMapper) {
        this.outputMapper = outputMapper;
    }

    protected ViewSelection doEnter(RequestControlContext context) throws FlowExecutionException {
        FlowSession activeSession = context.getFlowExecutionContext().getActiveSession();
        if (activeSession.isRoot()) {
            ViewSelection selectedView = this.viewSelector.makeEntrySelection(context);
            context.endActiveFlowSession(this.createSessionOutput(context));
            return selectedView;
        }
        LocalAttributeMap sessionOutput = this.createSessionOutput(context);
        context.endActiveFlowSession(sessionOutput);
        return context.signalEvent(new Event(this, this.getId(), sessionOutput));
    }

    protected LocalAttributeMap createSessionOutput(RequestContext context) {
        LocalAttributeMap outputMap = new LocalAttributeMap();
        if (this.outputMapper != null) {
            this.outputMapper.map((Object)context, (Object)outputMap, null);
        }
        return outputMap;
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("viewSelector", (Object)this.viewSelector).append("outputMapper", (Object)this.outputMapper);
    }
}

