/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.support.ConversionServiceAwareConverter;
import org.springframework.binding.expression.Expression;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.NullViewSelector;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.support.ApplicationViewSelector;
import org.springframework.webflow.engine.support.ExternalRedirectSelector;
import org.springframework.webflow.engine.support.FlowDefinitionRedirectSelector;

public class TextToViewSelector
extends ConversionServiceAwareConverter {
    public static final String REDIRECT_PREFIX = "redirect:";
    public static final String EXTERNAL_REDIRECT_PREFIX = "externalRedirect:";
    public static final String FLOW_DEFINITION_REDIRECT_PREFIX = "flowRedirect:";
    private static final String BEAN_PREFIX = "bean:";
    private FlowServiceLocator flowServiceLocator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$springframework$webflow$engine$ViewSelector;
    static /* synthetic */ Class class$org$springframework$binding$expression$Expression;

    public TextToViewSelector(FlowServiceLocator flowServiceLocator) {
        this.flowServiceLocator = flowServiceLocator;
        this.setConversionService(flowServiceLocator.getConversionService());
    }

    public Class[] getSourceClasses() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextToViewSelector.class$("java.lang.String")) : class$java$lang$String};
    }

    public Class[] getTargetClasses() {
        return new Class[]{class$org$springframework$webflow$engine$ViewSelector == null ? (class$org$springframework$webflow$engine$ViewSelector = TextToViewSelector.class$("org.springframework.webflow.engine.ViewSelector")) : class$org$springframework$webflow$engine$ViewSelector};
    }

    protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
        String encodedView = (String)source;
        if (!StringUtils.hasText((String)encodedView)) {
            return NullViewSelector.INSTANCE;
        }
        return this.convertEncodedViewSelector(encodedView);
    }

    protected ViewSelector convertEncodedViewSelector(String encodedView) {
        if (encodedView.startsWith(REDIRECT_PREFIX)) {
            String viewName = encodedView.substring(REDIRECT_PREFIX.length());
            Expression viewNameExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)viewName);
            return new ApplicationViewSelector(viewNameExpr, true);
        }
        if (encodedView.startsWith(EXTERNAL_REDIRECT_PREFIX)) {
            String externalUrl = encodedView.substring(EXTERNAL_REDIRECT_PREFIX.length());
            Expression urlExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)externalUrl);
            return new ExternalRedirectSelector(urlExpr);
        }
        if (encodedView.startsWith(FLOW_DEFINITION_REDIRECT_PREFIX)) {
            String flowRedirect = encodedView.substring(FLOW_DEFINITION_REDIRECT_PREFIX.length());
            Expression redirectExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)flowRedirect);
            return new FlowDefinitionRedirectSelector(redirectExpr);
        }
        if (encodedView.startsWith(BEAN_PREFIX)) {
            String id = encodedView.substring(BEAN_PREFIX.length());
            return this.flowServiceLocator.getViewSelector(id);
        }
        Expression viewNameExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)encodedView);
        return new ApplicationViewSelector(viewNameExpr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

