/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;

public class FlowExecutionImplFactory
implements FlowExecutionFactory {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$impl$FlowExecutionImplFactory == null ? (class$org$springframework$webflow$engine$impl$FlowExecutionImplFactory = FlowExecutionImplFactory.class$("org.springframework.webflow.engine.impl.FlowExecutionImplFactory")) : class$org$springframework$webflow$engine$impl$FlowExecutionImplFactory));
    private FlowExecutionListenerLoader executionListenerLoader = StaticFlowExecutionListenerLoader.EMPTY_INSTANCE;
    private AttributeMap executionAttributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    static /* synthetic */ Class class$org$springframework$webflow$engine$impl$FlowExecutionImplFactory;
    static /* synthetic */ Class class$org$springframework$webflow$engine$Flow;

    public AttributeMap getExecutionAttributes() {
        return this.executionAttributes;
    }

    public void setExecutionAttributes(AttributeMap executionAttributes) {
        Assert.notNull((Object)executionAttributes, (String)"The execution attributes map is required");
        this.executionAttributes = executionAttributes;
    }

    public void setExecutionAttributesMap(Map executionAttributes) {
        Assert.notNull((Object)executionAttributes, (String)"The execution attributes map is required");
        this.executionAttributes = new LocalAttributeMap(executionAttributes);
    }

    public FlowExecutionListenerLoader getExecutionListenerLoader() {
        return this.executionListenerLoader;
    }

    public void setExecutionListenerLoader(FlowExecutionListenerLoader listenerLoader) {
        Assert.notNull((Object)listenerLoader, (String)"The listener loader is required");
        this.executionListenerLoader = listenerLoader;
    }

    public FlowExecution createFlowExecution(FlowDefinition flowDefinition) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$engine$Flow == null ? (class$org$springframework$webflow$engine$Flow = FlowExecutionImplFactory.class$("org.springframework.webflow.engine.Flow")) : class$org$springframework$webflow$engine$Flow), (Object)flowDefinition, (String)"Flow definition is of wrong type: ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating flow execution for flow definition with id '" + flowDefinition.getId() + "'"));
        }
        FlowExecutionListener[] listeners = this.executionListenerLoader.getListeners(flowDefinition);
        return new FlowExecutionImpl((Flow)flowDefinition, listeners, this.executionAttributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

