/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.io.Serializable;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;

public class ApplicationViewSelector
implements ViewSelector,
Serializable {
    public static final String ALWAYS_REDIRECT_ON_PAUSE_ATTRIBUTE = "alwaysRedirectOnPause";
    private Expression viewName;
    private boolean redirect;

    public ApplicationViewSelector(Expression viewName) {
        this(viewName, false);
    }

    public ApplicationViewSelector(Expression viewName, boolean redirect) {
        Assert.notNull((Object)viewName, (String)"The view name expression is required");
        this.viewName = viewName;
        this.redirect = redirect;
    }

    public Expression getViewName() {
        return this.viewName;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isEntrySelectionRenderable(RequestContext context) {
        return !this.shouldRedirect(context);
    }

    public ViewSelection makeEntrySelection(RequestContext context) {
        if (this.shouldRedirect(context)) {
            return FlowExecutionRedirect.INSTANCE;
        }
        return this.makeRefreshSelection(context);
    }

    public ViewSelection makeRefreshSelection(RequestContext context) {
        String viewName = this.resolveViewName(context);
        if (!StringUtils.hasText((String)viewName)) {
            throw new IllegalStateException("Resolved application view name was empty; programmer error! -- The expression that was evaluated against the request context was '" + this.getViewName() + "'");
        }
        return this.createApplicationView(viewName, context);
    }

    protected String resolveViewName(RequestContext context) {
        return (String)this.getViewName().evaluate((Object)context, null);
    }

    protected ApplicationView createApplicationView(String viewName, RequestContext context) {
        return new ApplicationView(viewName, context.getModel().asMap());
    }

    protected boolean shouldRedirect(RequestContext context) {
        return context.getCurrentState() instanceof ViewState && (this.redirect || this.alwaysRedirectOnPause(context));
    }

    protected boolean alwaysRedirectOnPause(RequestContext context) {
        String attributeValue = String.valueOf(context.getFlowExecutionContext().getAttributes().get(ALWAYS_REDIRECT_ON_PAUSE_ATTRIBUTE, "false"));
        return new Boolean(attributeValue);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("viewName", (Object)this.viewName).append("redirect", this.redirect).toString();
    }
}

