/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.execution.RequestContext;

public class DefaultTargetStateResolver
implements TargetStateResolver {
    private Expression targetStateIdExpression;

    public DefaultTargetStateResolver(String targetStateId) {
        this((Expression)new StaticExpression((Object)targetStateId));
    }

    public DefaultTargetStateResolver(Expression targetStateIdExpression) {
        Assert.notNull((Object)targetStateIdExpression, (String)"The target state id expression is required");
        this.targetStateIdExpression = targetStateIdExpression;
    }

    public State resolveTargetState(Transition transition, State sourceState, RequestContext context) {
        String stateId = String.valueOf(this.targetStateIdExpression.evaluate((Object)context, null));
        return ((Flow)context.getActiveFlow()).getStateInstance(stateId);
    }

    public String toString() {
        return this.targetStateIdExpression.toString();
    }
}

