/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;

public class TransitionExecutingStateExceptionHandler
implements FlowExecutionExceptionHandler {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$support$TransitionExecutingStateExceptionHandler == null ? (class$org$springframework$webflow$engine$support$TransitionExecutingStateExceptionHandler = TransitionExecutingStateExceptionHandler.class$("org.springframework.webflow.engine.support.TransitionExecutingStateExceptionHandler")) : class$org$springframework$webflow$engine$support$TransitionExecutingStateExceptionHandler));
    public static final String STATE_EXCEPTION_ATTRIBUTE = "stateException";
    public static final String ROOT_CAUSE_EXCEPTION_ATTRIBUTE = "rootCauseException";
    private Map exceptionTargetStateMappings = new HashMap();
    private ActionList actionList = new ActionList();
    static /* synthetic */ Class class$org$springframework$webflow$engine$support$TransitionExecutingStateExceptionHandler;
    static /* synthetic */ Class class$java$lang$Object;

    public TransitionExecutingStateExceptionHandler add(Class exceptionClass, String targetStateId) {
        return this.add(exceptionClass, new DefaultTargetStateResolver(targetStateId));
    }

    public TransitionExecutingStateExceptionHandler add(Class exceptionClass, TargetStateResolver targetStateResolver) {
        Assert.notNull((Object)exceptionClass, (String)"The exception class is required");
        Assert.notNull((Object)targetStateResolver, (String)"The target state resolver is required");
        this.exceptionTargetStateMappings.put(exceptionClass, targetStateResolver);
        return this;
    }

    public ActionList getActionList() {
        return this.actionList;
    }

    public boolean handles(FlowExecutionException e) {
        return this.getTargetStateResolver(e) != null;
    }

    public ViewSelection handle(FlowExecutionException exception, RequestControlContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Handling state exception " + (Object)((Object)exception)), (Throwable)((Object)exception));
        }
        this.exposeException(context, exception, this.findRootCause((Throwable)((Object)exception)));
        this.actionList.execute(context);
        return context.execute(new Transition(this.getTargetStateResolver(exception)));
    }

    protected void exposeException(RequestContext context, FlowExecutionException exception, Throwable rootCause) {
        context.getFlashScope().put(STATE_EXCEPTION_ATTRIBUTE, (Object)exception);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exposing state exception root cause " + rootCause + " under attribute '" + ROOT_CAUSE_EXCEPTION_ATTRIBUTE + "'"));
        }
        context.getFlashScope().put(ROOT_CAUSE_EXCEPTION_ATTRIBUTE, rootCause);
    }

    protected TargetStateResolver getTargetStateResolver(FlowExecutionException e) {
        if (JdkVersion.getMajorJavaVersion() == 0) {
            return this.getTargetStateResolver13(e);
        }
        return this.getTargetStateResolver14((Throwable)((Object)e));
    }

    private TargetStateResolver getTargetStateResolver13(NestedRuntimeException e) {
        if (this.isRootCause13(e)) {
            return this.findTargetStateResolver(e.getClass());
        }
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.exceptionTargetStateMappings.get(e.getClass());
        if (targetStateResolver != null) {
            return targetStateResolver;
        }
        if (e.getCause() instanceof NestedRuntimeException) {
            return this.getTargetStateResolver13((NestedRuntimeException)e.getCause());
        }
        return null;
    }

    private TargetStateResolver getTargetStateResolver14(Throwable t) {
        if (this.isRootCause14(t)) {
            return this.findTargetStateResolver(t.getClass());
        }
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.exceptionTargetStateMappings.get(t.getClass());
        if (targetStateResolver != null) {
            return targetStateResolver;
        }
        return this.getTargetStateResolver14(t.getCause());
    }

    private boolean isRootCause13(NestedRuntimeException e) {
        return e.getCause() == null;
    }

    private boolean isRootCause14(Throwable t) {
        return t.getCause() == null;
    }

    private TargetStateResolver findTargetStateResolver(Class exceptionType) {
        while (exceptionType != null && exceptionType != (class$java$lang$Object == null ? TransitionExecutingStateExceptionHandler.class$("java.lang.Object") : class$java$lang$Object)) {
            if (this.exceptionTargetStateMappings.containsKey(exceptionType)) {
                return (TargetStateResolver)this.exceptionTargetStateMappings.get(exceptionType);
            }
            exceptionType = exceptionType.getSuperclass();
        }
        return null;
    }

    protected Throwable findRootCause(Throwable t) {
        if (JdkVersion.getMajorJavaVersion() == 0) {
            return this.findRootCause13(t);
        }
        return this.findRootCause14(t);
    }

    private Throwable findRootCause13(Throwable t) {
        if (t instanceof NestedRuntimeException) {
            NestedRuntimeException nre = (NestedRuntimeException)t;
            Throwable cause = nre.getCause();
            if (cause == null) {
                return nre;
            }
            return this.findRootCause13(cause);
        }
        return t;
    }

    private Throwable findRootCause14(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        return this.findRootCause14(cause);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("exceptionTargetStateMappings", (Object)this.exceptionTargetStateMappings).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

