/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.struts;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.validation.Errors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;
import org.springframework.web.struts.SpringBindingActionForm;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.action.FormObjectAccessor;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.struts.StrutsExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.FlowRequestHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.ResponseInstructionHandler;

public class FlowAction
extends ActionSupport {
    protected static final String FLOW_EXECUTOR_BEAN_NAME = "flowExecutor";
    protected static final String FLOW_EXECUTOR_ARGUMENT_HANDLER_BEAN_NAME = "argumentHandler";
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentHandler argumentHandler;
    static /* synthetic */ Class class$org$springframework$webflow$executor$FlowExecutor;
    static /* synthetic */ Class class$org$springframework$webflow$executor$support$FlowExecutorArgumentHandler;

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    protected void onInit() {
        WebApplicationContext context = this.getWebApplicationContext();
        if (this.getFlowExecutor() == null) {
            if (context.containsBean(FLOW_EXECUTOR_BEAN_NAME)) {
                this.setFlowExecutor((FlowExecutor)context.getBean(FLOW_EXECUTOR_BEAN_NAME, class$org$springframework$webflow$executor$FlowExecutor == null ? (class$org$springframework$webflow$executor$FlowExecutor = FlowAction.class$("org.springframework.webflow.executor.FlowExecutor")) : class$org$springframework$webflow$executor$FlowExecutor));
            } else {
                throw new IllegalStateException("No 'flowExecutor' bean definition could be found; to use Spring Web Flow with Struts you must configure this FlowAction with a FlowExecutor");
            }
        }
        if (this.getArgumentHandler() == null) {
            if (context.containsBean(FLOW_EXECUTOR_ARGUMENT_HANDLER_BEAN_NAME)) {
                this.setArgumentHandler((FlowExecutorArgumentHandler)context.getBean(FLOW_EXECUTOR_ARGUMENT_HANDLER_BEAN_NAME, class$org$springframework$webflow$executor$support$FlowExecutorArgumentHandler == null ? (class$org$springframework$webflow$executor$support$FlowExecutorArgumentHandler = FlowAction.class$("org.springframework.webflow.executor.support.FlowExecutorArgumentHandler")) : class$org$springframework$webflow$executor$support$FlowExecutorArgumentHandler));
            } else {
                this.argumentHandler = new RequestParameterFlowExecutorArgumentHandler();
            }
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StrutsExternalContext context = new StrutsExternalContext(mapping, form, this.getServletContext(), request, response);
        ResponseInstruction responseInstruction = this.createRequestHandler().handleFlowRequest(context);
        return this.toActionForward(responseInstruction, mapping, form, request, response, context);
    }

    protected FlowRequestHandler createRequestHandler() {
        return new FlowRequestHandler(this.getFlowExecutor(), this.getArgumentHandler());
    }

    protected ActionForward toActionForward(final ResponseInstruction responseInstruction, final ActionMapping mapping, final ActionForm form, final HttpServletRequest request, final HttpServletResponse response, final ExternalContext context) throws Exception {
        return (ActionForward)new ResponseInstructionHandler(){

            protected void handleApplicationView(ApplicationView view) throws Exception {
                HashMap model = new HashMap(view.getModel());
                FlowAction.this.argumentHandler.exposeFlowExecutionContext(responseInstruction.getFlowExecutionKey(), responseInstruction.getFlowExecutionContext(), model);
                WebUtils.exposeRequestAttributes((ServletRequest)request, model);
                if (form instanceof SpringBindingActionForm) {
                    SpringBindingActionForm bindingForm = (SpringBindingActionForm)form;
                    Errors currentErrors = (Errors)model.get(FormObjectAccessor.getCurrentFormErrorsName());
                    bindingForm.expose(currentErrors, request);
                }
                this.setResult(FlowAction.this.findForward(view, mapping));
            }

            protected void handleFlowDefinitionRedirect(FlowDefinitionRedirect redirect) throws Exception {
                String flowUrl = FlowAction.this.argumentHandler.createFlowDefinitionUrl(redirect, context);
                this.setResult(FlowAction.this.createRedirectForward(flowUrl, response));
            }

            protected void handleFlowExecutionRedirect(FlowExecutionRedirect redirect) throws Exception {
                String flowExecutionUrl = FlowAction.this.argumentHandler.createFlowExecutionUrl(responseInstruction.getFlowExecutionKey(), responseInstruction.getFlowExecutionContext(), context);
                this.setResult(FlowAction.this.createRedirectForward(flowExecutionUrl, response));
            }

            protected void handleExternalRedirect(ExternalRedirect redirect) throws Exception {
                String externalUrl = FlowAction.this.argumentHandler.createExternalUrl(redirect, responseInstruction.getFlowExecutionKey(), context);
                this.setResult(FlowAction.this.createRedirectForward(externalUrl, response));
            }

            protected void handleNull() throws Exception {
                this.setResult(null);
            }
        }.handle(responseInstruction).getResult();
    }

    protected ActionForward createRedirectForward(String url, HttpServletResponse response) throws Exception {
        response.sendRedirect(response.encodeRedirectURL(url));
        return null;
    }

    protected ActionForward findForward(ApplicationView forward, ActionMapping mapping) {
        ActionForward actionForward = mapping.findForward(forward.getViewName());
        actionForward = actionForward != null ? new ActionForward(actionForward.getName(), actionForward.getPath(), false) : new ActionForward(forward.getViewName(), false);
        return actionForward;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

