/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.util.Enumeration;
import java.util.Properties;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractionException;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;

public class FlowIdMappingArgumentHandlerWrapper
extends FlowExecutorArgumentHandler {
    private Properties mappings = new Properties();
    private Properties reverseMappings = new Properties();
    private boolean fallback = true;
    private FlowExecutorArgumentHandler argumentHandler;

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    protected Properties getMappings() {
        return this.mappings;
    }

    public void setMappings(Properties mappings) {
        Enumeration<?> publicFlowIds = mappings.propertyNames();
        while (publicFlowIds.hasMoreElements()) {
            String publicId = (String)publicFlowIds.nextElement();
            String privateId = mappings.getProperty(publicId);
            this.addMapping(publicId, privateId);
        }
    }

    public void addMapping(String publicFlowId, String privateFlowId) {
        this.mappings.setProperty(publicFlowId, privateFlowId);
        this.reverseMappings.setProperty(privateFlowId, publicFlowId);
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    public boolean isFlowIdPresent(ExternalContext context) {
        if (this.argumentHandler.isFlowIdPresent(context)) {
            return this.fallback || this.mappings.containsKey(this.argumentHandler.extractFlowId(context));
        }
        return false;
    }

    public String extractFlowId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String publicFlowId = this.argumentHandler.extractFlowId(context);
        String flowId = this.mappings.getProperty(publicFlowId);
        if (!StringUtils.hasText((String)flowId)) {
            if (this.fallback) {
                flowId = publicFlowId;
            } else {
                throw new FlowExecutorArgumentExtractionException("Unable to extract flow definition id: no mapping was defined for '" + publicFlowId + "'");
            }
        }
        return flowId;
    }

    public boolean isFlowExecutionKeyPresent(ExternalContext context) {
        return this.argumentHandler.isFlowExecutionKeyPresent(context);
    }

    public String extractFlowExecutionKey(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        return this.argumentHandler.extractFlowExecutionKey(context);
    }

    public boolean isEventIdPresent(ExternalContext context) {
        return this.argumentHandler.isEventIdPresent(context);
    }

    public String extractEventId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        return this.argumentHandler.extractEventId(context);
    }

    public String createFlowDefinitionUrl(FlowDefinitionRedirect flowDefinitionRedirect, ExternalContext context) {
        String publicFlowId = this.reverseMappings.getProperty(flowDefinitionRedirect.getFlowDefinitionId());
        if (!StringUtils.hasText((String)publicFlowId)) {
            if (this.fallback) {
                publicFlowId = flowDefinitionRedirect.getFlowDefinitionId();
            } else {
                throw new IllegalArgumentException("Unable to create a flow definition URL for '" + flowDefinitionRedirect + "': no reverse mapping was defined for flow id '" + flowDefinitionRedirect.getFlowDefinitionId() + "'");
            }
        }
        flowDefinitionRedirect = new FlowDefinitionRedirect(publicFlowId, flowDefinitionRedirect.getExecutionInput());
        return this.argumentHandler.createFlowDefinitionUrl(flowDefinitionRedirect, context);
    }

    public String createFlowExecutionUrl(String flowExecutionKey, FlowExecutionContext flowExecution, ExternalContext context) {
        return this.argumentHandler.createFlowExecutionUrl(flowExecutionKey, flowExecution, context);
    }

    public String createExternalUrl(ExternalRedirect redirect, String flowExecutionKey, ExternalContext context) {
        return this.argumentHandler.createExternalUrl(redirect, flowExecutionKey, context);
    }
}

