/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service.captchastore;

import com.octo.captcha.Captcha;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaAndLocale;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;

public class JBossCacheCaptchaStore
implements CaptchaStore {
    public static final String JCAPTCHA_JBOSSCACHE_CONFIG = "jcaptcha.jbosscache.config";
    private static final String DEFAULT_CACHE_NAME = "/captcha";
    private Fqn cacheQualifiedName;
    private Cache cache;

    public JBossCacheCaptchaStore() {
        this(DEFAULT_CACHE_NAME);
    }

    public JBossCacheCaptchaStore(String cacheQualifiedName) {
        this.cacheQualifiedName = Fqn.fromString((String)cacheQualifiedName);
    }

    public boolean hasCaptcha(String s) {
        try {
            Object result = this.cache.get(this.cacheQualifiedName, (Object)s);
            return result != null;
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public void storeCaptcha(String s, Captcha captcha) throws CaptchaServiceException {
        try {
            this.cache.put(this.cacheQualifiedName, (Object)s, (Object)new CaptchaAndLocale(captcha));
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public void storeCaptcha(String s, Captcha captcha, Locale locale) throws CaptchaServiceException {
        try {
            this.cache.put(this.cacheQualifiedName, (Object)s, (Object)new CaptchaAndLocale(captcha, locale));
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public boolean removeCaptcha(String s) {
        try {
            Object captcha = this.cache.remove(this.cacheQualifiedName, (Object)s);
            return captcha != null;
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public Captcha getCaptcha(String s) throws CaptchaServiceException {
        try {
            Object result = this.cache.get(this.cacheQualifiedName, (Object)s);
            if (result != null) {
                CaptchaAndLocale captchaAndLocale = (CaptchaAndLocale)result;
                return captchaAndLocale.getCaptcha();
            }
            return null;
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public Locale getLocale(String s) throws CaptchaServiceException {
        try {
            Object result = this.cache.get(this.cacheQualifiedName, (Object)s);
            if (result != null) {
                CaptchaAndLocale captchaAndLocale = (CaptchaAndLocale)result;
                return captchaAndLocale.getLocale();
            }
            return null;
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public int getSize() {
        try {
            Node captchas;
            Node root = this.cache.getRoot();
            if (root != null && (captchas = root.getChild(this.cacheQualifiedName)) != null) {
                return captchas.dataSize();
            }
            return 0;
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public Collection getKeys() {
        try {
            Set keys;
            Node captchas;
            Node root = this.cache.getRoot();
            if (root != null && (captchas = root.getChild(this.cacheQualifiedName)) != null && (keys = captchas.getKeys()) != null) {
                return keys;
            }
            return Collections.EMPTY_SET;
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public void empty() {
        try {
            Node captchas;
            Node root = this.cache.getRoot();
            if (root != null && (captchas = root.getChild(this.cacheQualifiedName)) != null) {
                captchas.clearData();
            }
            this.cache.removeNode(this.cacheQualifiedName);
        }
        catch (CacheException e) {
            throw new CaptchaServiceException(e);
        }
    }

    public void initAndStart() {
        String configFileName = System.getProperty(JCAPTCHA_JBOSSCACHE_CONFIG);
        if (configFileName == null) {
            throw new RuntimeException("The system property jcaptcha.jbosscache.config have to be set");
        }
        CacheFactory factory = DefaultCacheFactory.getInstance();
        this.cache = factory.createCache(configFileName);
    }

    public void cleanAndShutdown() {
        this.cache.stop();
        this.cache.destroy();
    }
}

