/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeJob
implements Job {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PROP_COMMAND = "command";
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_WAIT_FOR_PROCESS = "waitForProcess";
    public static final String PROP_CONSUME_STREAMS = "consumeStreams";

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getMergedJobDataMap();
        String command = data.getString(PROP_COMMAND);
        String parameters = data.getString(PROP_PARAMETERS);
        if (parameters == null) {
            parameters = "";
        }
        boolean wait = true;
        if (data.containsKey(PROP_WAIT_FOR_PROCESS)) {
            wait = data.getBooleanValue(PROP_WAIT_FOR_PROCESS);
        }
        boolean consumeStreams = false;
        if (data.containsKey(PROP_CONSUME_STREAMS)) {
            consumeStreams = data.getBooleanValue(PROP_CONSUME_STREAMS);
        }
        Integer exitCode = this.runNativeCommand(command, parameters, wait, consumeStreams);
        context.setResult(exitCode);
    }

    protected Logger getLog() {
        return this.log;
    }

    private Integer runNativeCommand(String command, String parameters, boolean wait, boolean consumeStreams) throws JobExecutionException {
        String[] args = new String[2];
        Integer result = null;
        args[0] = command;
        args[1] = parameters;
        try {
            String[] cmd;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                cmd = new String[args.length + 2];
                cmd[0] = osName.equals("Windows 95") ? "command.com" : "cmd.exe";
                cmd[1] = "/C";
                System.arraycopy(args, 0, cmd, 2, args.length);
            } else {
                cmd = osName.equals("Linux") ? new String[]{"/bin/sh", "-c", args[0] + " " + args[1]} : args;
            }
            Runtime rt = Runtime.getRuntime();
            this.getLog().info("About to run " + cmd[0] + " " + cmd[1] + " " + (cmd.length > 2 ? cmd[2] : "") + " ...");
            Process proc = rt.exec(cmd);
            StreamConsumer stdoutConsumer = new StreamConsumer(proc.getInputStream(), "stdout");
            if (consumeStreams) {
                StreamConsumer stderrConsumer = new StreamConsumer(proc.getErrorStream(), "stderr");
                stdoutConsumer.start();
                stderrConsumer.start();
            }
            if (wait) {
                result = proc.waitFor();
            }
        }
        catch (Throwable x) {
            throw new JobExecutionException("Error launching native command: ", x, false);
        }
        return result;
    }

    class StreamConsumer
    extends Thread {
        InputStream is;
        String type;

        public StreamConsumer(InputStream inputStream, String type) {
            this.is = inputStream;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(this.is));
                while ((line = br.readLine()) != null) {
                    if (this.type.equalsIgnoreCase("stderr")) {
                        NativeJob.this.getLog().warn(this.type + ">" + line);
                        continue;
                    }
                    NativeJob.this.getLog().info(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                NativeJob.this.getLog().error("Error consuming " + this.type + " stream of spawned process.", (Throwable)ioe);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

