/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CVarcharAccessor
extends VarcharAccessor {
    T4CMAREngine mare;
    static final int t4MaxLength = 4000;
    static final int t4CallMaxLength = 4001;
    static final int t4PlsqlMaxLength = 32766;
    static final int t4SqlMinLength = 32;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    static final int NONE = -1;
    static final int DAY = 1;
    static final int MM_MONTH = 2;
    static final int FULL_MONTH = 3;
    static final int MON_MONTH = 4;
    static final int YY_YEAR = 5;
    static final int RR_YEAR = 6;
    static final int HH_HOUR = 7;
    static final int HH24_HOUR = 8;
    static final int MINUTE = 9;
    static final int SECOND = 10;
    static final int NSECOND = 11;
    static final int AM = 12;
    static final int TZR = 13;
    static final int TZH = 14;
    static final int TZM = 15;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:34_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CVarcharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
        this.calculateSizeTmpByteArray();
    }

    T4CVarcharAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, int n10, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n9;
        this.definedColumnSize = n10;
        this.calculateSizeTmpByteArray();
        this.oacmxl = n8;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        int n2;
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n3 = this.indicatorIndex + this.lastRowProcessed;
        int n4 = this.lengthIndex + this.lastRowProcessed;
        byte[] byArray = this.statement.tmpByteArray;
        int n5 = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (!this.underlyingLong) {
            if (this.rowSpaceIndicator == null) {
                byte[] byArray2 = new byte[16000];
                this.mare.unmarshalCLR(byArray2, 0, this.meta);
                this.processIndicator(this.meta[0]);
                ++this.lastRowProcessed;
                return false;
            }
            if (this.isNullByDescribe) {
                this.rowSpaceIndicator[n3] = -1;
                this.rowSpaceIndicator[n4] = 0;
                ++this.lastRowProcessed;
                if (this.mare.versionNumber < 9200) {
                    this.processIndicator(0);
                }
                return false;
            }
            if (this.statement.maxFieldSize > 0) {
                this.mare.unmarshalCLR(byArray, 0, this.meta, this.statement.maxFieldSize);
            } else {
                this.mare.unmarshalCLR(byArray, 0, this.meta);
            }
        } else {
            this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
            if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
                this.meta[0] = 0;
                this.mare.processIndicator(false, 0);
                n2 = this.mare.unmarshalUB2();
            } else {
                n2 = 0;
                int n6 = 0;
                byte[] byArray3 = byArray;
                int n7 = 0;
                this.readHeaderArr[0] = true;
                this.readAsNonStreamArr[0] = false;
                while (n2 != -1) {
                    if (byArray3 == byArray && n6 + 255 > byArray.length) {
                        byArray3 = new byte[255];
                    }
                    if ((n2 = T4CLongAccessor.readStreamFromWire(byArray3, n7 = byArray3 == byArray ? n6 : 0, 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer)) == -1) continue;
                    if (byArray3 == byArray) {
                        n6 += n2;
                        continue;
                    }
                    if (byArray.length - n6 <= 0) continue;
                    int n8 = byArray.length - n6;
                    System.arraycopy(byArray3, 0, byArray, n6, n8);
                    n6 += n8;
                }
                if (byArray3 != byArray) {
                    byArray3 = null;
                }
                this.meta[0] = n6;
            }
        }
        this.tmp[0] = this.meta[0];
        n2 = 0;
        n2 = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n5 + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n5 + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[n5] = (char)(n2 * 2);
        if (!this.underlyingLong) {
            this.processIndicator(this.meta[0]);
        }
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n3] = -1;
            this.rowSpaceIndicator[n4] = 0;
        } else {
            this.rowSpaceIndicator[n4] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[n3] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch : this.lastRowProcessed;
        int n3 = this.columnIndex + this.lastRowProcessed * this.charLength;
        int n4 = this.columnIndex + (n2 - 1) * this.charLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2 - 1;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2 - 1;
        short s2 = this.rowSpaceIndicator[n8];
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        System.arraycopy(this.rowSpaceChar, n4, this.rowSpaceChar, n3, this.rowSpaceChar[n4] / 2 + 1);
        ++this.lastRowProcessed;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.charLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.charLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(cArray, n5, this.rowSpaceChar, n4, cArray[n5] / 2 + 1);
        }
    }

    @Override
    void calculateSizeTmpByteArray() {
        int n2 = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < n2) {
            this.statement.sizeTmpByteArray = n2;
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        NUMBER nUMBER = null;
        if (this.definedColumnType == 0) {
            nUMBER = super.getNUMBER(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                return T4CVarcharAccessor.StringToNUMBER(string);
            }
        }
        return nUMBER;
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        if (this.definedColumnType == 0) {
            dATE = super.getDATE(n2);
        } else {
            Date date = this.getDate(n2);
            if (date != null) {
                dATE = new DATE(date);
            }
        }
        return dATE;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.definedColumnType == 0) {
            tIMESTAMP = super.getTIMESTAMP(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMP = new TIMESTAMP(timestamp);
            }
        }
        return tIMESTAMP;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPTZ = super.getTIMESTAMPTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPTZ;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPLTZ = super.getTIMESTAMPLTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPLTZ;
    }

    @Override
    RAW getRAW(int n2) throws SQLException {
        RAW rAW = null;
        if (this.definedColumnType == 0) {
            rAW = super.getRAW(n2);
        } else {
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
                rAW = new RAW(super.getBytes(n2));
            }
        }
        return rAW;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(n2);
        }
        Datum datum = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(n2);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(n2);
                }
                case 91: {
                    return this.getDATE(n2);
                }
                case 92: {
                    return this.getDATE(n2);
                }
                case 93: {
                    return this.getTIMESTAMP(n2);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(n2);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(n2);
                }
                case -8: {
                    return this.getROWID(n2);
                }
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        }
        return datum;
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getBytes(n2);
        }
        Datum datum = this.getOracleObject(n2);
        return datum.shareBytes();
    }

    @Override
    boolean getBoolean(int n2) throws SQLException {
        boolean bl = false;
        bl = this.definedColumnType == 0 ? super.getBoolean(n2) : this.getNUMBER(n2).booleanValue();
        return bl;
    }

    @Override
    byte getByte(int n2) throws SQLException {
        byte by = 0;
        by = this.definedColumnType == 0 ? super.getByte(n2) : this.getNUMBER(n2).byteValue();
        return by;
    }

    @Override
    int getInt(int n2) throws SQLException {
        int n3 = 0;
        n3 = this.definedColumnType == 0 ? super.getInt(n2) : this.getNUMBER(n2).intValue();
        return n3;
    }

    @Override
    short getShort(int n2) throws SQLException {
        short s2 = 0;
        s2 = this.definedColumnType == 0 ? super.getShort(n2) : this.getNUMBER(n2).shortValue();
        return s2;
    }

    @Override
    long getLong(int n2) throws SQLException {
        long l2 = 0L;
        l2 = this.definedColumnType == 0 ? super.getLong(n2) : this.getNUMBER(n2).longValue();
        return l2;
    }

    @Override
    float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        f2 = this.definedColumnType == 0 ? super.getFloat(n2) : this.getNUMBER(n2).floatValue();
        return f2;
    }

    @Override
    double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        d2 = this.definedColumnType == 0 ? super.getDouble(n2) : this.getNUMBER(n2).doubleValue();
        return d2;
    }

    @Override
    Date getDate(int n2) throws SQLException {
        Date date = null;
        if (this.definedColumnType == 0) {
            date = super.getDate(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                date = new Date(T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nArray).getTimeInMillis());
            }
        }
        return date;
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.definedColumnType == 0) {
            timestamp = super.getTimestamp(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
            }
        }
        return timestamp;
    }

    @Override
    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.definedColumnType == 0) {
            time = super.getTime(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                time = new Time(calendar.getTimeInMillis());
            }
        }
        return time;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n2);
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(n2);
                }
                case 4: {
                    return new Integer(this.getInt(n2));
                }
                case -6: {
                    return new Byte(this.getByte(n2));
                }
                case 5: {
                    return new Short(this.getShort(n2));
                }
                case -7: 
                case 16: {
                    return new Boolean(this.getBoolean(n2));
                }
                case -5: {
                    return new Long(this.getLong(n2));
                }
                case 7: {
                    return new Float(this.getFloat(n2));
                }
                case 6: 
                case 8: {
                    return new Double(this.getDouble(n2));
                }
                case 91: {
                    return this.getDate(n2);
                }
                case 92: {
                    return this.getTime(n2);
                }
                case 93: {
                    return this.getTimestamp(n2);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(n2);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytesInternal(n2);
                }
                case -8: {
                    return this.getROWID(n2);
                }
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
            return null;
        }
        return var2_2;
    }

    @Override
    ROWID getROWID(int n2) throws SQLException {
        byte[] byArray = this.getBytesInternal(n2);
        ROWID rOWID = null;
        if (byArray != null) {
            rOWID = new ROWID(byArray);
        }
        return rOWID;
    }

    static final NUMBER StringToNUMBER(String string) throws SQLException {
        return new NUMBER(new BigDecimal(string));
    }

    static final Calendar DATEStringToCalendar(String string, String string2, int[] nArray) throws SQLException {
        char[] cArray = (string2 + " ").toCharArray();
        string = string + " ";
        int n2 = Math.min(string.length(), cArray.length);
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String[] stringArray = null;
        String[] stringArray2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            switch (cArray[i2]) {
                case 'R': 
                case 'r': {
                    if (n3 == 6) break;
                    n3 = 6;
                    n5 = i2;
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (n3 == 5) break;
                    n3 = 5;
                    n5 = i2;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (n3 == 1) break;
                    n3 = 1;
                    n5 = i2;
                    break;
                }
                case 'M': 
                case 'm': {
                    if (n3 == 2 && n3 == 4 && n3 == 3 && n3 == 9) break;
                    n5 = i2;
                    if (!(i2 + 4 >= n2 || cArray[i2 + 1] != 'O' && cArray[i2 + 1] != 'o' || cArray[i2 + 2] != 'N' && cArray[i2 + 2] != 'n' || cArray[i2 + 3] != 'T' && cArray[i2 + 3] != 't' || cArray[i2 + 4] != 'H' && cArray[i2 + 4] != 'h')) {
                        n3 = 3;
                        i2 += 4;
                        break;
                    }
                    if (!(i2 + 2 >= n2 || cArray[i2 + 1] != 'O' && cArray[i2 + 1] != 'o' || cArray[i2 + 2] != 'N' && cArray[i2 + 2] != 'n')) {
                        n3 = 4;
                        i2 += 2;
                        break;
                    }
                    if (i2 + 1 < n2 && (cArray[i2 + 1] == 'M' || cArray[i2 + 1] == 'm')) {
                        n3 = 2;
                        ++i2;
                        break;
                    }
                    if (i2 + 1 >= n2 || cArray[i2 + 1] != 'I' && cArray[i2 + 1] != 'i') break;
                    n3 = 9;
                    ++i2;
                    break;
                }
                case 'H': 
                case 'h': {
                    if (n3 != 7) {
                        n3 = 7;
                        n5 = i2;
                        break;
                    }
                    if (i2 + 2 >= n2 || cArray[i2 + 1] != '2' && cArray[i2 + 4] != '4') break;
                    n3 = 8;
                    i2 += 2;
                    break;
                }
                case 'S': 
                case 's': {
                    if (i2 + 1 >= n2 || cArray[i2 + 1] != 'S' && cArray[i2 + 1] != 's') break;
                    n3 = 10;
                    n5 = i2++;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (n3 == 11) break;
                    n3 = 11;
                    n5 = i2;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (i2 + 1 >= n2 || cArray[i2 + 1] != 'M' && cArray[i2 + 1] != 'm') break;
                    n3 = 12;
                    n5 = i2++;
                    break;
                }
                case 'T': 
                case 't': {
                    if (i2 + 2 >= n2 || cArray[i2 + 1] != 'Z' && cArray[i2 + 1] != 'z' || cArray[i2 + 2] != 'R' && cArray[i2 + 2] != 'r') break;
                    n3 = 13;
                    n5 = i2;
                    i2 += 2;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl || n3 == -1) continue;
            int n16 = i2 - n5;
            int n17 = n5 - n6;
            n7 = n8 + n17;
            n8 = n7 + n16;
            switch (n3) {
                case 1: {
                    n9 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 2: {
                    n10 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 3: {
                    int n18 = n7;
                    n8 = n7;
                    for (n18 = n7; n18 < string.length() && string.charAt(n18) != cArray[i2]; ++n18) {
                    }
                    n8 = n18;
                    String string5 = null;
                    if (n8 == n7) break;
                    string5 = string.substring(n7, n8);
                    string5 = string5.trim();
                    if (stringArray2 == null) {
                        stringArray2 = new DateFormatSymbols().getMonths();
                    }
                    for (n10 = 0; n10 < stringArray2.length && !string5.equalsIgnoreCase(stringArray2[n10]); ++n10) {
                    }
                    if (n10 < 12) break;
                    DatabaseError.throwSqlException(null, 59);
                    break;
                }
                case 4: {
                    int n19 = n7;
                    n8 = n7;
                    for (n19 = n7; n19 < string.length() && string.charAt(n19) != cArray[i2]; ++n19) {
                    }
                    n8 = n19;
                    String string6 = null;
                    if (n8 == n7) break;
                    string6 = string.substring(n7, n8);
                    string6 = string6.trim();
                    if (stringArray == null) {
                        stringArray = new DateFormatSymbols().getShortMonths();
                    }
                    for (n10 = 0; n10 < stringArray.length && !string6.equalsIgnoreCase(stringArray[n10]); ++n10) {
                    }
                    if (n10 < 12) break;
                    DatabaseError.throwSqlException(null, 59);
                    break;
                }
                case 5: {
                    n11 = Integer.parseInt(string.substring(n7, n8));
                    if (n16 != 2) break;
                    n11 += 2000;
                    break;
                }
                case 6: {
                    n11 = Integer.parseInt(string.substring(n7, n8));
                    if (n16 == 2 && n11 < 50) {
                        n11 += 2000;
                        break;
                    }
                    n11 += 1900;
                    break;
                }
                case 7: 
                case 8: {
                    n8 = n7 + 2;
                    n12 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 9: {
                    n13 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 10: {
                    n14 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 11: {
                    int n19;
                    int n20 = n7;
                    n8 = n7;
                    for (n20 = n7; n20 < string.length(); ++n20) {
                        char c2 = string.charAt(n20);
                        n19 = c2;
                        if (c2 < '0' || n19 > 57) break;
                    }
                    if ((n8 += n20 - n7) == n7) break;
                    n15 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 12: {
                    if (n8 <= 0) break;
                    string3 = string.substring(n7, n8);
                    break;
                }
                case 13: {
                    int n19;
                    int n21 = n7;
                    n8 = n7;
                    n21 = n7;
                    while (n21 < string.length()) {
                        char c3 = string.charAt(n21);
                        n19 = c3;
                        if (!(c3 >= '0' && n19 <= 57 || n19 >= 97 && n19 <= 122 || n19 >= 65 && n19 <= 90)) break;
                        n8 = n21++;
                    }
                    if (n8 == n7) break;
                    string4 = string.substring(n7, n8);
                    break;
                }
                default: {
                    System.out.println("\n\n\n             ***** ERROR(1) ****\n");
                }
            }
            n6 = i2;
            n3 = -1;
            bl = false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n11, n10, n9, n12, n13, n14);
        if (string3 != null) {
            gregorianCalendar.set(9, string3.equalsIgnoreCase("AM") ? 0 : 1);
        }
        if (string4 != null) {
            // empty if block
        }
        return gregorianCalendar;
    }
}

