/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.Datum;

public class OracleTypeBINARY_FLOAT
extends OracleType
implements Serializable {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:10_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleTypeBINARY_FLOAT() {
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        BINARY_FLOAT bINARY_FLOAT = null;
        if (object != null) {
            if (object instanceof BINARY_FLOAT) {
                bINARY_FLOAT = (BINARY_FLOAT)object;
            } else if (object instanceof Float) {
                bINARY_FLOAT = new BINARY_FLOAT((Float)object);
            } else if (object instanceof byte[]) {
                bINARY_FLOAT = new BINARY_FLOAT((byte[])object);
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
            }
        }
        return bINARY_FLOAT;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null && object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
            datumArray = new Datum[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2 = objectArray[(int)l2 + i2 - 1];
                if (object2 != null) {
                    if (object2 instanceof Float) {
                        datumArray[i2] = new BINARY_FLOAT(((Float)object2).floatValue());
                        continue;
                    }
                    if (object2 instanceof BINARY_FLOAT) {
                        datumArray[i2] = (BINARY_FLOAT)object2;
                        continue;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    continue;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return 100;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1) {
            return new BINARY_FLOAT(byArray);
        }
        if (n2 == 2) {
            return new BINARY_FLOAT(byArray).toJdbc();
        }
        if (n2 == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        return null;
    }
}

