/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.util.Properties;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpNTAdapter;

public class ConnOption {
    public NTAdapter nt;
    public int port;
    public int tdu;
    public int sdu;
    public String protocol;
    public String host;
    public String sid;
    public String addr;
    public String service_name;
    public String instance_name;
    public StringBuffer conn_data = new StringBuffer();
    public String sslServerCertDN;
    public String origSSLServerCertDN;
    public String origServiceName;
    public String origSid;
    public boolean done;

    private NTAdapter getNT(Properties properties) throws NetException {
        block5: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block5;
                }
                if (this.protocol.equalsIgnoreCase("tcps")) {
                    Class<?> clazz = Class.forName("oracle.net.nt.TcpsNTAdapter");
                    Class[] classArray = new Class[]{String.class, Properties.class};
                    Object[] objectArray = new Object[]{this.addr, properties};
                    this.nt = (NTAdapter)clazz.getConstructor(classArray).newInstance(objectArray);
                    this.origSSLServerCertDN = this.sslServerCertDN;
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
                    this.nt.setOption(8, stringArray);
                    break block5;
                }
                throw new NetException(21);
            }
            catch (NLException nLException) {
                throw new NetException(501);
            }
            catch (Exception exception) {
                throw new NetException(21);
            }
        }
        return this.nt;
    }

    public void connect(Properties properties) throws IOException {
        try {
            this.populateProtocol();
            if (this.protocol == null) {
                throw new NetException(501);
            }
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        this.nt = this.getNT(properties);
        this.nt.connect();
    }

    private void populateProtocol() throws NLException {
        NVPair nVPair = null;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = new NVFactory().createNVPair(this.addr);
        nVPair = nVNavigator.findNVPair(nVPair2, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        this.protocol = nVPair.getAtom();
    }

    public void restoreFromOrigCoption(ConnOption connOption) throws IOException {
        this.origSSLServerCertDN = connOption.origSSLServerCertDN;
        this.origServiceName = connOption.origServiceName;
        this.origSid = connOption.origSid;
        this.conn_data = connOption.conn_data;
        if (this.protocol.equalsIgnoreCase("tcps")) {
            String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
            this.nt.setOption(8, stringArray);
        }
    }
}

