---
title: 综合案例
order: 6
---

## 云安全

在分析网络安全数据时，设备、事件、位置、IP、签名等之间的连接是发现异常、威胁和漏洞的关键。理解这些联系的最好方法就是把它们形象化。今天，在许多大型组织、金融机构和安全咨询服务中都有网络或 IT 的安全要求。这些组织需要保护自己免受如 zero-day 漏洞，DDoS 或网络钓鱼攻击之类漏洞的侵害。他们从服务器、路由器或应用程序日志和网络状态中收集数据，来检测可疑活动。图可视化可以一目了然地展示这些数据并检测可疑模式。通过对连接状态的可视化探索，可以更快速定位漏洞或攻击。 <br /> 详细案例请参考[《图可视化解决方案：云安全》](https://gw.alipayobjects.com/os/bmw-prod/660e1732-ff10-4f00-8594-a08d5a2d11d8.pdf)。

## 知识图谱

知识图谱（Knowledge Graph）是一种用图模型来描述知识和建模世界万物之间的关联关系的技术方法。知识图谱将信息中的知识或者数据加以关联，实现人类知识的描述及推理计算，并最终实现像人类一样对事物进行理解与解释，推动了从弱人工智能到强人工智能的发展。知识图谱由节点和边组成。节点可以是实体（如一个人、一个支付设备、一个企业等），也或是抽象的概念-本体类型（如人工智能、事物等）。边可以是本体类型之间的关系，也可以实体与实体之间的关系，如投资关系、支付关系等。图可视化可以更加清晰直观地描述这种结构化的关系，利于看清，是知识图谱领域的做图表示、图分析推理等重要基石。 <br /> 详细案例请参考[《图可视化解决方案：知识图谱》](https://gw.alipayobjects.com/os/bmw-prod/b6686d7a-2860-43a4-a75e-880490d5a414.pdf)。

## 企业风控

随着互联网发展和数字化的进程，企业数据在规模上几何增长，越来越多的企业面临信用、合规、声誉、第三方等诸多风险，企业风险控制的需求甚至也扩大到了政府、专业机构等各类细分领域。如何结合各个细分领域、业务场景，利用数据可视化技术，帮助企业更清晰发现和识别风险，从而将数据变成实际可用的风控产品和服务，这是当下企业风控需要解决的一个问题。 <br /> 详细案例请参考[《图可视化解决方案：企业风控》](https://gw.alipayobjects.com/os/bmw-prod/0b872268-1388-457f-9358-c41327a861e1.pdf)。

## 图数据库

图数据库领域是最近几年大数据领域热度颇高的领域，从 DB Engines 的排名来看，自 2013 年开始，图数据库的发展就一骑绝尘。与传统关系型数据库不同，图数据技术主要关注数据间关系查询能力，是表示和查询关联关系的最佳方式。借助于图数据库技术:

- 可以快速从百亿级电商网络中匹配出刷单团伙；
- 可以快速构建出人与人的社交关系，分析特定用户的人际关系、关注度、转发量等；
- 把 IP、域名、主机等一些列实体构建成图，可以快速发现诸如木马网络的不安全因素，辅以图分析能力能够很容易对不安全因素进行追根溯源。 <br /> 详细案例请参考[《图可视化解决方案：图数据库》](https://gw.alipayobjects.com/os/bmw-prod/a381a006-85e8-4c55-83b3-278a02f83535.pdf)。
