/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitNotifyObject {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    protected final HashMap<Long, Boolean> waitingThreadTable = new HashMap(16);
    protected volatile boolean hasNotified = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunning(long interval) {
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            if (this.hasNotified) {
                this.hasNotified = false;
                this.onWaitEnd();
                return;
            }
            try {
                this.wait(interval);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
            }
            finally {
                this.hasNotified = false;
                this.onWaitEnd();
            }
        }
    }

    protected void onWaitEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupAll() {
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            boolean needNotify = false;
            for (Boolean value : this.waitingThreadTable.values()) {
                needNotify = needNotify || value == false;
                value = true;
            }
            if (needNotify) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allWaitForRunning(long interval) {
        long currentThreadId = Thread.currentThread().getId();
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            Boolean notified = this.waitingThreadTable.get(currentThreadId);
            if (notified != null && notified.booleanValue()) {
                this.waitingThreadTable.put(currentThreadId, false);
                this.onWaitEnd();
                return;
            }
            try {
                this.wait(interval);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
            }
            finally {
                this.waitingThreadTable.put(currentThreadId, false);
                this.onWaitEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromWaitingThreadTable() {
        long currentThreadId = Thread.currentThread().getId();
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            this.waitingThreadTable.remove(currentThreadId);
        }
    }
}

