/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv;

import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.common.protocol.header.filtersrv.RegisterFilterServerRequestHeader;
import org.apache.rocketmq.common.protocol.header.filtersrv.RegisterFilterServerResponseHeader;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class FilterServerOuterAPI {
    private final RemotingClient remotingClient = new NettyRemotingClient(new NettyClientConfig());

    public void start() {
        this.remotingClient.start();
    }

    public void shutdown() {
        this.remotingClient.shutdown();
    }

    public RegisterFilterServerResponseHeader registerFilterServerToBroker(String brokerAddr, String filterServerAddr) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RegisterFilterServerRequestHeader requestHeader = new RegisterFilterServerRequestHeader();
        requestHeader.setFilterServerAddr(filterServerAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)301, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(brokerAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                RegisterFilterServerResponseHeader responseHeader = (RegisterFilterServerResponseHeader)response.decodeCommandCustomHeader(RegisterFilterServerResponseHeader.class);
                return responseHeader;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }
}

