/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.filtersrv.FiltersrvConfig;
import org.apache.rocketmq.filtersrv.FiltersrvController;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.NettySystemConfig;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.srvutil.ShutdownHookThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersrvStartup {
    public static Logger log;

    public static void main(String[] args) {
        FiltersrvStartup.start(FiltersrvStartup.createController(args));
    }

    public static FiltersrvController start(FiltersrvController controller) {
        try {
            controller.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        String tip = "The Filter Server boot success, " + controller.localAddr();
        log.info(tip);
        System.out.printf("%s%n", tip);
        return controller;
    }

    public static FiltersrvController createController(String[] args) {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        if (null == System.getProperty("com.rocketmq.remoting.socket.sndbuf.size")) {
            NettySystemConfig.socketSndbufSize = 65535;
        }
        if (null == System.getProperty("com.rocketmq.remoting.socket.rcvbuf.size")) {
            NettySystemConfig.socketRcvbufSize = 1024;
        }
        try {
            String file;
            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
            CommandLine commandLine = ServerUtil.parseCmdLine((String)"mqfiltersrv", (String[])args, (Options)FiltersrvStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
            if (null == commandLine) {
                System.exit(-1);
                return null;
            }
            FiltersrvConfig filtersrvConfig = new FiltersrvConfig();
            NettyServerConfig nettyServerConfig = new NettyServerConfig();
            if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                Properties properties = new Properties();
                properties.load(in);
                MixAll.properties2Object((Properties)properties, (Object)filtersrvConfig);
                System.out.printf("load config properties file OK, %s%n", file);
                ((InputStream)in).close();
                String port = properties.getProperty("listenPort");
                if (port != null) {
                    filtersrvConfig.setConnectWhichBroker(String.format("127.0.0.1:%s", port));
                }
            }
            nettyServerConfig.setListenPort(0);
            nettyServerConfig.setServerAsyncSemaphoreValue(filtersrvConfig.getFsServerAsyncSemaphoreValue());
            nettyServerConfig.setServerCallbackExecutorThreads(filtersrvConfig.getFsServerCallbackExecutorThreads());
            nettyServerConfig.setServerWorkerThreads(filtersrvConfig.getFsServerWorkerThreads());
            if (commandLine.hasOption('p')) {
                MixAll.printObjectProperties(null, (Object)filtersrvConfig);
                MixAll.printObjectProperties(null, (Object)nettyServerConfig);
                System.exit(0);
            }
            MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)filtersrvConfig);
            if (null == filtersrvConfig.getRocketmqHome()) {
                System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation%n", "ROCKETMQ_HOME");
                System.exit(-2);
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(filtersrvConfig.getRocketmqHome() + "/conf/logback_filtersrv.xml");
            log = LoggerFactory.getLogger((String)"RocketmqFiltersrv");
            final FiltersrvController controller = new FiltersrvController(filtersrvConfig, nettyServerConfig);
            boolean initResult = controller.initialize();
            if (!initResult) {
                controller.shutdown();
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    controller.shutdown();
                    return null;
                }
            }));
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Filter server config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config item");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }
}

