/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv.filter;

import org.apache.rocketmq.common.utils.HttpTinyClient;
import org.apache.rocketmq.filtersrv.filter.FilterClassFetchMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFilterClassFetchMethod
implements FilterClassFetchMethod {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqFiltersrv");
    private final String url;

    public HttpFilterClassFetchMethod(String url) {
        this.url = url;
    }

    @Override
    public String fetch(String topic, String consumerGroup, String className) {
        String thisUrl = String.format("%s/%s.java", this.url, className);
        try {
            HttpTinyClient.HttpResult result = HttpTinyClient.httpGet((String)thisUrl, null, null, (String)"UTF-8", (long)5000L);
            if (200 == result.code) {
                return result.content;
            }
        }
        catch (Exception e) {
            log.error(String.format("call <%s> exception, Topic: %s Group: %s", thisUrl, topic, consumerGroup), (Throwable)e);
        }
        return null;
    }
}

