/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import com.alibaba.fastjson.annotation.JSONField;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.constant.PermName;

public class TopicConfig {
    private static final String SEPARATOR = " ";
    private static int defaultReadQueueNums = 1;
    private static int defaultWriteQueueNums = 1;
    @JSONField(serialize=false)
    private String topicName;
    @JSONField(serialize=false)
    private int readQueueNums = defaultReadQueueNums;
    @JSONField(serialize=false)
    private int writeQueueNums = defaultWriteQueueNums;
    @JSONField(serialize=false)
    private int perm = 6;
    @JSONField(serialize=false)
    private TopicFilterType topicFilterType = TopicFilterType.SINGLE_TAG;
    @JSONField(serialize=false)
    private int topicSysFlag = 0;
    @JSONField(serialize=false)
    private boolean order = false;

    public TopicConfig() {
    }

    public TopicConfig(String topicName) {
        this.topicName = topicName;
    }

    public TopicConfig(String topicName, int readQueueNums, int writeQueueNums, int perm) {
        this.topicName = topicName;
        this.readQueueNums = readQueueNums;
        this.writeQueueNums = writeQueueNums;
        this.perm = perm;
    }

    public String getN() {
        return this.topicName;
    }

    public void setN(String name) {
        this.topicName = name;
    }

    public Integer getR() {
        if (this.readQueueNums == defaultReadQueueNums) {
            return null;
        }
        return this.readQueueNums;
    }

    public Integer getW() {
        if (this.writeQueueNums == defaultWriteQueueNums) {
            return null;
        }
        return this.writeQueueNums;
    }

    public Integer getP() {
        if (this.perm == 6) {
            return null;
        }
        return this.perm;
    }

    public void setR(Integer rq) {
        this.readQueueNums = rq;
    }

    public void setW(Integer wq) {
        this.writeQueueNums = wq;
    }

    public void setP(Integer p) {
        this.perm = p;
    }

    public TopicFilterType getT() {
        return TopicFilterType.SINGLE_TAG == this.topicFilterType ? null : this.topicFilterType;
    }

    public Integer getF() {
        return this.topicSysFlag == 0 ? null : Integer.valueOf(this.topicSysFlag);
    }

    public Boolean getO() {
        return !this.order ? null : Boolean.valueOf(true);
    }

    public void setT(TopicFilterType t) {
        this.topicFilterType = t;
    }

    public void setF(int f) {
        this.topicSysFlag = f;
    }

    public void setO(boolean o) {
        this.order = o;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.topicName);
        sb.append(SEPARATOR);
        sb.append(this.readQueueNums);
        sb.append(SEPARATOR);
        sb.append(this.writeQueueNums);
        sb.append(SEPARATOR);
        sb.append(this.perm);
        sb.append(SEPARATOR);
        sb.append((Object)this.topicFilterType);
        return sb.toString();
    }

    public boolean decode(String in) {
        String[] strs = in.split(SEPARATOR);
        if (strs != null && strs.length == 5) {
            this.topicName = strs[0];
            this.readQueueNums = Integer.parseInt(strs[1]);
            this.writeQueueNums = Integer.parseInt(strs[2]);
            this.perm = Integer.parseInt(strs[3]);
            this.topicFilterType = TopicFilterType.valueOf(strs[4]);
            return true;
        }
        return false;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public int getReadQueueNums() {
        return this.readQueueNums;
    }

    public void setReadQueueNums(int readQueueNums) {
        this.readQueueNums = readQueueNums;
    }

    public int getWriteQueueNums() {
        return this.writeQueueNums;
    }

    public void setWriteQueueNums(int writeQueueNums) {
        this.writeQueueNums = writeQueueNums;
    }

    public int getPerm() {
        return this.perm;
    }

    public void setPerm(int perm) {
        this.perm = perm;
    }

    public TopicFilterType getTopicFilterType() {
        return this.topicFilterType;
    }

    public void setTopicFilterType(TopicFilterType topicFilterType) {
        this.topicFilterType = topicFilterType;
    }

    public int getTopicSysFlag() {
        return this.topicSysFlag;
    }

    public void setTopicSysFlag(int topicSysFlag) {
        this.topicSysFlag = topicSysFlag;
    }

    public boolean isOrder() {
        return this.order;
    }

    public void setOrder(boolean isOrder) {
        this.order = isOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicConfig that = (TopicConfig)o;
        if (this.readQueueNums != that.readQueueNums) {
            return false;
        }
        if (this.writeQueueNums != that.writeQueueNums) {
            return false;
        }
        if (this.perm != that.perm) {
            return false;
        }
        if (this.topicSysFlag != that.topicSysFlag) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (this.topicName != null ? !this.topicName.equals(that.topicName) : that.topicName != null) {
            return false;
        }
        return this.topicFilterType == that.topicFilterType;
    }

    public int hashCode() {
        int result = this.topicName != null ? this.topicName.hashCode() : 0;
        result = 31 * result + this.readQueueNums;
        result = 31 * result + this.writeQueueNums;
        result = 31 * result + this.perm;
        result = 31 * result + (this.topicFilterType != null ? this.topicFilterType.hashCode() : 0);
        result = 31 * result + this.topicSysFlag;
        result = 31 * result + (this.order ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TopicConfig [topicName=" + this.topicName + ", readQueueNums=" + this.readQueueNums + ", writeQueueNums=" + this.writeQueueNums + ", perm=" + PermName.perm2String(this.perm) + ", topicFilterType=" + (Object)((Object)this.topicFilterType) + ", topicSysFlag=" + this.topicSysFlag + ", order=" + this.order + "]";
    }
}

