/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.broker;

import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class UpdateBrokerConfigSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateBrokerConfig";
    }

    @Override
    public String commandDesc() {
        return "Update broker's config";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("b", "brokerAddr", true, "update which broker");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "clusterName", true, "update which cluster");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("k", "key", true, "config key");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("v", "value", true, "config value");
        opt.setRequired(true);
        options.addOption(opt);
        for (int i = 1; i < 9; ++i) {
            opt = new Option("k" + i, "key" + i, true, "config key" + i);
            opt.setRequired(false);
            options.addOption(opt);
            opt = new Option("v" + i, "value" + i, true, "config value" + i);
            opt.setRequired(false);
            options.addOption(opt);
        }
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook, 20000L);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            int index = 0;
            Properties properties = new Properties();
            while (true) {
                String optionValue;
                String optionKey = index == 0 ? "k" : "k" + index;
                String string = optionValue = index == 0 ? "v" : "v" + index;
                if (!commandLine.hasOption(optionKey)) break;
                String key = commandLine.getOptionValue(optionKey).trim();
                String value = commandLine.getOptionValue(optionValue).trim();
                properties.put(key, value);
                ++index;
            }
            System.out.printf("properties:%s\n", properties.toString());
            if (commandLine.hasOption('b')) {
                String brokerAddr = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                defaultMQAdminExt.updateBrokerConfig(brokerAddr, properties);
                System.out.printf("update broker config success, broker:%s, config:%s\n", brokerAddr, properties.toString());
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                for (String brokerAddr : masterSet) {
                    try {
                        defaultMQAdminExt.updateBrokerConfig(brokerAddr, properties);
                        System.out.printf("update broker config success, broker:%s, config:%s\n", brokerAddr, properties.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

