/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.consumer;

import io.openmessaging.KeyValue;
import io.openmessaging.ServiceLifecycle;
import io.openmessaging.rocketmq.config.ClientConfig;
import io.openmessaging.rocketmq.domain.ConsumeRequest;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.slf4j.Logger;

class LocalMessageCache
implements ServiceLifecycle {
    private final BlockingQueue<ConsumeRequest> consumeRequestCache;
    private final Map<String, ConsumeRequest> consumedRequest;
    private final ConcurrentHashMap<MessageQueue, Long> pullOffsetTable;
    private final DefaultMQPullConsumer rocketmqPullConsumer;
    private final ClientConfig clientConfig;
    private final ScheduledExecutorService cleanExpireMsgExecutors;
    private static final Logger log = ClientLogger.getLog();

    LocalMessageCache(DefaultMQPullConsumer rocketmqPullConsumer, ClientConfig clientConfig) {
        this.consumeRequestCache = new LinkedBlockingQueue<ConsumeRequest>(clientConfig.getRmqPullMessageCacheCapacity());
        this.consumedRequest = new ConcurrentHashMap<String, ConsumeRequest>();
        this.pullOffsetTable = new ConcurrentHashMap();
        this.rocketmqPullConsumer = rocketmqPullConsumer;
        this.clientConfig = clientConfig;
        this.cleanExpireMsgExecutors = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("OMS_CleanExpireMsgScheduledThread_"));
    }

    int nextPullBatchNums() {
        return Math.min(this.clientConfig.getRmqPullMessageBatchNums(), this.consumeRequestCache.remainingCapacity());
    }

    long nextPullOffset(MessageQueue remoteQueue) {
        if (!this.pullOffsetTable.containsKey(remoteQueue)) {
            try {
                this.pullOffsetTable.putIfAbsent(remoteQueue, this.rocketmqPullConsumer.fetchConsumeOffset(remoteQueue, false));
            }
            catch (MQClientException e) {
                log.error("A error occurred in fetch consume offset process.", (Throwable)e);
            }
        }
        return this.pullOffsetTable.get(remoteQueue);
    }

    void updatePullOffset(MessageQueue remoteQueue, long nextPullOffset) {
        this.pullOffsetTable.put(remoteQueue, nextPullOffset);
    }

    void submitConsumeRequest(ConsumeRequest consumeRequest) {
        try {
            this.consumeRequestCache.put(consumeRequest);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    MessageExt poll() {
        return this.poll(this.clientConfig.getOmsOperationTimeout());
    }

    MessageExt poll(KeyValue properties) {
        int currentPollTimeout = this.clientConfig.getOmsOperationTimeout();
        if (properties.containsKey("oms.operation.timeout")) {
            currentPollTimeout = properties.getInt("oms.operation.timeout");
        }
        return this.poll(currentPollTimeout);
    }

    private MessageExt poll(long timeout) {
        try {
            ConsumeRequest consumeRequest = this.consumeRequestCache.poll(timeout, TimeUnit.MILLISECONDS);
            if (consumeRequest != null) {
                MessageExt messageExt = consumeRequest.getMessageExt();
                consumeRequest.setStartConsumeTimeMillis(System.currentTimeMillis());
                MessageAccessor.setConsumeStartTimeStamp((Message)messageExt, (String)String.valueOf(consumeRequest.getStartConsumeTimeMillis()));
                this.consumedRequest.put(messageExt.getMsgId(), consumeRequest);
                return messageExt;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    void ack(String messageId) {
        ConsumeRequest consumeRequest = this.consumedRequest.remove(messageId);
        if (consumeRequest != null) {
            long offset = consumeRequest.getProcessQueue().removeMessage(Collections.singletonList(consumeRequest.getMessageExt()));
            try {
                this.rocketmqPullConsumer.updateConsumeOffset(consumeRequest.getMessageQueue(), offset);
            }
            catch (MQClientException e) {
                log.error("A error occurred in update consume offset process.", (Throwable)e);
            }
        }
    }

    void ack(MessageQueue messageQueue, ProcessQueue processQueue, MessageExt messageExt) {
        this.consumedRequest.remove(messageExt.getMsgId());
        long offset = processQueue.removeMessage(Collections.singletonList(messageExt));
        try {
            this.rocketmqPullConsumer.updateConsumeOffset(messageQueue, offset);
        }
        catch (MQClientException e) {
            log.error("A error occurred in update consume offset process.", (Throwable)e);
        }
    }

    public void startup() {
        this.cleanExpireMsgExecutors.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                LocalMessageCache.this.cleanExpireMsg();
            }
        }, this.clientConfig.getRmqMessageConsumeTimeout(), this.clientConfig.getRmqMessageConsumeTimeout(), TimeUnit.MINUTES);
    }

    public void shutdown() {
        ThreadUtils.shutdownGracefully((ExecutorService)this.cleanExpireMsgExecutors, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanExpireMsg() {
        block7: for (Map.Entry next : this.rocketmqPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getProcessQueueTable().entrySet()) {
            ProcessQueue pq = (ProcessQueue)next.getValue();
            MessageQueue mq = (MessageQueue)next.getKey();
            ReadWriteLock lockTreeMap = this.getLockInProcessQueue(pq);
            if (lockTreeMap == null) {
                log.error("Gets tree map lock in process queue error, may be has compatibility issue");
                return;
            }
            TreeMap msgTreeMap = pq.getMsgTreeMap();
            int loop = msgTreeMap.size();
            for (int i = 0; i < loop; ++i) {
                MessageExt msg = null;
                try {
                    lockTreeMap.readLock().lockInterruptibly();
                    try {
                        if (msgTreeMap.isEmpty()) continue block7;
                        msg = (MessageExt)msgTreeMap.firstEntry().getValue();
                        if (System.currentTimeMillis() - Long.parseLong(MessageAccessor.getConsumeStartTimeStamp((Message)msg)) <= (long)(this.clientConfig.getRmqMessageConsumeTimeout() * 60 * 1000)) continue block7;
                    }
                    finally {
                        lockTreeMap.readLock().unlock();
                        continue block7;
                    }
                }
                catch (InterruptedException e) {
                    log.error("Gets expired message exception", (Throwable)e);
                }
                try {
                    this.rocketmqPullConsumer.sendMessageBack(msg, 3);
                    log.info("Send expired msg back. topic={}, msgId={}, storeHost={}, queueId={}, queueOffset={}", new Object[]{msg.getTopic(), msg.getMsgId(), msg.getStoreHost(), msg.getQueueId(), msg.getQueueOffset()});
                    this.ack(mq, pq, msg);
                    continue;
                }
                catch (Exception e) {
                    log.error("Send back expired msg exception", (Throwable)e);
                }
            }
        }
    }

    private ReadWriteLock getLockInProcessQueue(ProcessQueue pq) {
        try {
            return (ReadWriteLock)FieldUtils.readDeclaredField((Object)pq, (String)"lockTreeMap", (boolean)true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

