/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.utils;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.MessageHeader;
import io.openmessaging.OMS;
import io.openmessaging.SendResult;
import io.openmessaging.rocketmq.domain.BytesMessageImpl;
import io.openmessaging.rocketmq.domain.SendResultImpl;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;

public class OMSUtil {
    public static String buildInstanceName() {
        return Integer.toString(UtilAll.getPid()) + "%OpenMessaging%" + System.nanoTime();
    }

    public static Message msgConvert(BytesMessage omsMessage) {
        Message rmqMessage = new Message();
        rmqMessage.setBody(omsMessage.getBody());
        KeyValue headers = omsMessage.headers();
        KeyValue properties = omsMessage.properties();
        if (headers.containsKey("Topic")) {
            rmqMessage.setTopic(headers.getString("Topic"));
            rmqMessage.putUserProperty("rmq.message.destination", "TOPIC");
        } else {
            rmqMessage.setTopic(headers.getString("Queue"));
            rmqMessage.putUserProperty("rmq.message.destination", "QUEUE");
        }
        for (String key : properties.keySet()) {
            MessageAccessor.putProperty((Message)rmqMessage, (String)key, (String)properties.getString(key));
        }
        for (String key : headers.keySet()) {
            MessageAccessor.putProperty((Message)rmqMessage, (String)key, (String)headers.getString(key));
        }
        return rmqMessage;
    }

    public static BytesMessage msgConvert(MessageExt rmqMsg) {
        BytesMessageImpl omsMsg = new BytesMessageImpl();
        omsMsg.setBody(rmqMsg.getBody());
        KeyValue headers = omsMsg.headers();
        KeyValue properties = omsMsg.properties();
        Set entries = rmqMsg.getProperties().entrySet();
        for (Map.Entry entry : entries) {
            if (OMSUtil.isOMSHeader((String)entry.getKey())) {
                headers.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            properties.put((String)entry.getKey(), (String)entry.getValue());
        }
        omsMsg.putHeaders("MessageId", rmqMsg.getMsgId());
        if (!rmqMsg.getProperties().containsKey("rmq.message.destination") || ((String)rmqMsg.getProperties().get("rmq.message.destination")).equals("TOPIC")) {
            omsMsg.putHeaders("Topic", rmqMsg.getTopic());
        } else {
            omsMsg.putHeaders("Queue", rmqMsg.getTopic());
        }
        omsMsg.putHeaders("SearchKey", rmqMsg.getKeys());
        omsMsg.putHeaders("BornHost", String.valueOf(rmqMsg.getBornHost()));
        omsMsg.putHeaders("BornTimestamp", rmqMsg.getBornTimestamp());
        omsMsg.putHeaders("StoreHost", String.valueOf(rmqMsg.getStoreHost()));
        omsMsg.putHeaders("StoreTimestamp", rmqMsg.getStoreTimestamp());
        return omsMsg;
    }

    public static boolean isOMSHeader(String value) {
        for (Field field : MessageHeader.class.getDeclaredFields()) {
            try {
                if (!field.get(MessageHeader.class).equals(value)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return false;
    }

    public static SendResult sendResultConvert(org.apache.rocketmq.client.producer.SendResult rmqResult) {
        assert (rmqResult.getSendStatus().equals((Object)SendStatus.SEND_OK));
        return new SendResultImpl(rmqResult.getMsgId(), OMS.newKeyValue());
    }

    public static KeyValue buildKeyValue(KeyValue ... keyValues) {
        KeyValue keyValue = OMS.newKeyValue();
        for (KeyValue properties : keyValues) {
            for (String key : properties.keySet()) {
                keyValue.put(key, properties.getString(key));
            }
        }
        return keyValue;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        return new Iterator<T>(){
            Iterator<T> iterator = new Iterator<T>(){

                @Override
                public synchronized boolean hasNext() {
                    return false;
                }

                @Override
                public synchronized T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public synchronized void remove() {
                }
            };

            @Override
            public synchronized boolean hasNext() {
                return this.iterator.hasNext() || iterable.iterator().hasNext();
            }

            @Override
            public synchronized T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public synchronized void remove() {
                this.iterator.remove();
            }
        };
    }
}

