/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.ManyPullRequest;
import org.apache.rocketmq.broker.longpolling.PullRequest;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestHoldService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final String TOPIC_QUEUEID_SEPARATOR = "@";
    private final BrokerController brokerController;
    private final SystemClock systemClock = new SystemClock();
    private ConcurrentMap<String, ManyPullRequest> pullRequestTable = new ConcurrentHashMap<String, ManyPullRequest>(1024);

    public PullRequestHoldService(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void suspendPullRequest(String topic, int queueId, PullRequest pullRequest) {
        ManyPullRequest prev;
        String key = this.buildKey(topic, queueId);
        ManyPullRequest mpr = (ManyPullRequest)this.pullRequestTable.get(key);
        if (null == mpr && (prev = this.pullRequestTable.putIfAbsent(key, mpr = new ManyPullRequest())) != null) {
            mpr = prev;
        }
        mpr.addPullRequest(pullRequest);
    }

    private String buildKey(String topic, int queueId) {
        StringBuilder sb = new StringBuilder();
        sb.append(topic);
        sb.append(TOPIC_QUEUEID_SEPARATOR);
        sb.append(queueId);
        return sb.toString();
    }

    public void run() {
        log.info("{} service started", (Object)this.getServiceName());
        while (!this.isStopped()) {
            try {
                if (this.brokerController.getBrokerConfig().isLongPollingEnable()) {
                    this.waitForRunning(5000L);
                } else {
                    this.waitForRunning(this.brokerController.getBrokerConfig().getShortPollingTimeMills());
                }
                long beginLockTimestamp = this.systemClock.now();
                this.checkHoldRequest();
                long costTime = this.systemClock.now() - beginLockTimestamp;
                if (costTime <= 5000L) continue;
                log.info("[NOTIFYME] check hold request cost {} ms.", (Object)costTime);
            }
            catch (Throwable e) {
                log.warn(this.getServiceName() + " service has exception. ", e);
            }
        }
        log.info("{} service end", (Object)this.getServiceName());
    }

    public String getServiceName() {
        return PullRequestHoldService.class.getSimpleName();
    }

    private void checkHoldRequest() {
        for (String key : this.pullRequestTable.keySet()) {
            String[] kArray = key.split(TOPIC_QUEUEID_SEPARATOR);
            if (2 != kArray.length) continue;
            String topic = kArray[0];
            int queueId = Integer.parseInt(kArray[1]);
            long offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
            try {
                this.notifyMessageArriving(topic, queueId, offset);
            }
            catch (Throwable e) {
                log.error("check hold request failed. topic={}, queueId={}", new Object[]{topic, queueId, e});
            }
        }
    }

    public void notifyMessageArriving(String topic, int queueId, long maxOffset) {
        this.notifyMessageArriving(topic, queueId, maxOffset, null, 0L, null, null);
    }

    public void notifyMessageArriving(String topic, int queueId, long maxOffset, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        List<PullRequest> requestList;
        String key = this.buildKey(topic, queueId);
        ManyPullRequest mpr = (ManyPullRequest)this.pullRequestTable.get(key);
        if (mpr != null && (requestList = mpr.cloneListAndClear()) != null) {
            ArrayList<PullRequest> replayList = new ArrayList<PullRequest>();
            Iterator<PullRequest> iterator = requestList.iterator();
            while (iterator.hasNext()) {
                long newestOffset = maxOffset;
                PullRequest request = iterator.next();
                if (newestOffset <= request.getPullFromThisOffset()) {
                    newestOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
                }
                if (newestOffset > request.getPullFromThisOffset()) {
                    boolean match = request.getMessageFilter().isMatchedByConsumeQueue(tagsCode, new ConsumeQueueExt.CqExtUnit(tagsCode, msgStoreTime, filterBitMap));
                    if (match && properties != null) {
                        match = request.getMessageFilter().isMatchedByCommitLog(null, properties);
                    }
                    if (match) {
                        try {
                            this.brokerController.getPullMessageProcessor().executeRequestWhenWakeup(request.getClientChannel(), request.getRequestCommand());
                        }
                        catch (Throwable e) {
                            log.error("execute request when wakeup failed.", e);
                        }
                        continue;
                    }
                }
                if (System.currentTimeMillis() >= request.getSuspendTimestamp() + request.getTimeoutMillis()) {
                    try {
                        this.brokerController.getPullMessageProcessor().executeRequestWhenWakeup(request.getClientChannel(), request.getRequestCommand());
                    }
                    catch (Throwable e) {
                        log.error("execute request when wakeup failed.", e);
                    }
                    continue;
                }
                replayList.add(request);
            }
            if (!replayList.isEmpty()) {
                mpr.addPullRequest(replayList);
            }
        }
    }
}

