/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.protocol.body.CheckClientRequestBody;
import org.apache.rocketmq.common.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.common.protocol.header.UnregisterClientResponseHeader;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.common.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.common.protocol.heartbeat.ProducerData;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.filter.FilterFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManageProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;

    public ClientManageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 34: {
                return this.heartBeat(ctx, request);
            }
            case 35: {
                return this.unregisterClient(ctx, request);
            }
            case 46: {
                return this.checkClientConfig(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand heartBeat(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        long start = System.currentTimeMillis();
        HeartbeatData heartbeatData = (HeartbeatData)HeartbeatData.decode((byte[])request.getBody(), HeartbeatData.class);
        ClientChannelInfo clientChannelInfo = new ClientChannelInfo(ctx.channel(), heartbeatData.getClientID(), request.getLanguage(), request.getVersion());
        long startProcess = System.currentTimeMillis();
        for (ConsumerData data : heartbeatData.getConsumerDataSet()) {
            boolean changed;
            boolean isNotifyConsumerIdsChangedEnable;
            boolean hasTopic = false;
            for (SubscriptionData subscriptionData : data.getSubscriptionDataSet()) {
                if (!this.brokerController.getTopicConfigManager().getTopicConfigTable().containsKey(subscriptionData.getTopic())) continue;
                hasTopic = true;
                break;
            }
            if (!hasTopic) continue;
            SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(data.getGroupName());
            boolean bl = isNotifyConsumerIdsChangedEnable = !MixAll.MQTT_MODE;
            if (null != subscriptionGroupConfig) {
                isNotifyConsumerIdsChangedEnable = subscriptionGroupConfig.isNotifyConsumerIdsChangedEnable();
                if (!MixAll.MQTT_MODE) {
                    int topicSysFlag = 0;
                    if (data.isUnitMode()) {
                        topicSysFlag = TopicSysFlag.buildSysFlag((boolean)false, (boolean)true);
                    }
                    String newTopic = MixAll.getRetryTopic((String)data.getGroupName());
                    this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, subscriptionGroupConfig.getRetryQueueNums(), 6, topicSysFlag);
                }
            }
            if (!(changed = this.brokerController.getConsumerManager().registerConsumer(data.getGroupName(), clientChannelInfo, data.getConsumeType(), data.getMessageModel(), data.getConsumeFromWhere(), data.getSubscriptionDataSet(), isNotifyConsumerIdsChangedEnable))) continue;
            log.info("registerConsumer info changed {} {}", (Object)data.toString(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        long elapse = System.currentTimeMillis() - start;
        if (elapse > 5000L) {
            log.info("long heartBeat process, CID={}, requestBody={}, decode={}ms, totalProcess={}", new Object[]{heartbeatData.getClientID(), request.getBody().length, startProcess - start, elapse});
        }
        for (ProducerData data : heartbeatData.getProducerDataSet()) {
            this.brokerController.getProducerManager().registerProducer(data.getGroupName(), clientChannelInfo);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand unregisterClient(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(UnregisterClientResponseHeader.class);
        UnregisterClientRequestHeader requestHeader = (UnregisterClientRequestHeader)request.decodeCommandCustomHeader(UnregisterClientRequestHeader.class);
        ClientChannelInfo clientChannelInfo = new ClientChannelInfo(ctx.channel(), requestHeader.getClientID(), request.getLanguage(), request.getVersion());
        String group = requestHeader.getProducerGroup();
        if (group != null) {
            this.brokerController.getProducerManager().unregisterProducer(group, clientChannelInfo);
        }
        if ((group = requestHeader.getConsumerGroup()) != null) {
            SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(group);
            boolean isNotifyConsumerIdsChangedEnable = true;
            if (null != subscriptionGroupConfig) {
                isNotifyConsumerIdsChangedEnable = subscriptionGroupConfig.isNotifyConsumerIdsChangedEnable();
            }
            this.brokerController.getConsumerManager().unregisterConsumer(group, clientChannelInfo, isNotifyConsumerIdsChangedEnable);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand checkClientConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CheckClientRequestBody requestBody = (CheckClientRequestBody)CheckClientRequestBody.decode((byte[])request.getBody(), CheckClientRequestBody.class);
        if (requestBody != null && requestBody.getSubscriptionData() != null) {
            SubscriptionData subscriptionData = requestBody.getSubscriptionData();
            if (ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                response.setCode(0);
                response.setRemark(null);
                return response;
            }
            if (!this.brokerController.getBrokerConfig().isEnablePropertyFilter()) {
                response.setCode(1);
                response.setRemark("The broker does not support consumer to filter message by " + subscriptionData.getExpressionType());
                return response;
            }
            try {
                FilterFactory.INSTANCE.get(subscriptionData.getExpressionType()).compile(subscriptionData.getSubString());
            }
            catch (Exception e) {
                log.warn("Client {}@{} filter message, but failed to compile expression! sub={}, error={}", new Object[]{requestBody.getClientId(), requestBody.getGroup(), requestBody.getSubscriptionData(), e.getMessage()});
                response.setCode(23);
                response.setRemark(e.getMessage());
                return response;
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }
}

