/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq;

import io.openmessaging.IterableConsumer;
import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.Producer;
import io.openmessaging.PullConsumer;
import io.openmessaging.PushConsumer;
import io.openmessaging.ResourceManager;
import io.openmessaging.SequenceProducer;
import io.openmessaging.ServiceEndPoint;
import io.openmessaging.exception.OMSNotSupportedException;
import io.openmessaging.observer.Observer;
import io.openmessaging.rocketmq.consumer.PullConsumerImpl;
import io.openmessaging.rocketmq.consumer.PushConsumerImpl;
import io.openmessaging.rocketmq.producer.ProducerImpl;
import io.openmessaging.rocketmq.producer.SequenceProducerImpl;
import io.openmessaging.rocketmq.utils.OMSUtil;

public class MessagingAccessPointImpl
implements MessagingAccessPoint {
    private final KeyValue accessPointProperties;

    public MessagingAccessPointImpl(KeyValue accessPointProperties) {
        this.accessPointProperties = accessPointProperties;
    }

    public KeyValue properties() {
        return this.accessPointProperties;
    }

    public Producer createProducer() {
        return new ProducerImpl(this.accessPointProperties);
    }

    public Producer createProducer(KeyValue properties) {
        return new ProducerImpl(OMSUtil.buildKeyValue(this.accessPointProperties, properties));
    }

    public SequenceProducer createSequenceProducer() {
        return new SequenceProducerImpl(this.accessPointProperties);
    }

    public SequenceProducer createSequenceProducer(KeyValue properties) {
        return new SequenceProducerImpl(OMSUtil.buildKeyValue(this.accessPointProperties, properties));
    }

    public PushConsumer createPushConsumer() {
        return new PushConsumerImpl(this.accessPointProperties);
    }

    public PushConsumer createPushConsumer(KeyValue properties) {
        return new PushConsumerImpl(OMSUtil.buildKeyValue(this.accessPointProperties, properties));
    }

    public PullConsumer createPullConsumer(String queueName) {
        return new PullConsumerImpl(queueName, this.accessPointProperties);
    }

    public PullConsumer createPullConsumer(String queueName, KeyValue properties) {
        return new PullConsumerImpl(queueName, OMSUtil.buildKeyValue(this.accessPointProperties, properties));
    }

    public IterableConsumer createIterableConsumer(String queueName) {
        throw new OMSNotSupportedException("-1", "IterableConsumer is not supported in current version");
    }

    public IterableConsumer createIterableConsumer(String queueName, KeyValue properties) {
        throw new OMSNotSupportedException("-1", "IterableConsumer is not supported in current version");
    }

    public ResourceManager getResourceManager() {
        throw new OMSNotSupportedException("-1", "ResourceManager is not supported in current version.");
    }

    public ServiceEndPoint createServiceEndPoint() {
        throw new OMSNotSupportedException("-1", "ServiceEndPoint is not supported in current version.");
    }

    public ServiceEndPoint createServiceEndPoint(KeyValue properties) {
        throw new OMSNotSupportedException("-1", "ServiceEndPoint is not supported in current version.");
    }

    public void addObserver(Observer observer) {
    }

    public void deleteObserver(Observer observer) {
    }

    public void startup() {
    }

    public void shutdown() {
    }
}

