/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rocketmq.common.MixAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private AtomicReference<String> lastConfig = new AtomicReference<Object>(null);
    private static ScheduledExecutorService scheduler;
    private long persistInterval = 30L;

    private static synchronized ScheduledExecutorService getScheduler() {
        if (scheduler == null) {
            scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "ConfigManagerPersist");
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return scheduler;
    }

    public ConfigManager() {
        if (MixAll.MQTT_MODE) {
            ConfigManager.getScheduler().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ConfigManager.this.doPersist();
                }
            }, this.persistInterval, this.persistInterval, TimeUnit.SECONDS);
        }
    }

    public abstract String encode();

    public boolean load() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName);
            if (null == jsonString || jsonString.length() == 0) {
                return this.loadBak();
            }
            this.decode(jsonString);
            log.info("load {} OK", (Object)fileName);
            return true;
        }
        catch (Exception e) {
            log.error("load [{}] failed, and try to load backup file", (Object)fileName, (Object)e);
            return this.loadBak();
        }
    }

    public abstract String configFilePath();

    private boolean loadBak() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName + ".bak");
            if (jsonString != null && jsonString.length() > 0) {
                this.decode(jsonString);
                log.info("load [{}] OK", (Object)fileName);
                return true;
            }
        }
        catch (Exception e) {
            log.error("load [{}] Failed", (Object)fileName, (Object)e);
            return false;
        }
        return true;
    }

    public abstract void decode(String var1);

    private synchronized void doPersist() {
        String jsonString = this.lastConfig.getAndSet(null);
        if (jsonString != null) {
            String fileName = this.configFilePath();
            try {
                MixAll.string2File(jsonString, fileName);
            }
            catch (IOException e) {
                log.error("persist file [{}] exception", (Object)fileName, (Object)e);
            }
        }
    }

    public synchronized void persist() {
        this.lastConfig.set(this.encode(true));
        if (!MixAll.MQTT_MODE) {
            this.doPersist();
        }
    }

    public abstract String encode(boolean var1);
}

