/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.protocol;

import org.apache.rocketmq.common.protocol.header.namesrv.RegisterBrokerRequestHeader;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQProtosHelper {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");

    public static boolean registerBrokerToNameServer(String nsaddr, String brokerAddr, long timeoutMillis) {
        RegisterBrokerRequestHeader requestHeader = new RegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)103, (CommandCustomHeader)requestHeader);
        try {
            RemotingCommand response = RemotingHelper.invokeSync((String)nsaddr, (RemotingCommand)request, (long)timeoutMillis);
            if (response != null) {
                return 0 == response.getCode();
            }
        }
        catch (Exception e) {
            log.error("Failed to register broker", (Throwable)e);
        }
        return false;
    }
}

