// Autogenerated by Thrift Compiler (0.9.2)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package CarreraConsumer

import (
	"bytes"
	"fmt"
	"go.intra.xiaojukeji.com/golang/thrift-lib/0.9.2"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = bytes.Equal

type ConsumerService interface {
	// Parameters:
	//  - Request
	Pull(request *PullRequest) (r *PullResponse, err error)
	// Parameters:
	//  - Result_
	Submit(result *ConsumeResult_) (r bool, err error)
	// Parameters:
	//  - Request
	GetConsumeStats(request *ConsumeStatsRequest) (r []*ConsumeStats, err error)
	// Parameters:
	//  - Request
	Fetch(request *FetchRequest) (r *FetchResponse, err error)
	// Parameters:
	//  - Result_
	Ack(result *AckResult_) (r bool, err error)
}

type ConsumerServiceClient struct {
	Transport       thrift.TTransport
	ProtocolFactory thrift.TProtocolFactory
	InputProtocol   thrift.TProtocol
	OutputProtocol  thrift.TProtocol
	SeqId           int32
}

func NewConsumerServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ConsumerServiceClient {
	return &ConsumerServiceClient{Transport: t,
		ProtocolFactory: f,
		InputProtocol:   f.GetProtocol(t),
		OutputProtocol:  f.GetProtocol(t),
		SeqId:           0,
	}
}

func NewConsumerServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ConsumerServiceClient {
	return &ConsumerServiceClient{Transport: t,
		ProtocolFactory: nil,
		InputProtocol:   iprot,
		OutputProtocol:  oprot,
		SeqId:           0,
	}
}

// Parameters:
//  - Request
func (p *ConsumerServiceClient) Pull(request *PullRequest) (r *PullResponse, err error) {
	if err = p.sendPull(request); err != nil {
		return
	}
	return p.recvPull()
}

func (p *ConsumerServiceClient) sendPull(request *PullRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("pull", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := PullArgs{
		Request: request,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ConsumerServiceClient) recvPull() (value *PullResponse, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error19 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error20 error
		error20, err = error19.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error20
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "pull failed: out of sequence response")
		return
	}
	result := PullResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.ErrorA1 != nil {
		err = result.ErrorA1
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Result_
func (p *ConsumerServiceClient) Submit(result *ConsumeResult_) (r bool, err error) {
	if err = p.sendSubmit(result); err != nil {
		return
	}
	return p.recvSubmit()
}

func (p *ConsumerServiceClient) sendSubmit(result *ConsumeResult_) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("submit", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := SubmitArgs{
		Result_: result,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ConsumerServiceClient) recvSubmit() (value bool, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error21 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error22 error
		error22, err = error21.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error22
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "submit failed: out of sequence response")
		return
	}
	result := SubmitResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.ErrorA1 != nil {
		err = result.ErrorA1
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Request
func (p *ConsumerServiceClient) GetConsumeStats(request *ConsumeStatsRequest) (r []*ConsumeStats, err error) {
	if err = p.sendGetConsumeStats(request); err != nil {
		return
	}
	return p.recvGetConsumeStats()
}

func (p *ConsumerServiceClient) sendGetConsumeStats(request *ConsumeStatsRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("getConsumeStats", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := GetConsumeStatsArgs{
		Request: request,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ConsumerServiceClient) recvGetConsumeStats() (value []*ConsumeStats, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error23 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error24 error
		error24, err = error23.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error24
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "getConsumeStats failed: out of sequence response")
		return
	}
	result := GetConsumeStatsResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.ErrorA1 != nil {
		err = result.ErrorA1
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Request
func (p *ConsumerServiceClient) Fetch(request *FetchRequest) (r *FetchResponse, err error) {
	if err = p.sendFetch(request); err != nil {
		return
	}
	return p.recvFetch()
}

func (p *ConsumerServiceClient) sendFetch(request *FetchRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetch", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := FetchArgs{
		Request: request,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ConsumerServiceClient) recvFetch() (value *FetchResponse, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error25 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error26 error
		error26, err = error25.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error26
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetch failed: out of sequence response")
		return
	}
	result := FetchResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Result_
func (p *ConsumerServiceClient) Ack(result *AckResult_) (r bool, err error) {
	if err = p.sendAck(result); err != nil {
		return
	}
	return p.recvAck()
}

func (p *ConsumerServiceClient) sendAck(result *AckResult_) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("ack", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := AckArgs{
		Result_: result,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ConsumerServiceClient) recvAck() (value bool, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error27 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error28 error
		error28, err = error27.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error28
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "ack failed: out of sequence response")
		return
	}
	result := AckResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	value = result.GetSuccess()
	return
}

type ConsumerServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      ConsumerService
}

func (p *ConsumerServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *ConsumerServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *ConsumerServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewConsumerServiceProcessor(handler ConsumerService) *ConsumerServiceProcessor {

	self29 := &ConsumerServiceProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self29.processorMap["pull"] = &consumerServiceProcessorPull{handler: handler}
	self29.processorMap["submit"] = &consumerServiceProcessorSubmit{handler: handler}
	self29.processorMap["getConsumeStats"] = &consumerServiceProcessorGetConsumeStats{handler: handler}
	self29.processorMap["fetch"] = &consumerServiceProcessorFetch{handler: handler}
	self29.processorMap["ack"] = &consumerServiceProcessorAck{handler: handler}
	return self29
}

func (p *ConsumerServiceProcessor) Process(iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x30 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x30.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush()
	return false, x30

}

type consumerServiceProcessorPull struct {
	handler ConsumerService
}

func (p *consumerServiceProcessorPull) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PullArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("pull", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := PullResult{}
	var retval *PullResponse
	var err2 error
	if retval, err2 = p.handler.Pull(args.Request); err2 != nil {
		switch v := err2.(type) {
		case *PullException:
			result.ErrorA1 = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing pull: "+err2.Error())
			oprot.WriteMessageBegin("pull", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("pull", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type consumerServiceProcessorSubmit struct {
	handler ConsumerService
}

func (p *consumerServiceProcessorSubmit) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := SubmitArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("submit", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := SubmitResult{}
	var retval bool
	var err2 error
	if retval, err2 = p.handler.Submit(args.Result_); err2 != nil {
		switch v := err2.(type) {
		case *PullException:
			result.ErrorA1 = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing submit: "+err2.Error())
			oprot.WriteMessageBegin("submit", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = &retval
	}
	if err2 = oprot.WriteMessageBegin("submit", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type consumerServiceProcessorGetConsumeStats struct {
	handler ConsumerService
}

func (p *consumerServiceProcessorGetConsumeStats) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := GetConsumeStatsArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("getConsumeStats", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := GetConsumeStatsResult{}
	var retval []*ConsumeStats
	var err2 error
	if retval, err2 = p.handler.GetConsumeStats(args.Request); err2 != nil {
		switch v := err2.(type) {
		case *PullException:
			result.ErrorA1 = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getConsumeStats: "+err2.Error())
			oprot.WriteMessageBegin("getConsumeStats", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("getConsumeStats", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type consumerServiceProcessorFetch struct {
	handler ConsumerService
}

func (p *consumerServiceProcessorFetch) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := FetchArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetch", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := FetchResult{}
	var retval *FetchResponse
	var err2 error
	if retval, err2 = p.handler.Fetch(args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetch: "+err2.Error())
		oprot.WriteMessageBegin("fetch", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetch", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type consumerServiceProcessorAck struct {
	handler ConsumerService
}

func (p *consumerServiceProcessorAck) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := AckArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ack", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := AckResult{}
	var retval bool
	var err2 error
	if retval, err2 = p.handler.Ack(args.Result_); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ack: "+err2.Error())
		oprot.WriteMessageBegin("ack", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return true, err2
	} else {
		result.Success = &retval
	}
	if err2 = oprot.WriteMessageBegin("ack", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

type PullArgs struct {
	Request *PullRequest `thrift:"request,1" json:"request"`
}

func NewPullArgs() *PullArgs {
	return &PullArgs{}
}

var PullArgs_Request_DEFAULT *PullRequest

func (p *PullArgs) GetRequest() *PullRequest {
	if !p.IsSetRequest() {
		return PullArgs_Request_DEFAULT
	}
	return p.Request
}
func (p *PullArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PullArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *PullArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Request = &PullRequest{}
	if err := p.Request.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Request, err)
	}
	return nil
}

func (p *PullArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("pull_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *PullArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:request: %s", p, err)
	}
	if err := p.Request.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Request, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:request: %s", p, err)
	}
	return err
}

func (p *PullArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PullArgs(%+v)", *p)
}

type PullResult struct {
	Success *PullResponse  `thrift:"success,0" json:"success"`
	ErrorA1 *PullException `thrift:"error,1" json:"error"`
}

func NewPullResult() *PullResult {
	return &PullResult{}
}

var PullResult_Success_DEFAULT *PullResponse

func (p *PullResult) GetSuccess() *PullResponse {
	if !p.IsSetSuccess() {
		return PullResult_Success_DEFAULT
	}
	return p.Success
}

var PullResult_ErrorA1_DEFAULT *PullException

func (p *PullResult) GetErrorA1() *PullException {
	if !p.IsSetErrorA1() {
		return PullResult_ErrorA1_DEFAULT
	}
	return p.ErrorA1
}
func (p *PullResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PullResult) IsSetErrorA1() bool {
	return p.ErrorA1 != nil
}

func (p *PullResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *PullResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &PullResponse{}
	if err := p.Success.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Success, err)
	}
	return nil
}

func (p *PullResult) ReadField1(iprot thrift.TProtocol) error {
	p.ErrorA1 = &PullException{}
	if err := p.ErrorA1.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.ErrorA1, err)
	}
	return nil
}

func (p *PullResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("pull_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *PullResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.Success, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *PullResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErrorA1() {
		if err := oprot.WriteFieldBegin("error", thrift.STRUCT, 1); err != nil {
			return fmt.Errorf("%T write field begin error 1:error: %s", p, err)
		}
		if err := p.ErrorA1.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.ErrorA1, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 1:error: %s", p, err)
		}
	}
	return err
}

func (p *PullResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PullResult(%+v)", *p)
}

type SubmitArgs struct {
	Result_ *ConsumeResult_ `thrift:"result,1" json:"result"`
}

func NewSubmitArgs() *SubmitArgs {
	return &SubmitArgs{}
}

var SubmitArgs_Result__DEFAULT *ConsumeResult_

func (p *SubmitArgs) GetResult_() *ConsumeResult_ {
	if !p.IsSetResult_() {
		return SubmitArgs_Result__DEFAULT
	}
	return p.Result_
}
func (p *SubmitArgs) IsSetResult_() bool {
	return p.Result_ != nil
}

func (p *SubmitArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SubmitArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Result_ = &ConsumeResult_{}
	if err := p.Result_.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Result_, err)
	}
	return nil
}

func (p *SubmitArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("submit_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SubmitArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("result", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:result: %s", p, err)
	}
	if err := p.Result_.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Result_, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:result: %s", p, err)
	}
	return err
}

func (p *SubmitArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SubmitArgs(%+v)", *p)
}

type SubmitResult struct {
	Success *bool          `thrift:"success,0" json:"success"`
	ErrorA1 *PullException `thrift:"error,1" json:"error"`
}

func NewSubmitResult() *SubmitResult {
	return &SubmitResult{}
}

var SubmitResult_Success_DEFAULT bool

func (p *SubmitResult) GetSuccess() bool {
	if !p.IsSetSuccess() {
		return SubmitResult_Success_DEFAULT
	}
	return *p.Success
}

var SubmitResult_ErrorA1_DEFAULT *PullException

func (p *SubmitResult) GetErrorA1() *PullException {
	if !p.IsSetErrorA1() {
		return SubmitResult_ErrorA1_DEFAULT
	}
	return p.ErrorA1
}
func (p *SubmitResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *SubmitResult) IsSetErrorA1() bool {
	return p.ErrorA1 != nil
}

func (p *SubmitResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SubmitResult) ReadField0(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return fmt.Errorf("error reading field 0: %s", err)
	} else {
		p.Success = &v
	}
	return nil
}

func (p *SubmitResult) ReadField1(iprot thrift.TProtocol) error {
	p.ErrorA1 = &PullException{}
	if err := p.ErrorA1.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.ErrorA1, err)
	}
	return nil
}

func (p *SubmitResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("submit_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SubmitResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.BOOL, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := oprot.WriteBool(bool(*p.Success)); err != nil {
			return fmt.Errorf("%T.success (0) field write error: %s", p, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *SubmitResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErrorA1() {
		if err := oprot.WriteFieldBegin("error", thrift.STRUCT, 1); err != nil {
			return fmt.Errorf("%T write field begin error 1:error: %s", p, err)
		}
		if err := p.ErrorA1.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.ErrorA1, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 1:error: %s", p, err)
		}
	}
	return err
}

func (p *SubmitResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SubmitResult(%+v)", *p)
}

type GetConsumeStatsArgs struct {
	Request *ConsumeStatsRequest `thrift:"request,1" json:"request"`
}

func NewGetConsumeStatsArgs() *GetConsumeStatsArgs {
	return &GetConsumeStatsArgs{}
}

var GetConsumeStatsArgs_Request_DEFAULT *ConsumeStatsRequest

func (p *GetConsumeStatsArgs) GetRequest() *ConsumeStatsRequest {
	if !p.IsSetRequest() {
		return GetConsumeStatsArgs_Request_DEFAULT
	}
	return p.Request
}
func (p *GetConsumeStatsArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *GetConsumeStatsArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *GetConsumeStatsArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Request = &ConsumeStatsRequest{}
	if err := p.Request.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Request, err)
	}
	return nil
}

func (p *GetConsumeStatsArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getConsumeStats_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *GetConsumeStatsArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:request: %s", p, err)
	}
	if err := p.Request.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Request, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:request: %s", p, err)
	}
	return err
}

func (p *GetConsumeStatsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetConsumeStatsArgs(%+v)", *p)
}

type GetConsumeStatsResult struct {
	Success []*ConsumeStats `thrift:"success,0" json:"success"`
	ErrorA1 *PullException  `thrift:"error,1" json:"error"`
}

func NewGetConsumeStatsResult() *GetConsumeStatsResult {
	return &GetConsumeStatsResult{}
}

var GetConsumeStatsResult_Success_DEFAULT []*ConsumeStats

func (p *GetConsumeStatsResult) GetSuccess() []*ConsumeStats {
	return p.Success
}

var GetConsumeStatsResult_ErrorA1_DEFAULT *PullException

func (p *GetConsumeStatsResult) GetErrorA1() *PullException {
	if !p.IsSetErrorA1() {
		return GetConsumeStatsResult_ErrorA1_DEFAULT
	}
	return p.ErrorA1
}
func (p *GetConsumeStatsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *GetConsumeStatsResult) IsSetErrorA1() bool {
	return p.ErrorA1 != nil
}

func (p *GetConsumeStatsResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *GetConsumeStatsResult) ReadField0(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return fmt.Errorf("error reading list begin: %s", err)
	}
	tSlice := make([]*ConsumeStats, 0, size)
	p.Success = tSlice
	for i := 0; i < size; i++ {
		_elem31 := &ConsumeStats{}
		if err := _elem31.Read(iprot); err != nil {
			return fmt.Errorf("%T error reading struct: %s", _elem31, err)
		}
		p.Success = append(p.Success, _elem31)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return fmt.Errorf("error reading list end: %s", err)
	}
	return nil
}

func (p *GetConsumeStatsResult) ReadField1(iprot thrift.TProtocol) error {
	p.ErrorA1 = &PullException{}
	if err := p.ErrorA1.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.ErrorA1, err)
	}
	return nil
}

func (p *GetConsumeStatsResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getConsumeStats_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *GetConsumeStatsResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.LIST, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Success)); err != nil {
			return fmt.Errorf("error writing list begin: %s", err)
		}
		for _, v := range p.Success {
			if err := v.Write(oprot); err != nil {
				return fmt.Errorf("%T error writing struct: %s", v, err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return fmt.Errorf("error writing list end: %s", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *GetConsumeStatsResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErrorA1() {
		if err := oprot.WriteFieldBegin("error", thrift.STRUCT, 1); err != nil {
			return fmt.Errorf("%T write field begin error 1:error: %s", p, err)
		}
		if err := p.ErrorA1.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.ErrorA1, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 1:error: %s", p, err)
		}
	}
	return err
}

func (p *GetConsumeStatsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetConsumeStatsResult(%+v)", *p)
}

type FetchArgs struct {
	Request *FetchRequest `thrift:"request,1" json:"request"`
}

func NewFetchArgs() *FetchArgs {
	return &FetchArgs{}
}

var FetchArgs_Request_DEFAULT *FetchRequest

func (p *FetchArgs) GetRequest() *FetchRequest {
	if !p.IsSetRequest() {
		return FetchArgs_Request_DEFAULT
	}
	return p.Request
}
func (p *FetchArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *FetchArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *FetchArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Request = &FetchRequest{}
	if err := p.Request.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Request, err)
	}
	return nil
}

func (p *FetchArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetch_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *FetchArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:request: %s", p, err)
	}
	if err := p.Request.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Request, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:request: %s", p, err)
	}
	return err
}

func (p *FetchArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchArgs(%+v)", *p)
}

type FetchResult struct {
	Success *FetchResponse `thrift:"success,0" json:"success"`
}

func NewFetchResult() *FetchResult {
	return &FetchResult{}
}

var FetchResult_Success_DEFAULT *FetchResponse

func (p *FetchResult) GetSuccess() *FetchResponse {
	if !p.IsSetSuccess() {
		return FetchResult_Success_DEFAULT
	}
	return p.Success
}
func (p *FetchResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *FetchResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *FetchResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchResponse{}
	if err := p.Success.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Success, err)
	}
	return nil
}

func (p *FetchResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetch_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *FetchResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.Success, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *FetchResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchResult(%+v)", *p)
}

type AckArgs struct {
	Result_ *AckResult_ `thrift:"result,1" json:"result"`
}

func NewAckArgs() *AckArgs {
	return &AckArgs{}
}

var AckArgs_Result__DEFAULT *AckResult_

func (p *AckArgs) GetResult_() *AckResult_ {
	if !p.IsSetResult_() {
		return AckArgs_Result__DEFAULT
	}
	return p.Result_
}
func (p *AckArgs) IsSetResult_() bool {
	return p.Result_ != nil
}

func (p *AckArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *AckArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Result_ = &AckResult_{}
	if err := p.Result_.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Result_, err)
	}
	return nil
}

func (p *AckArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("ack_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *AckArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("result", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:result: %s", p, err)
	}
	if err := p.Result_.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Result_, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:result: %s", p, err)
	}
	return err
}

func (p *AckArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AckArgs(%+v)", *p)
}

type AckResult struct {
	Success *bool `thrift:"success,0" json:"success"`
}

func NewAckResult() *AckResult {
	return &AckResult{}
}

var AckResult_Success_DEFAULT bool

func (p *AckResult) GetSuccess() bool {
	if !p.IsSetSuccess() {
		return AckResult_Success_DEFAULT
	}
	return *p.Success
}
func (p *AckResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *AckResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *AckResult) ReadField0(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return fmt.Errorf("error reading field 0: %s", err)
	} else {
		p.Success = &v
	}
	return nil
}

func (p *AckResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("ack_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *AckResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.BOOL, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := oprot.WriteBool(bool(*p.Success)); err != nil {
			return fmt.Errorf("%T.success (0) field write error: %s", p, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *AckResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AckResult(%+v)", *p)
}
