// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "ProducerService.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using boost::shared_ptr;

using namespace  ::CarreraProducer;

class ProducerServiceHandler : virtual public ProducerServiceIf {
 public:
  ProducerServiceHandler() {
    // Your initialization goes here
  }

  void sendSync(Result& _return, const Message& message, const int64_t timeout) {
    // Your implementation goes here
    printf("sendSync\n");
  }

  void sendBatchSync(Result& _return, const std::vector<Message> & messages) {
    // Your implementation goes here
    printf("sendBatchSync\n");
  }

  void sendAsync(Result& _return, const Message& message) {
    // Your implementation goes here
    printf("sendAsync\n");
  }

  void sendDelaySync(DelayResult& _return, const DelayMessage& delayMessage, const int64_t timeout) {
    // Your implementation goes here
    printf("sendDelaySync\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  shared_ptr<ProducerServiceHandler> handler(new ProducerServiceHandler());
  shared_ptr<TProcessor> processor(new ProducerServiceProcessor(handler));
  shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

