// Autogenerated by Thrift Compiler (0.9.2)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package CarreraProducer

import (
	"bytes"
	"fmt"
	"go.intra.xiaojukeji.com/golang/thrift-lib/0.9.2"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = bytes.Equal

type ProducerService interface {
	// Parameters:
	//  - Message
	//  - Timeout
	SendSync(message *Message, timeout int64) (r *Result, err error)
	// Parameters:
	//  - Messages
	SendBatchSync(messages []*Message) (r *Result, err error)
	// Parameters:
	//  - Message
	SendAsync(message *Message) (r *Result, err error)
	// Parameters:
	//  - DelayMessage
	//  - Timeout
	SendDelaySync(delayMessage *DelayMessage, timeout int64) (r *DelayResult, err error)
}

type ProducerServiceClient struct {
	Transport       thrift.TTransport
	ProtocolFactory thrift.TProtocolFactory
	InputProtocol   thrift.TProtocol
	OutputProtocol  thrift.TProtocol
	SeqId           int32
}

func NewProducerServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ProducerServiceClient {
	return &ProducerServiceClient{Transport: t,
		ProtocolFactory: f,
		InputProtocol:   f.GetProtocol(t),
		OutputProtocol:  f.GetProtocol(t),
		SeqId:           0,
	}
}

func NewProducerServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ProducerServiceClient {
	return &ProducerServiceClient{Transport: t,
		ProtocolFactory: nil,
		InputProtocol:   iprot,
		OutputProtocol:  oprot,
		SeqId:           0,
	}
}

// Parameters:
//  - Message
//  - Timeout
func (p *ProducerServiceClient) SendSync(message *Message, timeout int64) (r *Result, err error) {
	if err = p.sendSendSync(message, timeout); err != nil {
		return
	}
	return p.recvSendSync()
}

func (p *ProducerServiceClient) sendSendSync(message *Message, timeout int64) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("sendSync", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := SendSyncArgs{
		Message: message,
		Timeout: timeout,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ProducerServiceClient) recvSendSync() (value *Result, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error10 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error11 error
		error11, err = error10.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error11
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "sendSync failed: out of sequence response")
		return
	}
	result := SendSyncResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Messages
func (p *ProducerServiceClient) SendBatchSync(messages []*Message) (r *Result, err error) {
	if err = p.sendSendBatchSync(messages); err != nil {
		return
	}
	return p.recvSendBatchSync()
}

func (p *ProducerServiceClient) sendSendBatchSync(messages []*Message) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("sendBatchSync", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := SendBatchSyncArgs{
		Messages: messages,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ProducerServiceClient) recvSendBatchSync() (value *Result, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error12 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error13 error
		error13, err = error12.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error13
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "sendBatchSync failed: out of sequence response")
		return
	}
	result := SendBatchSyncResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Message
func (p *ProducerServiceClient) SendAsync(message *Message) (r *Result, err error) {
	if err = p.sendSendAsync(message); err != nil {
		return
	}
	return p.recvSendAsync()
}

func (p *ProducerServiceClient) sendSendAsync(message *Message) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("sendAsync", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := SendAsyncArgs{
		Message: message,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ProducerServiceClient) recvSendAsync() (value *Result, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error14 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error15 error
		error15, err = error14.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error15
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "sendAsync failed: out of sequence response")
		return
	}
	result := SendAsyncResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - DelayMessage
//  - Timeout
func (p *ProducerServiceClient) SendDelaySync(delayMessage *DelayMessage, timeout int64) (r *DelayResult, err error) {
	if err = p.sendSendDelaySync(delayMessage, timeout); err != nil {
		return
	}
	return p.recvSendDelaySync()
}

func (p *ProducerServiceClient) sendSendDelaySync(delayMessage *DelayMessage, timeout int64) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("sendDelaySync", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := SendDelaySyncArgs{
		DelayMessage: delayMessage,
		Timeout:      timeout,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ProducerServiceClient) recvSendDelaySync() (value *DelayResult, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	_, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error16 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error17 error
		error17, err = error16.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error17
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "sendDelaySync failed: out of sequence response")
		return
	}
	result := SendDelaySyncResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	value = result.GetSuccess()
	return
}

type ProducerServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      ProducerService
}

func (p *ProducerServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *ProducerServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *ProducerServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewProducerServiceProcessor(handler ProducerService) *ProducerServiceProcessor {

	self18 := &ProducerServiceProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self18.processorMap["sendSync"] = &producerServiceProcessorSendSync{handler: handler}
	self18.processorMap["sendBatchSync"] = &producerServiceProcessorSendBatchSync{handler: handler}
	self18.processorMap["sendAsync"] = &producerServiceProcessorSendAsync{handler: handler}
	self18.processorMap["sendDelaySync"] = &producerServiceProcessorSendDelaySync{handler: handler}
	return self18
}

func (p *ProducerServiceProcessor) Process(iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x19 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x19.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush()
	return false, x19

}

type producerServiceProcessorSendSync struct {
	handler ProducerService
}

func (p *producerServiceProcessorSendSync) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := SendSyncArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("sendSync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := SendSyncResult{}
	var retval *Result
	var err2 error
	if retval, err2 = p.handler.SendSync(args.Message, args.Timeout); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendSync: "+err2.Error())
		oprot.WriteMessageBegin("sendSync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("sendSync", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type producerServiceProcessorSendBatchSync struct {
	handler ProducerService
}

func (p *producerServiceProcessorSendBatchSync) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := SendBatchSyncArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("sendBatchSync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := SendBatchSyncResult{}
	var retval *Result
	var err2 error
	if retval, err2 = p.handler.SendBatchSync(args.Messages); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendBatchSync: "+err2.Error())
		oprot.WriteMessageBegin("sendBatchSync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("sendBatchSync", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type producerServiceProcessorSendAsync struct {
	handler ProducerService
}

func (p *producerServiceProcessorSendAsync) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := SendAsyncArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("sendAsync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := SendAsyncResult{}
	var retval *Result
	var err2 error
	if retval, err2 = p.handler.SendAsync(args.Message); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendAsync: "+err2.Error())
		oprot.WriteMessageBegin("sendAsync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("sendAsync", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type producerServiceProcessorSendDelaySync struct {
	handler ProducerService
}

func (p *producerServiceProcessorSendDelaySync) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := SendDelaySyncArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("sendDelaySync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := SendDelaySyncResult{}
	var retval *DelayResult
	var err2 error
	if retval, err2 = p.handler.SendDelaySync(args.DelayMessage, args.Timeout); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendDelaySync: "+err2.Error())
		oprot.WriteMessageBegin("sendDelaySync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("sendDelaySync", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

type SendSyncArgs struct {
	Message *Message `thrift:"message,1" json:"message"`
	Timeout int64    `thrift:"timeout,2" json:"timeout"`
}

func NewSendSyncArgs() *SendSyncArgs {
	return &SendSyncArgs{}
}

var SendSyncArgs_Message_DEFAULT *Message

func (p *SendSyncArgs) GetMessage() *Message {
	if !p.IsSetMessage() {
		return SendSyncArgs_Message_DEFAULT
	}
	return p.Message
}

func (p *SendSyncArgs) GetTimeout() int64 {
	return p.Timeout
}
func (p *SendSyncArgs) IsSetMessage() bool {
	return p.Message != nil
}

func (p *SendSyncArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendSyncArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Message = &Message{
		PartitionId: -1,
	}
	if err := p.Message.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Message, err)
	}
	return nil
}

func (p *SendSyncArgs) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return fmt.Errorf("error reading field 2: %s", err)
	} else {
		p.Timeout = v
	}
	return nil
}

func (p *SendSyncArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendSync_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := p.writeField2(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendSyncArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("message", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:message: %s", p, err)
	}
	if err := p.Message.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Message, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:message: %s", p, err)
	}
	return err
}

func (p *SendSyncArgs) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("timeout", thrift.I64, 2); err != nil {
		return fmt.Errorf("%T write field begin error 2:timeout: %s", p, err)
	}
	if err := oprot.WriteI64(int64(p.Timeout)); err != nil {
		return fmt.Errorf("%T.timeout (2) field write error: %s", p, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 2:timeout: %s", p, err)
	}
	return err
}

func (p *SendSyncArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendSyncArgs(%+v)", *p)
}

type SendSyncResult struct {
	Success *Result `thrift:"success,0" json:"success"`
}

func NewSendSyncResult() *SendSyncResult {
	return &SendSyncResult{}
}

var SendSyncResultSuccess_DEFAULT *Result

func (p *SendSyncResult) GetSuccess() *Result {
	if !p.IsSetSuccess() {
		return SendSyncResultSuccess_DEFAULT
	}
	return p.Success
}
func (p *SendSyncResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *SendSyncResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendSyncResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &Result{}
	if err := p.Success.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Success, err)
	}
	return nil
}

func (p *SendSyncResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendSync_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendSyncResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.Success, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *SendSyncResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendSyncResult(%+v)", *p)
}

type SendBatchSyncArgs struct {
	Messages []*Message `thrift:"messages,1" json:"messages"`
}

func NewSendBatchSyncArgs() *SendBatchSyncArgs {
	return &SendBatchSyncArgs{}
}

func (p *SendBatchSyncArgs) GetMessages() []*Message {
	return p.Messages
}
func (p *SendBatchSyncArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendBatchSyncArgs) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return fmt.Errorf("error reading list begin: %s", err)
	}
	tSlice := make([]*Message, 0, size)
	p.Messages = tSlice
	for i := 0; i < size; i++ {
		_elem20 := &Message{
			PartitionId: -1,
		}
		if err := _elem20.Read(iprot); err != nil {
			return fmt.Errorf("%T error reading struct: %s", _elem20, err)
		}
		p.Messages = append(p.Messages, _elem20)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return fmt.Errorf("error reading list end: %s", err)
	}
	return nil
}

func (p *SendBatchSyncArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendBatchSync_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendBatchSyncArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("messages", thrift.LIST, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:messages: %s", p, err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Messages)); err != nil {
		return fmt.Errorf("error writing list begin: %s", err)
	}
	for _, v := range p.Messages {
		if err := v.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", v, err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return fmt.Errorf("error writing list end: %s", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:messages: %s", p, err)
	}
	return err
}

func (p *SendBatchSyncArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendBatchSyncArgs(%+v)", *p)
}

type SendBatchSyncResult struct {
	Success *Result `thrift:"success,0" json:"success"`
}

func NewSendBatchSyncResult() *SendBatchSyncResult {
	return &SendBatchSyncResult{}
}

var SendBatchSyncResultSuccess_DEFAULT *Result

func (p *SendBatchSyncResult) GetSuccess() *Result {
	if !p.IsSetSuccess() {
		return SendBatchSyncResultSuccess_DEFAULT
	}
	return p.Success
}
func (p *SendBatchSyncResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *SendBatchSyncResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendBatchSyncResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &Result{}
	if err := p.Success.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Success, err)
	}
	return nil
}

func (p *SendBatchSyncResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendBatchSync_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendBatchSyncResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.Success, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *SendBatchSyncResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendBatchSyncResult(%+v)", *p)
}

type SendAsyncArgs struct {
	Message *Message `thrift:"message,1" json:"message"`
}

func NewSendAsyncArgs() *SendAsyncArgs {
	return &SendAsyncArgs{}
}

var SendAsyncArgs_Message_DEFAULT *Message

func (p *SendAsyncArgs) GetMessage() *Message {
	if !p.IsSetMessage() {
		return SendAsyncArgs_Message_DEFAULT
	}
	return p.Message
}
func (p *SendAsyncArgs) IsSetMessage() bool {
	return p.Message != nil
}

func (p *SendAsyncArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendAsyncArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Message = &Message{
		PartitionId: -1,
	}
	if err := p.Message.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Message, err)
	}
	return nil
}

func (p *SendAsyncArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendAsync_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendAsyncArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("message", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:message: %s", p, err)
	}
	if err := p.Message.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.Message, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:message: %s", p, err)
	}
	return err
}

func (p *SendAsyncArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendAsyncArgs(%+v)", *p)
}

type SendAsyncResult struct {
	Success *Result `thrift:"success,0" json:"success"`
}

func NewSendAsyncResult() *SendAsyncResult {
	return &SendAsyncResult{}
}

var SendAsyncResultSuccess_DEFAULT *Result

func (p *SendAsyncResult) GetSuccess() *Result {
	if !p.IsSetSuccess() {
		return SendAsyncResultSuccess_DEFAULT
	}
	return p.Success
}
func (p *SendAsyncResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *SendAsyncResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendAsyncResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &Result{}
	if err := p.Success.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Success, err)
	}
	return nil
}

func (p *SendAsyncResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendAsync_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendAsyncResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.Success, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *SendAsyncResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendAsyncResult(%+v)", *p)
}

type SendDelaySyncArgs struct {
	DelayMessage *DelayMessage `thrift:"delayMessage,1" json:"delayMessage"`
	Timeout      int64         `thrift:"timeout,2" json:"timeout"`
}

func NewSendDelaySyncArgs() *SendDelaySyncArgs {
	return &SendDelaySyncArgs{}
}

var SendDelaySyncArgs_DelayMessage_DEFAULT *DelayMessage

func (p *SendDelaySyncArgs) GetDelayMessage() *DelayMessage {
	if !p.IsSetDelayMessage() {
		return SendDelaySyncArgs_DelayMessage_DEFAULT
	}
	return p.DelayMessage
}

func (p *SendDelaySyncArgs) GetTimeout() int64 {
	return p.Timeout
}
func (p *SendDelaySyncArgs) IsSetDelayMessage() bool {
	return p.DelayMessage != nil
}

func (p *SendDelaySyncArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendDelaySyncArgs) ReadField1(iprot thrift.TProtocol) error {
	p.DelayMessage = &DelayMessage{}
	if err := p.DelayMessage.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.DelayMessage, err)
	}
	return nil
}

func (p *SendDelaySyncArgs) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return fmt.Errorf("error reading field 2: %s", err)
	} else {
		p.Timeout = v
	}
	return nil
}

func (p *SendDelaySyncArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendDelaySync_args"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := p.writeField2(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendDelaySyncArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("delayMessage", thrift.STRUCT, 1); err != nil {
		return fmt.Errorf("%T write field begin error 1:delayMessage: %s", p, err)
	}
	if err := p.DelayMessage.Write(oprot); err != nil {
		return fmt.Errorf("%T error writing struct: %s", p.DelayMessage, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 1:delayMessage: %s", p, err)
	}
	return err
}

func (p *SendDelaySyncArgs) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("timeout", thrift.I64, 2); err != nil {
		return fmt.Errorf("%T write field begin error 2:timeout: %s", p, err)
	}
	if err := oprot.WriteI64(int64(p.Timeout)); err != nil {
		return fmt.Errorf("%T.timeout (2) field write error: %s", p, err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return fmt.Errorf("%T write field end error 2:timeout: %s", p, err)
	}
	return err
}

func (p *SendDelaySyncArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendDelaySyncArgs(%+v)", *p)
}

type SendDelaySyncResult struct {
	Success *DelayResult `thrift:"success,0" json:"success"`
}

func NewSendDelaySyncResult() *SendDelaySyncResult {
	return &SendDelaySyncResult{}
}

var SendDelaySyncResultSuccess_DEFAULT *DelayResult

func (p *SendDelaySyncResult) GetSuccess() *DelayResult {
	if !p.IsSetSuccess() {
		return SendDelaySyncResultSuccess_DEFAULT
	}
	return p.Success
}
func (p *SendDelaySyncResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *SendDelaySyncResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return fmt.Errorf("%T read error: %s", p, err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return fmt.Errorf("%T field %d read error: %s", p, fieldId, err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return fmt.Errorf("%T read struct end error: %s", p, err)
	}
	return nil
}

func (p *SendDelaySyncResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &DelayResult{}
	if err := p.Success.Read(iprot); err != nil {
		return fmt.Errorf("%T error reading struct: %s", p.Success, err)
	}
	return nil
}

func (p *SendDelaySyncResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("sendDelaySync_result"); err != nil {
		return fmt.Errorf("%T write struct begin error: %s", p, err)
	}
	if err := p.writeField0(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return fmt.Errorf("write field stop error: %s", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return fmt.Errorf("write struct stop error: %s", err)
	}
	return nil
}

func (p *SendDelaySyncResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return fmt.Errorf("%T write field begin error 0:success: %s", p, err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return fmt.Errorf("%T error writing struct: %s", p.Success, err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return fmt.Errorf("%T write field end error 0:success: %s", p, err)
		}
	}
	return err
}

func (p *SendDelaySyncResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SendDelaySyncResult(%+v)", *p)
}
