/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.boot;

import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;

public class DownloadUtils {
    private static final String ARTHAS_VERSIONS_URL = "https://arthas.aliyun.com/api/versions";
    private static final String ARTHAS_LATEST_VERSIONS_URL = "https://arthas.aliyun.com/api/latest_version";
    private static final String ARTHAS_DOWNLOAD_URL = "https://arthas.aliyun.com/download/${VERSION}?mirror=${REPO}";
    private static final int CONNECTION_TIMEOUT = 3000;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readLatestReleaseVersion() {
        String string;
        InputStream inputStream = null;
        try {
            URLConnection connection = DownloadUtils.openURLConnection(ARTHAS_LATEST_VERSIONS_URL);
            inputStream = connection.getInputStream();
            string = IOUtils.toString(inputStream).trim();
        }
        catch (Throwable t) {
            try {
                AnsiLog.error("Can not read arthas version from: https://arthas.aliyun.com/api/latest_version");
                AnsiLog.debug(t);
            }
            catch (Throwable throwable) {
                IOUtils.close(inputStream);
                throw throwable;
            }
            IOUtils.close(inputStream);
            return null;
        }
        IOUtils.close(inputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> readRemoteVersions() {
        ArrayList<String> arrayList;
        InputStream inputStream = null;
        try {
            URLConnection connection = DownloadUtils.openURLConnection(ARTHAS_VERSIONS_URL);
            inputStream = connection.getInputStream();
            String versionsStr = IOUtils.toString(inputStream);
            String[] versions = versionsStr.split("\r\n");
            ArrayList<String> result = new ArrayList<String>();
            for (String version : versions) {
                result.add(version.trim());
            }
            arrayList = result;
        }
        catch (Throwable t) {
            try {
                AnsiLog.error("Can not read arthas versions from: https://arthas.aliyun.com/api/versions");
                AnsiLog.debug(t);
            }
            catch (Throwable throwable) {
                IOUtils.close(inputStream);
                throw throwable;
            }
            IOUtils.close(inputStream);
            return null;
        }
        IOUtils.close(inputStream);
        return arrayList;
    }

    private static String getRepoUrl(String repoUrl, boolean http) {
        if (repoUrl.endsWith("/")) {
            repoUrl = repoUrl.substring(0, repoUrl.length() - 1);
        }
        if (http && repoUrl.startsWith("https")) {
            repoUrl = "http" + repoUrl.substring("https".length());
        }
        return repoUrl;
    }

    public static void downArthasPackaging(String repoMirror, boolean http, String arthasVersion, String savePath) throws IOException {
        String repoUrl = DownloadUtils.getRepoUrl(ARTHAS_DOWNLOAD_URL, http);
        File unzipDir = new File(savePath, arthasVersion + File.separator + "arthas");
        File tempFile = File.createTempFile("arthas", "arthas");
        AnsiLog.debug("Arthas download temp file: " + tempFile.getAbsolutePath());
        String remoteDownloadUrl = repoUrl.replace("${REPO}", repoMirror).replace("${VERSION}", arthasVersion);
        AnsiLog.info("Start download arthas from remote server: " + remoteDownloadUrl);
        DownloadUtils.saveUrl(tempFile.getAbsolutePath(), remoteDownloadUrl, true);
        AnsiLog.info("Download arthas success.");
        IOUtils.unzip(tempFile.getAbsolutePath(), unzipDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveUrl(String filename, String urlString, boolean printProgress) throws IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            String contentLength;
            URLConnection connection = DownloadUtils.openURLConnection(urlString);
            in = new BufferedInputStream(connection.getInputStream());
            List<String> values = connection.getHeaderFields().get("Content-Length");
            int fileSize = 0;
            if (values != null && !values.isEmpty() && (contentLength = values.get(0)) != null) {
                fileSize = Integer.parseInt(contentLength);
            }
            fout = new FileOutputStream(filename);
            byte[] data = new byte[0x100000];
            int totalCount = 0;
            long lastPrintTime = System.currentTimeMillis();
            while ((count = in.read(data, 0, 0x100000)) != -1) {
                long now;
                totalCount += count;
                if (printProgress && (now = System.currentTimeMillis()) - lastPrintTime > 1000L) {
                    AnsiLog.info("File size: {}, downloaded size: {}, downloading ...", DownloadUtils.formatFileSize(fileSize), DownloadUtils.formatFileSize(totalCount));
                    lastPrintTime = now;
                }
                fout.write(data, 0, count);
            }
        }
        catch (SSLException e) {
            try {
                AnsiLog.error("TLS connect error, please try to add --use-http argument.");
                AnsiLog.error("URL: " + urlString);
                AnsiLog.error(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                IOUtils.close(fout);
                throw throwable;
            }
            IOUtils.close(in);
            IOUtils.close(fout);
        }
        IOUtils.close(in);
        IOUtils.close(fout);
    }

    private static URLConnection openURLConnection(String url) throws MalformedURLException, IOException {
        URLConnection connection = new URL(url).openConnection();
        if (connection instanceof HttpURLConnection) {
            connection.setConnectTimeout(3000);
            int status = ((HttpURLConnection)connection).getResponseCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                String newUrl = connection.getHeaderField("Location");
                AnsiLog.debug("Try to open url: {}, redirect to: {}", url, newUrl);
                return DownloadUtils.openURLConnection(newUrl);
            }
        }
        return connection;
    }

    private static String formatFileSize(long size) {
        double b = size;
        double k = (double)size / 1024.0;
        double m = (double)size / 1024.0 / 1024.0;
        double g = (double)size / 1024.0 / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : (k > 1.0 ? dec.format(k).concat(" KB") : dec.format(b).concat(" Bytes"))));
        return hrSize;
    }
}

