/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.deps.io.netty.bootstrap.Bootstrap;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInitializer;
import com.alibaba.arthas.deps.io.netty.channel.ChannelOption;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPipeline;
import com.alibaba.arthas.deps.io.netty.channel.EventLoopGroup;
import com.alibaba.arthas.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.arthas.deps.io.netty.channel.socket.SocketChannel;
import com.alibaba.arthas.deps.io.netty.channel.socket.nio.NioSocketChannel;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.QueryStringEncoder;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.alibaba.arthas.deps.io.netty.handler.ssl.SslContext;
import com.alibaba.arthas.deps.io.netty.handler.ssl.SslContextBuilder;
import com.alibaba.arthas.deps.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.alibaba.arthas.deps.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.arthas.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.TunnelClientSocketClientHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;

public class TunnelClient {
    private static final Logger logger = LoggerFactory.getLogger(TunnelClient.class);
    private String tunnelServerUrl;
    private int reconnectDelay = 5;
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup(2, new DefaultThreadFactory("arthas-TunnelClient", true));
    private String appName;
    private volatile String id;
    private String version = "unknown";
    private volatile boolean connected = false;

    public ChannelFuture start() throws IOException, InterruptedException, URISyntaxException {
        return this.connect(false);
    }

    public ChannelFuture connect(boolean reconnect) throws SSLException, URISyntaxException, InterruptedException {
        String host;
        QueryStringEncoder queryEncoder = new QueryStringEncoder(this.tunnelServerUrl);
        queryEncoder.addParam("method", "agentRegister");
        queryEncoder.addParam("arthasVersion", this.version);
        if (this.appName != null) {
            queryEncoder.addParam("appName", this.appName);
        }
        if (this.id != null) {
            queryEncoder.addParam("id", this.id);
        }
        URI agentRegisterURI = queryEncoder.toUri();
        logger.info("Try to register arthas agent, uri: {}", (Object)agentRegisterURI);
        String scheme = agentRegisterURI.getScheme() == null ? "ws" : agentRegisterURI.getScheme();
        String string = host = agentRegisterURI.getHost() == null ? "127.0.0.1" : agentRegisterURI.getHost();
        final int port = agentRegisterURI.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : agentRegisterURI.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Only WS(S) is supported. tunnelServerUrl: " + this.tunnelServerUrl);
        }
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        WebSocketClientHandshaker newHandshaker = WebSocketClientHandshakerFactory.newHandshaker(agentRegisterURI, WebSocketVersion.V13, null, true, new DefaultHttpHeaders());
        final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(newHandshaker);
        final TunnelClientSocketClientHandler handler = new TunnelClientSocketClientHandler(this);
        Bootstrap bs = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bs.group(this.eventLoopGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).option(ChannelOption.TCP_NODELAY, true)).channel(NioSocketChannel.class)).remoteAddress(host, port).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(sslCtx.newHandler(ch.alloc(), host, port));
                }
                p.addLast(new HttpClientCodec(), new HttpObjectAggregator(0x800000), websocketClientHandler, new IdleStateHandler(0, 0, 60), handler);
            }
        });
        ChannelFuture connectFuture = bs.connect();
        if (reconnect) {
            connectFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.cause() != null) {
                        logger.error("connect to tunnel server error, uri: {}", (Object)TunnelClient.this.tunnelServerUrl, (Object)future.cause());
                    }
                }
            });
        }
        connectFuture.sync();
        return handler.registerFuture();
    }

    public void stop() {
        this.eventLoopGroup.shutdownGracefully();
    }

    public String getTunnelServerUrl() {
        return this.tunnelServerUrl;
    }

    public void setTunnelServerUrl(String tunnelServerUrl) {
        this.tunnelServerUrl = tunnelServerUrl;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }
}

