/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AccessPoint;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.model.WatchModel;
import com.taobao.arthas.core.command.monitor200.WatchCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import java.util.Date;

class WatchAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WatchAdviceListener.class);
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private WatchCommand command;
    private CommandProcess process;

    public WatchAdviceListener(WatchCommand command, CommandProcess process, boolean verbose) {
        this.command = command;
        this.process = process;
        super.setVerbose(verbose);
    }

    private boolean isFinish() {
        return this.command.isFinish() || !this.command.isBefore() && !this.command.isException() && !this.command.isSuccess();
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
        if (this.command.isBefore()) {
            this.watching(Advice.newForBefore(loader, clazz, method, target, args));
        }
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        Advice advice = Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject);
        if (this.command.isSuccess()) {
            this.watching(advice);
        }
        this.finishing(advice);
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        Advice advice = Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable);
        if (this.command.isException()) {
            this.watching(advice);
        }
        this.finishing(advice);
    }

    private void finishing(Advice advice) {
        if (this.isFinish()) {
            this.watching(advice);
        }
    }

    private void watching(Advice advice) {
        try {
            double cost = this.threadLocalWatch.costInMillis();
            boolean conditionResult = this.isConditionMet(this.command.getConditionExpress(), advice, cost);
            if (this.isVerbose()) {
                this.process.write("Condition express: " + this.command.getConditionExpress() + " , result: " + conditionResult + "\n");
            }
            if (conditionResult) {
                Object value = this.getExpressionResult(this.command.getExpress(), advice, cost);
                WatchModel model = new WatchModel();
                model.setTs(new Date());
                model.setCost(cost);
                model.setValue(value);
                model.setExpand(this.command.getExpand());
                model.setSizeLimit(this.command.getSizeLimit());
                model.setClassName(advice.getClazz().getName());
                model.setMethodName(advice.getMethod().getName());
                if (advice.isBefore()) {
                    model.setAccessPoint(AccessPoint.ACCESS_BEFORE.getKey());
                } else if (advice.isAfterReturning()) {
                    model.setAccessPoint(AccessPoint.ACCESS_AFTER_RETUNING.getKey());
                } else if (advice.isAfterThrowing()) {
                    model.setAccessPoint(AccessPoint.ACCESS_AFTER_THROWING.getKey());
                }
                this.process.appendResult(model);
                this.process.times().incrementAndGet();
                if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
                    this.abortProcess(this.process, this.command.getNumberOfLimit());
                }
            }
        }
        catch (Throwable e) {
            logger.warn("watch failed.", e);
            this.process.end(-1, "watch failed, condition is: " + this.command.getConditionExpress() + ", express is: " + this.command.getExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.");
        }
    }
}

