/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.config;

import com.taobao.arthas.core.config.Config;
import com.taobao.arthas.core.config.NestedConfig;
import com.taobao.arthas.core.env.Environment;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BinderUtils {
    public static void inject(Environment environment, Object instance) {
        BinderUtils.inject(environment, null, null, instance);
    }

    public static void inject(Environment environment, String prefix, Object instance) {
        BinderUtils.inject(environment, null, prefix, instance);
    }

    public static void inject(Environment environment, String parentPrefix, String prefix, Object instance) {
        Class<?> type = instance.getClass();
        try {
            Config annotation = type.getAnnotation(Config.class);
            if (prefix == null) {
                prefix = "";
            }
            if (annotation == null) {
                prefix = parentPrefix + '.' + prefix;
            } else {
                prefix = annotation.prefix();
                if (prefix != null && parentPrefix != null && parentPrefix.length() > 0) {
                    prefix = parentPrefix + '.' + prefix;
                }
            }
            Method[] declaredMethods = type.getDeclaredMethods();
            if (declaredMethods != null) {
                Method[] methodArray = declaredMethods;
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Object reslovedValue;
                    Method method = methodArray[i];
                    String methodName = method.getName();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes == null || parameterTypes.length != 1 || !methodName.startsWith("set") || methodName.length() <= "set".length()) continue;
                    String field = BinderUtils.getFieldNameFromSetterMethod(methodName);
                    String configKey = prefix + '.' + field;
                    if (!environment.containsProperty(configKey) || (reslovedValue = environment.getProperty(prefix + '.' + field, parameterTypes[0])) == null) continue;
                    method.invoke(instance, reslovedValue);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("inject error. prefix: " + prefix + ", instance: " + instance, e);
        }
        Field[] fields = type.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                NestedConfig nestedConfig = field.getAnnotation(NestedConfig.class);
                if (nestedConfig == null) continue;
                String prefixForField = field.getName();
                if (parentPrefix != null && prefix.length() > 0) {
                    prefixForField = prefix + '.' + prefixForField;
                }
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(instance);
                    if (fieldValue == null) {
                        fieldValue = field.getType().newInstance();
                    }
                    BinderUtils.inject(environment, prefix, prefixForField, fieldValue);
                    field.set(instance, fieldValue);
                }
                catch (Exception e) {
                    throw new RuntimeException("process @NestedConfig error, field: " + field + ", prefix: " + prefix + ", instance: " + instance, e);
                }
            }
        }
    }

    private static String getFieldNameFromSetterMethod(String methodName) {
        String field = methodName.substring("set".length());
        String startPart = field.substring(0, 1).toLowerCase();
        String endPart = field.substring(1);
        field = startPart + endPart;
        return field;
    }
}

