/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.session.impl;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.distribution.ResultConsumer;
import com.taobao.arthas.core.distribution.SharingResultDistributor;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.session.SessionManager;
import com.taobao.arthas.core.shell.session.impl.SessionImpl;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobController;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SessionManagerImpl
implements SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManagerImpl.class);
    private final InternalCommandManager commandManager;
    private final Instrumentation instrumentation;
    private final JobController jobController;
    private final long sessionTimeoutMillis;
    private final int consumerTimeoutMillis;
    private final long reaperInterval;
    private final Map<String, Session> sessions;
    private final long pid;
    private boolean closed = false;
    private ScheduledExecutorService scheduledExecutorService;

    public SessionManagerImpl(ShellServerOptions options, InternalCommandManager commandManager, JobController jobController) {
        this.commandManager = commandManager;
        this.jobController = jobController;
        this.sessions = new ConcurrentHashMap<String, Session>();
        this.sessionTimeoutMillis = options.getSessionTimeout();
        this.consumerTimeoutMillis = 300000;
        this.reaperInterval = options.getReaperInterval();
        this.instrumentation = options.getInstrumentation();
        this.pid = options.getPid();
        this.setEvictTimer();
    }

    @Override
    public Session createSession() {
        SessionImpl session = new SessionImpl();
        session.put("arthas-command-manager", this.commandManager);
        session.put("instrumentation", this.instrumentation);
        session.put("pid", this.pid);
        String sessionId = UUID.randomUUID().toString();
        session.put("id", sessionId);
        this.sessions.put(sessionId, session);
        return session;
    }

    @Override
    public Session getSession(String sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public Session removeSession(String sessionId) {
        return this.sessions.remove(sessionId);
    }

    @Override
    public void updateAccessTime(Session session) {
        session.setLastAccessTime(System.currentTimeMillis());
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        ArrayList<Session> sessions = new ArrayList<Session>(this.sessions.values());
        for (Session session : sessions) {
            SharingResultDistributor resultDistributor = session.getResultDistributor();
            if (resultDistributor != null) {
                resultDistributor.appendResult(new MessageModel("arthas server is going to shutdown."));
                resultDistributor.close();
            }
            logger.info("Removing session before shutdown: {}, last access time: {}", (Object)session.getSessionId(), (Object)session.getLastAccessTime());
            this.removeSession(session.getSessionId());
        }
        this.jobController.close();
    }

    private synchronized void setEvictTimer() {
        if (!this.closed && this.reaperInterval > 0L) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "arthas-session-manager");
                    t.setDaemon(true);
                    return t;
                }
            });
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    SessionManagerImpl.this.evictSessions();
                }
            }, 0L, this.reaperInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void evictSessions() {
        long now = System.currentTimeMillis();
        ArrayList<Session> toClose = new ArrayList<Session>();
        for (Session session : this.sessions.values()) {
            if (now - session.getLastAccessTime() > this.sessionTimeoutMillis && session.getForegroundJob() == null) {
                toClose.add(session);
            }
            this.evictConsumers(session);
        }
        for (Session session : toClose) {
            Job job = session.getForegroundJob();
            if (job != null) {
                job.interrupt();
            }
            long timeOutInMinutes = this.sessionTimeoutMillis / 1000L / 60L;
            String reason = "session is inactive for " + timeOutInMinutes + " min(s).";
            SharingResultDistributor resultDistributor = session.getResultDistributor();
            if (resultDistributor != null) {
                resultDistributor.appendResult(new MessageModel(reason));
            }
            this.removeSession(session.getSessionId());
            logger.info("Removing inactive session: {}, last access time: {}", (Object)session.getSessionId(), (Object)session.getLastAccessTime());
        }
    }

    public void evictConsumers(Session session) {
        SharingResultDistributor distributor = session.getResultDistributor();
        if (distributor != null && distributor instanceof SharingResultDistributor) {
            SharingResultDistributor sharingResultDistributor = distributor;
            List<ResultConsumer> consumers = sharingResultDistributor.getConsumers();
            long now = System.currentTimeMillis();
            for (ResultConsumer consumer : consumers) {
                long inactiveTime = now - consumer.getLastAccessTime();
                if (inactiveTime <= (long)this.consumerTimeoutMillis) continue;
                logger.info("Removing inactive consumer from session, sessionId: {}, consumerId: {}, inactive duration: {}", session.getSessionId(), consumer.getConsumerId(), inactiveTime);
                consumer.appendResult(new MessageModel("consumer is inactive for a while, please refresh the page."));
                sharingResultDistributor.removeConsumer(consumer);
            }
        }
    }

    @Override
    public InternalCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public JobController getJobController() {
        return this.jobController;
    }
}

